Tree.Item = Class.create();
Tree.Item.prototype = {
	initialize: function(id, tree, parent, index, switchType, toggleOnClick) {
		this.index = index;
		this.parent = parent;
		this.id = id;
		this.switchType = switchType;
		this.tree = $(tree);
		this.elements = {};
		($(id)).object = this;
		this.toggleOnClick = toggleOnClick;
		this.getElements();

		this.eventSelectionClick = this.toggleSelection.bindAsEventListener(this);
		this.eventMouseOut = this.processMouseOut.bindAsEventListener(this);
		this.eventMouseOver = this.processMouseOver.bindAsEventListener(this);

		if (this.onContextMenu) {
			this.eventRightClick = this.onContextMenu.bindAsEventListener();
		}
	
		this.observeEvents();
	},
	
	observeEvents: function() {
		Event.observe(this.elements.icon, "mousedown", this.eventSelectionClick);
		Event.observe(this.elements.text, "mousedown", this.eventSelectionClick);
		Event.observe(this.elements.icon, "mouseout", this.eventMouseOut);
		Event.observe(this.elements.text, "mouseout", this.eventMouseOut);
		Event.observe(this.elements.icon, "mouseover", this.eventMouseOver);
		Event.observe(this.elements.text, "mouseover", this.eventMouseOver);

		if (this.switchType=="client" && this.childs.length > 0) {
			this.eventCollapsionClick = this.toggleCollapsion.bindAsEventListener(this);
			if (this.toggleOnClick) {
				if (this.elements.mainRow)
					Event.observe(this.elements.mainRow, "click", this.eventCollapsionClick);
			} else {
				if (this.elements.handle)
					Event.observe(this.elements.handle, "click", this.eventCollapsionClick);
			}
		}

		if (this.eventRightClick) {
			this.elements.icon.oncontextmenu = this.eventRightClick;
			this.elements.text.oncontextmenu = this.eventRightClick;
		}
	},
	
	getElements: function() {
		($(this.id)).object = this;
		this.childs = [];
		var childsRowId = this.id + Tree.ID_DEVIDER + Tree.ID_CHILDS_ROW;
		var mainRowId = this.id + Tree.ID_DEVIDER + Tree.ID_MAIN_ROW;
		this.elements.row = $(childsRowId);
		var handleId = this.id + Tree.ID_DEVIDER + Tree.ID_HANDLE;
		this.elements.handle = $(handleId);
		this.elements.handleImgExpanded = $(handleId + Tree.ID_DEVIDER + Tree.ID_HANDLE_IMG_EXPANDED);
		this.elements.handleImgCollapsed = $(handleId + Tree.ID_DEVIDER + Tree.ID_HANDLE_IMG_COLLAPSED);
		this.elements.icon = $(this.id + Tree.ID_DEVIDER + Tree.ID_ICON);
		this.elements.text = $(this.id + Tree.ID_DEVIDER + Tree.ID_TEXT);
		
		var contextMenu = Richfaces.getNSAttribute("oncontextmenu", this.elements.icon);
		if (contextMenu && contextMenu.length > 0) {
			this.onContextMenu = new Function(contextMenu + "; return true;");
		}
		
		var childsTd = $(childsRowId + Tree.ID_DEVIDER + Tree.ID_CHILDS_TD);
		if (childsTd) {
			for (var i = 0; i < childsTd.childNodes.length; i++) {
				var child = childsTd.childNodes[i];
				if (child.nodeType == 1 && child.tagName.toLowerCase() == "table") {
					this.addChild(new Tree.Item(child.id, this.tree, this, this.childs.length, this.switchType, this.toggleOnClick));
				}
			}
		}
		
		this.elements.mainRow = $(mainRowId);
	},

	addChild: function(child) {
		this.childs.push(child);
		this.tree.addItem(child);
	},

	fireExpansionEvent: function() {
		var props = new Object();
		props[Richfaces.TreeExpandEvent] = true;
		props["expandedNode"] = this.id;			
		props["treeItem"] = this;			
		Richfaces.createEvent("click", this.tree.element, null, props).fire();
	},

	fireCollapsionEvent: function() {
		var props = new Object();
		props[Richfaces.TreeCollapseEvent] = true;
		props["collapsedNode"] = this.id;			
		props["treeItem"] = this;			
		Richfaces.createEvent("click", this.tree.element, null, props).fire();
	},

	toggleCollapsion: function() {

		if (this.hasChilds()) Element.toggle(this.elements.row);
		
		// Rerender main row to avoid bad representation in Opera and Konqueror/Safari
		if (this.elements.mainRow) {
			Element.hide(this.elements.mainRow);
			Element.show(this.elements.mainRow);
		}
		
		if (this.isCollapsed()) {
			this.elements.handleImgExpanded.style.display="none";
			this.elements.handleImgCollapsed.style.display="";
			if(Element.hasClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED)) {
				Element.removeClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED);
				Element.addClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED);
			}
			
			this.fireCollapsionEvent();
		} else {
			this.elements.handleImgExpanded.style.display="";
			this.elements.handleImgCollapsed.style.display="none";
			if(Element.hasClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED)) {
				Element.removeClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED);
				Element.addClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED);
			}

			this.fireExpansionEvent();
		}

	},

	getRichAttribute: function(name) {
		return Richfaces.getNSAttribute(name, this.elements.icon);
	},

	collapse: function() {
		if (!this.isCollapsed() && this.switchType!="client") {
			if (this.toggleOnClick) {
				if (this.elements.mainRow)
					this.elements.mainRow.onclick(); 
			} else {
				if (this.elements.handle)
					this.elements.handle.onclick();
			}
		}
		if (this.hasChilds() && !this.isCollapsed()) {
			Element.hide(this.elements.row);
			this.elements.handleImgExpanded.style.display="none";
			this.elements.handleImgCollapsed.style.display="";
			if(Element.hasClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED)) {
				Element.removeClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED);
				Element.addClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED);
			}
		}

		this.fireCollapsionEvent();
	},

	expand: function() {
		if (this.isCollapsed() && this.switchType!="client") {
			if (this.toggleOnClick) {
				if (this.elements.mainRow)
					this.elements.mainRow.onclick(); 
			} else {
				if (this.elements.handle)
					this.elements.handle.onclick();
			}
		}
		if (this.hasChilds() && this.isCollapsed()) {
			Element.show(this.elements.row);
			this.elements.handleImgExpanded.style.display="";
			this.elements.handleImgCollapsed.style.display="none";
			if(Element.hasClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED)) {
				Element.removeClassName(this.elements.icon, Tree.CLASS_ITEM_COLLAPSED);
				Element.addClassName(this.elements.icon, Tree.CLASS_ITEM_EXPANDED);
			}
		}

		this.fireExpansionEvent();
	},

	isCollapsed: function() {
		if (this.elements.row != null) {
			return this.elements.row.style.display == "none";
		} else {
			return true;
		}
	},

	processMouseOut: function(e) {
		if (this.isMouseIn) {
			this.isMouseIn = false;
			var hClass = Richfaces.getNSAttribute("highlightedclass", this.elements.text);
			if (hClass) {
				var classNames = hClass.split(' ')
				for (var i = 0; i < classNames.length; i++) {
					Element.removeClassName(this.elements.text, classNames[i]);
				}
				if (window.drag){
					this.dragLeave(e);
				}		
			}
		}
	},

	processMouseOver: function(e) {
		if(!this.isMouseIn) {
			this.isMouseIn = true;
			var hClass = Richfaces.getNSAttribute("highlightedclass", this.elements.text);
			if (hClass) {
				var classNames = hClass.split(' ')
				for (var i = 0; i < classNames.length; i++) {
					Element.addClassName(this.elements.text, classNames[i]);
				}
				if (window.drag) {
					this.dragEnter(e);
				}	
			}
		}
	},

	toggleSelection: function(e) {
		if (e && !e[Richfaces.TreeSelectEvent] && !Richfaces.eventIsSynthetic(e)) {
			if (e && e.type == "mousedown" /* can be keydown */) {
				if(Event.isLeftClick(e)) {    
				  var src = Event.element(e);
				  if(src.tagName && (
					src.tagName=='INPUT' ||
					src.tagName=='SELECT' ||
					src.tagName=='OPTION' ||
					src.tagName=='BUTTON' ||
					src.tagName=='TEXTAREA')) return;
		
					Event.stop(e);
				} else {
					//do not process non-left clicks					
					return ;
				}
			}

			var props = new Object();
			props[Richfaces.TreeSelectEvent] = true;
			props["originatingEventType"] = e.type;			
			props["treeItem"] = this;			
			props["selectedNode"] = this.id;			
			var evt = Richfaces.createEvent("click", this.tree.element, null, props);
			evt.fire();
			
			return !evt.event["cancelSelection"];
		} else {
			this.tree.deselectAll();
	
			/*
			var attr = this.elements.text.attributes;
			var s = "";
			for (var i = 0; i < attr.length; i++) {
				s += attr[i].nodeName + ": " + attr[i].nodeValue + ";  ";
			}
			
			alert(s);
			*/
			
			var sClass = Richfaces.getNSAttribute("selectedclass", this.elements.text);
			if (sClass) {
		
				var classNames = sClass.split(' ')
				for (var i = 0; i < classNames.length; i++) {
					Element.addClassName(this.elements.text, classNames[i]);
				}
				this.tree.input.value = this.id;
				this.tree.selectionManager.activeItem = this;
			
				if (this.tree.options.onSelection) this.tree.options.onSelection(this.id);
				this.tree.showNode(this.elements.text.parentNode);
		
				if (e && e["originatingEventType"] == "mousedown" /* can be keydown */) {
					this.startDrag(e);
				}
			}
		
			return true;
		}
	},

	isSelected: function() {
		return Element.hasClassName(this.elements.text, Tree.CLASS_ITEM_SELECTED);
	},

	deselect: function() {
		var sClass = Richfaces.getNSAttribute("selectedclass", this.elements.text);
		if (sClass) {
			var classNames = sClass.split(' ')
			for (var i = 0; i < classNames.length; i++) {
				Element.removeClassName(this.elements.text, classNames[i]);
			}
		}
	},

	next: function() {
		if (this.index < (this.parent.childs.length - 1)) {
			return this.parent.childs[this.index + 1];
		} else {
			return this;
		}
	},

	previous: function() {
		if (this.index > 0) {
			return this.parent.childs[this.index - 1];
		} else {
			return this;
		}
	},

	hasChilds: function() {
		return this.childs.length > 0;
	}
}
