/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.policy.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.factory.OMXMLBuilderFactory;
import org.apache.ws.policy.AndCompositeAssertion;
import org.apache.ws.policy.Assertion;
import org.apache.ws.policy.Policy;
import org.apache.ws.policy.PolicyReference;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.policy.XorCompositeAssertion;
import org.apache.ws.policy.util.PolicyReader;

public class OMPolicyReader
implements PolicyReader {
    OMPolicyReader() {
    }

    public Policy readPolicy(InputStream in) {
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            StAXOMBuilder builder = OMXMLBuilderFactory.createStAXOMBuilder((OMFactory)OMAbstractFactory.getOMFactory(), (XMLStreamReader)reader);
            OMElement element = builder.getDocumentElement();
            return this.readPolicy(element);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("error : " + ex.getMessage());
        }
    }

    private Assertion readAssertion(OMElement element) {
        String namespace = element.getNamespace().getName();
        String localName = element.getLocalName();
        if (!namespace.equals("http://schemas.xmlsoap.org/ws/2004/09/policy")) {
            return this.readPrimitiveAssertion(element);
        }
        if (localName.equals("Policy")) {
            return this.readPolicy(element);
        }
        if (localName.equals("All")) {
            return this.readAndComposite(element);
        }
        if (localName.equals("ExactlyOne")) {
            return this.readXorComposite(element);
        }
        if (localName.equals("PolicyReference")) {
            return this.readPolicyReference(element);
        }
        throw new RuntimeException("unknown element ..");
    }

    public Policy readPolicy(OMElement element) {
        Policy policy = new Policy();
        OMAttribute attri = element.getAttribute(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
        if (attri != null) {
            policy.setId(attri.getAttributeValue());
        }
        if ((attri = element.getAttribute(new QName("http://www.w3.org/XML/1998/namespace", "base"))) != null) {
            policy.setBase(attri.getAttributeValue());
        }
        policy.addTerms(this.readTerms(element));
        return policy;
    }

    private AndCompositeAssertion readAndComposite(OMElement element) {
        AndCompositeAssertion andCompositeAssertion = new AndCompositeAssertion();
        andCompositeAssertion.addTerms(this.readTerms(element));
        return andCompositeAssertion;
    }

    private XorCompositeAssertion readXorComposite(OMElement element) {
        XorCompositeAssertion xorCompositeAssertion = new XorCompositeAssertion();
        xorCompositeAssertion.addTerms(this.readTerms(element));
        return xorCompositeAssertion;
    }

    public PolicyReference readPolicyReference(OMElement element) {
        OMAttribute attribute = element.getAttribute(new QName("URI"));
        return new PolicyReference(attribute.getAttributeValue());
    }

    private PrimitiveAssertion readPrimitiveAssertion(OMElement element) {
        QName qname = element.getQName();
        PrimitiveAssertion result = new PrimitiveAssertion(qname);
        result.setAttributes(this.getAttributes(element));
        String isOptional = result.getAttribute(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Optional"));
        result.setOptional(new Boolean(isOptional));
        String strValue = element.getText();
        if (strValue != null && strValue.length() != 0) {
            result.setStrValue(strValue.trim());
        }
        Iterator childElements = element.getChildElements();
        while (childElements.hasNext()) {
            OMElement childElement = (OMElement)childElements.next();
            if (childElement.getNamespace().getName().equals("http://schemas.xmlsoap.org/ws/2004/09/policy") && childElement.getLocalName().equals("Policy")) {
                Policy policy = this.readPolicy(childElement);
                result.addTerm(policy);
                continue;
            }
            PrimitiveAssertion pa = this.readPrimitiveAssertion(childElement);
            result.addTerm(pa);
        }
        return result;
    }

    private ArrayList readTerms(OMElement element) {
        ArrayList<Assertion> terms = new ArrayList<Assertion>();
        Iterator childElements = element.getChildren();
        while (childElements.hasNext()) {
            Object obj = childElements.next();
            if (!(obj instanceof OMElement)) continue;
            OMElement e = (OMElement)obj;
            terms.add(this.readAssertion(e));
        }
        return terms;
    }

    private Hashtable getAttributes(OMElement element) {
        Hashtable<QName, String> attributes = new Hashtable<QName, String>();
        Iterator iterator = element.getAllAttributes();
        while (iterator.hasNext()) {
            OMAttribute attribute = (OMAttribute)iterator.next();
            attributes.put(attribute.getQName(), attribute.getAttributeValue());
        }
        return attributes;
    }
}

