/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.marshalling;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.sunday.marshalling.AbstractAttributeMarshaller;
import org.jboss.xb.binding.sunday.marshalling.AttributeMarshaller;
import org.jboss.xb.binding.sunday.marshalling.MarshallingContext;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;

public class DefaultAttributeMarshaller
extends AbstractAttributeMarshaller {
    private final Logger log = Logger.getLogger(AttributeMarshaller.class);
    public static final DefaultAttributeMarshaller INSTANCE = new DefaultAttributeMarshaller();

    public Object getValue(MarshallingContext ctx) {
        Class<?> fieldType;
        Field field;
        Method getter;
        QName qName;
        Object owner;
        block14: {
            owner = ctx.peek();
            SchemaBinding schema = ctx.getSchemaBinding();
            AttributeBinding binding = ctx.getAttributeBinding();
            qName = binding.getQName();
            String fieldName = null;
            PropertyMetaData propertyMetaData = binding.getPropertyMetaData();
            if (propertyMetaData != null) {
                fieldName = propertyMetaData.getName();
            }
            if (fieldName == null) {
                fieldName = Util.xmlNameToFieldName(qName.getLocalPart(), schema.isIgnoreLowLine());
            }
            getter = null;
            field = null;
            fieldType = null;
            try {
                getter = Classes.getAttributeGetter(owner.getClass(), fieldName);
                fieldType = getter.getReturnType();
            }
            catch (NoSuchMethodException e) {
                try {
                    field = owner.getClass().getField(fieldName);
                    fieldType = field.getType();
                }
                catch (NoSuchFieldException e3) {
                    if (schema.isIgnoreUnresolvedFieldOrClass()) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Found neither field " + fieldName + " nor its getter in " + owner.getClass() + " for element/attribute " + qName);
                        }
                        break block14;
                    }
                    throw new JBossXBRuntimeException("Found neither field " + fieldName + " nor its getter in " + owner.getClass() + " for element/attribute " + qName);
                }
            }
        }
        Object value = null;
        if (fieldType != null) {
            if (getter != null) {
                try {
                    value = getter.invoke(owner, null);
                }
                catch (Exception e) {
                    this.log.error("Failed to invoke getter '" + getter + "' on object: " + owner);
                    throw new JBossXBRuntimeException("Failed to provide value for " + qName + " from " + owner, e);
                }
            }
            try {
                value = field.get(owner);
            }
            catch (Exception e) {
                this.log.error("Failed to invoke get on field '" + field + "' on object: " + owner);
                throw new JBossXBRuntimeException("Failed to provide value for " + qName + " from " + owner, e);
            }
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String marshalValue(MarshallingContext ctx, Object value) {
        if (value == null) {
            return null;
        }
        AttributeBinding binding = ctx.getAttributeBinding();
        TypeBinding attrType = binding.getType();
        if (attrType.getItemType() != null) {
            List<Object> list;
            TypeBinding itemType = attrType.getItemType();
            if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getQName().getNamespaceURI())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
            if (value instanceof List) {
                list = (List<Object>)value;
            } else {
                if (!value.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
                list = Arrays.asList((Object[])value);
            }
            if (!Constants.QNAME_QNAME.getLocalPart().equals(itemType.getQName().getLocalPart())) return SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
            String attrLocal = binding.getQName().getLocalPart();
            int listInd = 0;
            while (listInd < list.size()) {
                QName item = (QName)list.get(listInd);
                String itemNs = item.getNamespaceURI();
                if (itemNs != null && itemNs.length() > 0) {
                    String itemPrefix = ctx.getPrefix(itemNs);
                    if (itemPrefix == null) {
                        itemPrefix = attrLocal + listInd;
                        ctx.declareNamespace(itemPrefix, itemNs);
                    }
                    item = new QName(item.getNamespaceURI(), item.getLocalPart(), itemPrefix);
                    list.set(listInd, item);
                }
                ++listInd;
            }
            return SimpleTypeBindings.marshalList(itemType.getQName().getLocalPart(), list, null);
        }
        if (attrType.getLexicalPattern() == null) return value.toString();
        if (attrType.getBaseType() == null) return value.toString();
        if (!Constants.QNAME_BOOLEAN.equals(attrType.getBaseType().getQName())) return value.toString();
        String item = (String)attrType.getLexicalPattern().get(0);
        if (item.indexOf(48) != -1 && item.indexOf(49) != -1) {
            if ((Boolean)value == false) return "0";
            return "1";
        }
        if ((Boolean)value == false) return "false";
        return "true";
    }
}

