/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerInfoMBean;
import org.jboss.util.platform.Java;

public class ServerInfo
implements ServerInfoMBean,
MBeanRegistration {
    private static final Logger log = Logger.getLogger(ServerInfo.class);
    private static final Integer ZERO = new Integer(0);
    private MBeanServer server;
    private String hostName;
    private String hostAddress;
    private Object threadMXBean;
    private Method getMemoryPoolMXBeans;
    private Method getName;
    private Method getType;
    private Method getUsage;
    private Method getPeakUsage;
    private Method getInit;
    private Method getUsed;
    private Method getCommitted;
    private Method getMax;
    private Method getThreadInfo;
    private Method getAllThreadIds;
    private Method getThreadCpuTime;
    private Method getThreadName;
    private Method getThreadState;
    private Method getLockName;
    private Method getStackTrace;
    private Method getThreadId;

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        log.info("Java version: " + System.getProperty("java.version") + "," + System.getProperty("java.vendor"));
        log.info("Java VM: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vm.vendor"));
        log.info("OS-System: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "," + System.getProperty("os.arch"));
        log.debug("Full System Properties Dump");
        Enumeration<?> names = System.getProperties().propertyNames();
        while (names.hasMoreElements()) {
            String pname = (String)names.nextElement();
            log.debug("    " + pname + ": " + System.getProperty(pname));
        }
        if (Java.isCompatible(6)) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class clazz = cl.loadClass("java.lang.management.ManagementFactory");
                Method method = clazz.getMethod("getThreadMXBean", null);
                this.threadMXBean = method.invoke(null, null);
                this.getMemoryPoolMXBeans = clazz.getMethod("getMemoryPoolMXBeans", null);
                clazz = cl.loadClass("java.lang.management.MemoryPoolMXBean");
                this.getName = clazz.getMethod("getName", null);
                this.getType = clazz.getMethod("getType", null);
                this.getUsage = clazz.getMethod("getUsage", null);
                this.getPeakUsage = clazz.getMethod("getPeakUsage", null);
                clazz = cl.loadClass("java.lang.management.MemoryUsage");
                this.getInit = clazz.getMethod("getInit", null);
                this.getUsed = clazz.getMethod("getUsed", null);
                this.getCommitted = clazz.getMethod("getCommitted", null);
                this.getMax = clazz.getMethod("getMax", null);
                clazz = cl.loadClass("java.lang.management.ThreadMXBean");
                this.getThreadInfo = clazz.getMethod("getThreadInfo", Long.TYPE, Integer.TYPE);
                this.getAllThreadIds = clazz.getMethod("getAllThreadIds", null);
                this.getThreadCpuTime = clazz.getMethod("getThreadCpuTime", Long.TYPE);
                clazz = cl.loadClass("java.lang.management.ThreadInfo");
                this.getThreadName = clazz.getMethod("getThreadName", null);
                this.getThreadState = clazz.getMethod("getThreadState", null);
                this.getLockName = clazz.getMethod("getLockName", null);
                this.getStackTrace = clazz.getMethod("getStackTrace", null);
                clazz = Thread.class;
                this.getThreadId = clazz.getMethod("getId", null);
            }
            catch (Exception e) {
                log.debug("Cannot access platform ThreadMXBean", e);
            }
        }
        return name == null ? OBJECT_NAME : name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public String getJavaVMName() {
        return System.getProperty("java.vm.name");
    }

    public String getJavaVMVersion() {
        return System.getProperty("java.vm.version");
    }

    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor");
    }

    public String getOSName() {
        return System.getProperty("os.name");
    }

    public String getOSVersion() {
        return System.getProperty("os.version");
    }

    public String getOSArch() {
        return System.getProperty("os.arch");
    }

    public Long getTotalMemory() {
        return new Long(Runtime.getRuntime().totalMemory());
    }

    public Long getFreeMemory() {
        return new Long(Runtime.getRuntime().freeMemory());
    }

    public Long getMaxMemory() {
        if (Java.isCompatible(5)) {
            try {
                Runtime rt = Runtime.getRuntime();
                Method m = rt.getClass().getMethod("maxMemory", new Class[0]);
                return (Long)m.invoke((Object)rt, new Object[0]);
            }
            catch (Exception e) {
                log.error("Operation failed", e);
            }
        }
        return new Long(-1L);
    }

    public Integer getAvailableProcessors() {
        if (Java.isCompatible(5)) {
            try {
                Runtime rt = Runtime.getRuntime();
                Method m = rt.getClass().getMethod("availableProcessors", new Class[0]);
                return (Integer)m.invoke((Object)rt, new Object[0]);
            }
            catch (Exception e) {
                log.error("Operation failed", e);
            }
        }
        return new Integer(-1);
    }

    public String getHostName() {
        if (this.hostName == null) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.error("Error looking up local hostname", e);
                this.hostName = "<unknown>";
            }
        }
        return this.hostName;
    }

    public String getHostAddress() {
        if (this.hostAddress == null) {
            try {
                this.hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error("Error looking up local address", e);
                this.hostAddress = "<unknown>";
            }
        }
        return this.hostAddress;
    }

    public String listMemoryPools(boolean fancy) {
        if (this.getMemoryPoolMXBeans != null) {
            StringBuffer sbuf = new StringBuffer(4196);
            try {
                List poolList = (List)this.getMemoryPoolMXBeans.invoke(null, null);
                sbuf.append("<b>Total Memory Pools:</b> ").append(poolList.size());
                sbuf.append("<blockquote>");
                Iterator i = poolList.iterator();
                while (i.hasNext()) {
                    Object pool = i.next();
                    String name = (String)this.getName.invoke(pool, null);
                    Object type = this.getType.invoke(pool, null);
                    sbuf.append("<b>Pool: ").append(name);
                    sbuf.append("</b> (").append(type).append(")");
                    Object peakUsage = this.getPeakUsage.invoke(pool, null);
                    Object usage = this.getUsage.invoke(pool, null);
                    sbuf.append("<blockquote>");
                    if (usage != null && peakUsage != null) {
                        Long init = (Long)this.getInit.invoke(peakUsage, null);
                        Long used = (Long)this.getUsed.invoke(peakUsage, null);
                        Long committed = (Long)this.getCommitted.invoke(peakUsage, null);
                        Long max = (Long)this.getMax.invoke(peakUsage, null);
                        sbuf.append("Peak Usage    : ");
                        sbuf.append("init:").append(init);
                        sbuf.append(", used:").append(used);
                        sbuf.append(", committed:").append(committed);
                        sbuf.append(", max:").append(max);
                        sbuf.append("<br>");
                        init = (Long)this.getInit.invoke(usage, null);
                        used = (Long)this.getUsed.invoke(usage, null);
                        committed = (Long)this.getCommitted.invoke(usage, null);
                        max = (Long)this.getMax.invoke(usage, null);
                        sbuf.append("Current Usage : ");
                        sbuf.append("init:").append(init);
                        sbuf.append(", used:").append(used);
                        sbuf.append(", committed:").append(committed);
                        sbuf.append(", max:").append(max);
                        if (fancy) {
                            TextGraphHelper.poolUsage(sbuf, used, committed, max);
                        }
                    } else {
                        sbuf.append("Memory pool NOT valid!");
                    }
                    sbuf.append("</blockquote><br>");
                }
                sbuf.append("</blockquote>");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return sbuf.toString();
        }
        return "<b>Memory pool information available only under a JDK5+ compatible JVM!</b>";
    }

    public Integer getActiveThreadCount() {
        return new Integer(this.getRootThreadGroup().activeCount());
    }

    public Integer getActiveThreadGroupCount() {
        return new Integer(this.getRootThreadGroup().activeGroupCount());
    }

    public String listThreadDump() {
        ThreadGroup root = this.getRootThreadGroup();
        ThreadGroupCount count = new ThreadGroupCount();
        String threadGroupInfo = this.getThreadGroupInfo(root, count);
        String threadDump = "<b>Total Threads:</b> " + count.threads + "<br>" + "<b>Total Thread Groups:</b> " + count.groups + "<br>" + threadGroupInfo;
        return threadDump;
    }

    public String listThreadCpuUtilization() {
        Set threads = this.getThreadCpuUtilization();
        if (threads == null) {
            return "Thread cpu utilization requires J2SE5+";
        }
        long totalCPU = 0L;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table><tr><th>Thread Name</th><th>CPU (milliseconds)</th></tr>");
        Iterator i = threads.iterator();
        while (i.hasNext()) {
            ThreadCPU thread = (ThreadCPU)i.next();
            buffer.append("<tr><td>").append(thread.name).append("</td><td>");
            buffer.append(thread.cpuTime).append("</td></tr>");
            totalCPU += thread.cpuTime;
        }
        buffer.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr><tr><td>Total</td><td>");
        buffer.append(totalCPU).append("</td></tr></table>");
        return buffer.toString();
    }

    private Set getThreadCpuUtilization() {
        if (this.threadMXBean == null) {
            return null;
        }
        try {
            TreeSet<ThreadCPU> result = new TreeSet<ThreadCPU>();
            long[] threads = (long[])this.getAllThreadIds.invoke(this.threadMXBean, null);
            for (int i = 0; i < threads.length; ++i) {
                Long id = new Long(threads[i]);
                Long cpuTime = (Long)this.getThreadCpuTime.invoke(this.threadMXBean, id);
                Object threadInfo = this.getThreadInfo.invoke(this.threadMXBean, id, ZERO);
                String name = (String)this.getThreadName.invoke(threadInfo, null);
                result.add(new ThreadCPU(name, cpuTime));
            }
            return result;
        }
        catch (Exception e) {
            log.warn("Error retrieving thread cpu utiliation", e);
            return null;
        }
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        return group;
    }

    private String getThreadGroupInfo(ThreadGroup group, ThreadGroupCount count) {
        StringBuffer rc = new StringBuffer();
        ++count.groups;
        rc.append("<br><b>");
        rc.append("Thread Group: " + group.getName());
        rc.append("</b> : ");
        rc.append("max priority:" + group.getMaxPriority() + ", demon:" + group.isDaemon());
        rc.append("<blockquote>");
        Thread[] threads = new Thread[group.activeCount()];
        group.enumerate(threads, false);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            ++count.threads;
            rc.append("<b>");
            rc.append("Thread: " + threads[i].getName());
            rc.append("</b> : ");
            rc.append("priority:" + threads[i].getPriority() + ", demon:" + threads[i].isDaemon());
            this.outputJdk5ThreadMXBeanInfo(rc, threads[i]);
        }
        ThreadGroup[] groups = new ThreadGroup[group.activeGroupCount()];
        group.enumerate(groups, false);
        for (int i = 0; i < groups.length && groups[i] != null; ++i) {
            rc.append(this.getThreadGroupInfo(groups[i], count));
        }
        rc.append("</blockquote>");
        return rc.toString();
    }

    private void outputJdk5ThreadMXBeanInfo(StringBuffer sbuf, Thread thread) {
        if (this.threadMXBean != null) {
            try {
                Long threadId = (Long)this.getThreadId.invoke((Object)thread, null);
                Object threadInfo = this.getThreadInfo.invoke(this.threadMXBean, threadId, new Integer(Integer.MAX_VALUE));
                Object threadState = this.getThreadState.invoke(threadInfo, null);
                String threadLockName = (String)this.getLockName.invoke(threadInfo, null);
                Object[] stackTrace = (Object[])this.getStackTrace.invoke(threadInfo, null);
                sbuf.append(", threadId:").append(threadId);
                sbuf.append(", threadState:").append(threadState);
                sbuf.append(", threadLockName:").append(threadLockName);
                sbuf.append("<br>");
                if (stackTrace.length > 0) {
                    sbuf.append("<blockquote>");
                    for (int i = 0; i < stackTrace.length; ++i) {
                        sbuf.append(stackTrace[i]).append("<br>");
                    }
                    sbuf.append("</blockquote>");
                }
            }
            catch (Exception exception) {}
        } else {
            sbuf.append("<br>");
        }
    }

    public String displayPackageInfo(String pkgName) {
        Package pkg = Package.getPackage(pkgName);
        if (pkg == null) {
            return "<h2>Package:" + pkgName + " Not Found!</h2>";
        }
        StringBuffer info = new StringBuffer("<h2>Package: " + pkgName + "</h2>");
        this.displayPackageInfo(pkg, info);
        return info.toString();
    }

    private void displayPackageInfo(Package pkg, StringBuffer info) {
        info.append("<pre>\n");
        info.append("SpecificationTitle: " + pkg.getSpecificationTitle());
        info.append("\nSpecificationVersion: " + pkg.getSpecificationVersion());
        info.append("\nSpecificationVendor: " + pkg.getSpecificationVendor());
        info.append("\nImplementationTitle: " + pkg.getImplementationTitle());
        info.append("\nImplementationVersion: " + pkg.getImplementationVersion());
        info.append("\nImplementationVendor: " + pkg.getImplementationVendor());
        info.append("\nisSealed: " + pkg.isSealed());
        info.append("</pre>\n");
    }

    private static class ThreadGroupCount {
        public int threads;
        public int groups;

        private ThreadGroupCount() {
        }
    }

    private static class ThreadCPU
    implements Comparable {
        public String name;
        public long cpuTime;

        public ThreadCPU(String name, long cpuTime) {
            this.name = name;
            this.cpuTime = cpuTime / 1000000L;
        }

        public int compareTo(Object o) {
            ThreadCPU other = (ThreadCPU)o;
            long value = this.cpuTime - other.cpuTime;
            if (value > 0L) {
                return -1;
            }
            if (value < 0L) {
                return 1;
            }
            return this.name.compareTo(other.name);
        }
    }

    private static class TextGraphHelper {
        static final DecimalFormat formatter = new DecimalFormat("#.##");
        static final long KILO = 1024L;
        static final long MEGA = 0x100000L;
        static final long GIGA = 0x40000000L;
        static final int factor = 70;
        static char[] fixedline;
        static char[] baseline;
        static char[] barline;
        static char[] spaces;

        private TextGraphHelper() {
        }

        public static void poolUsage(StringBuffer sbuf, long used, long committed, long max) {
            long assumedMax = max == -1L ? committed : max;
            int localUsed = (int)(70L * used / assumedMax);
            int localCommitted = (int)(70L * committed / assumedMax);
            int localMax = 70;
            sbuf.append("<blockquote><br>");
            sbuf.append(baseline, 0, localCommitted).append("| committed:").append(TextGraphHelper.outputNumber(committed)).append("<br>");
            sbuf.append(fixedline).append("<br>");
            sbuf.append(barline, 0, localUsed);
            if (localUsed < localCommitted) {
                sbuf.append(localUsed > 0 ? (char)'/' : '|');
                sbuf.append(spaces, 0, localCommitted - localUsed - 1);
            }
            sbuf.append('|');
            if (localCommitted < localMax) {
                sbuf.append(spaces, 0, localMax - localCommitted - 1);
                sbuf.append('|');
            }
            sbuf.append(" max:").append(TextGraphHelper.outputNumber(max)).append("<br>");
            sbuf.append(fixedline).append("<br>");
            sbuf.append(baseline, 0, localUsed).append("| used:").append(TextGraphHelper.outputNumber(used));
            sbuf.append("</blockquote>");
        }

        private static String outputNumber(long value) {
            if (value >= 0x40000000L) {
                return formatter.format((double)value / 1.073741824E9) + "Gb";
            }
            if (value >= 0x100000L) {
                return formatter.format((double)value / 1048576.0) + "Mb";
            }
            if (value >= 1024L) {
                return formatter.format((double)value / 1024.0) + "Kb";
            }
            if (value >= 0L) {
                return value + "b";
            }
            return Long.toString(value);
        }

        static {
            StringBuffer sbuf0 = new StringBuffer();
            StringBuffer sbuf1 = new StringBuffer();
            StringBuffer sbuf2 = new StringBuffer();
            StringBuffer sbuf3 = new StringBuffer();
            sbuf0.append('+');
            sbuf1.append('|');
            sbuf2.append('|');
            for (int i = 1; i < 70; ++i) {
                sbuf0.append('-');
                sbuf1.append('-');
                sbuf2.append('/');
                sbuf3.append(' ');
            }
            sbuf0.append('+');
            fixedline = sbuf0.toString().toCharArray();
            baseline = sbuf1.toString().toCharArray();
            barline = sbuf2.toString().toCharArray();
            spaces = sbuf3.toString().toCharArray();
        }
    }
}

