/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.management.ObjectName;
import javax.resource.spi.ActivationSpec;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.resource.metadata.MessageListenerMetaData;
import org.jboss.resource.metadata.RequiredConfigPropertyMetaData;
import org.jboss.util.propertyeditor.PropertyEditors;

public class ActivationSpecFactory {
    private static final Logger log = Logger.getLogger(ActivationSpecFactory.class);

    public static ActivationSpec createActivationSpec(ObjectName rarName, String messagingType, Collection activationConfig, MessageListenerMetaData mlmd) throws Exception {
        Class<?> asClass;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Create ActivationSpec rar=" + rarName + " messagingType=" + messagingType + " activationConfig=" + activationConfig + " messageListner=" + mlmd);
        }
        Iterator i = mlmd.getRequiredConfigProperties().iterator();
        while (i.hasNext()) {
            RequiredConfigPropertyMetaData rcpmd = (RequiredConfigPropertyMetaData)i.next();
            String rcp = rcpmd.getName();
            String rcpName = rcp.substring(0, 1).toUpperCase();
            if (rcp.length() > 1) {
                rcpName = rcpName.concat(rcp.substring(1));
            }
            if (trace) {
                log.trace("Checking required config " + rcpName);
            }
            boolean found = false;
            Iterator j = activationConfig.iterator();
            while (j.hasNext()) {
                ActivationConfigPropertyMetaData acpmd = (ActivationConfigPropertyMetaData)j.next();
                String acp = acpmd.getName();
                String acpName = acp.substring(0, 1).toUpperCase();
                if (acp.length() > 1) {
                    acpName = acpName.concat(acp.substring(1));
                }
                if (trace) {
                    log.trace("Checking required config " + rcpName + " against " + acpName + " result=" + rcpName.equals(acpName));
                }
                if (!rcpName.equals(acpName)) continue;
                if (trace) {
                    log.trace("Found required config " + rcp + " " + acpmd);
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new DeploymentException("Required config property " + rcpmd + " for messagingType '" + messagingType + "' not found in activation config " + activationConfig + " ra=" + rarName);
        }
        String className = mlmd.getActivationSpecType();
        if (className == null) {
            throw new DeploymentException("No activation spec type for messagingType '" + messagingType + "' ra=" + rarName);
        }
        if (trace) {
            log.trace("Loading ActivationSpec class=" + className);
        }
        if (!ActivationSpec.class.isAssignableFrom(asClass = Thread.currentThread().getContextClassLoader().loadClass(className))) {
            throw new DeploymentException(asClass.getName() + " is not an activation spec class '" + messagingType + "' ra=" + rarName);
        }
        ActivationSpec result = (ActivationSpec)asClass.newInstance();
        if (trace) {
            log.trace("Instantiated ActivationSpec class=" + result);
        }
        Properties beanProps = new Properties();
        Iterator i2 = activationConfig.iterator();
        while (i2.hasNext()) {
            ActivationConfigPropertyMetaData acpmd = (ActivationConfigPropertyMetaData)i2.next();
            String name = acpmd.getName();
            String value = acpmd.getValue();
            beanProps.setProperty(name, value);
        }
        if (trace) {
            log.trace("Configuring ActivationSpec properties=" + beanProps);
        }
        try {
            PropertyEditors.mapJavaBeanProperties(result, beanProps);
        }
        catch (IntrospectionException e) {
            String msg = "Error for ActivationSpec class " + asClass.getName() + " as JavaBean";
            DeploymentException.rethrowAsDeploymentException(msg, e);
        }
        try {
            if (trace) {
                log.trace("Trying to validate ActivationSpec " + result);
            }
            result.validate();
        }
        catch (UnsupportedOperationException e) {
            log.debug("Validation is not supported for ActivationSpec: " + className);
        }
        return result;
    }
}

