/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtPrimitiveType;
import javassist.NotFoundException;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.collection.WeakClassCache;

public class JavassistTypeInfoFactoryImpl
extends WeakClassCache
implements TypeInfoFactory {
    static final ClassPool pool = ClassPool.getDefault();

    public static NoClassDefFoundError raiseClassNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class");
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    public static NoClassDefFoundError raiseClassNotFound(String name, ClassNotFoundException e) throws NoClassDefFoundError {
        NoClassDefFoundError ex = new NoClassDefFoundError("Unable to find class");
        ex.initCause(e);
        throw ex;
    }

    public static NoClassDefFoundError raiseMethodNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoSuchMethodError ex = new NoSuchMethodError("Unable to find method " + name);
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    public static NoClassDefFoundError raiseFieldNotFound(String name, NotFoundException e) throws NoClassDefFoundError {
        NoSuchFieldError ex = new NoSuchFieldError("Unable to find field");
        if (e.getCause() != null) {
            ex.initCause(e.getCause());
        }
        throw ex;
    }

    protected Object instantiate(Class clazz) {
        CtClass ctClass = this.getCtClass(clazz.getName());
        return new JavassistTypeInfo(this, ctClass, clazz);
    }

    protected TypeInfo getTypeInfo(CtClass ctClass) {
        try {
            String name = this.convertName(ctClass);
            return this.getTypeInfo(name, null);
        }
        catch (ClassNotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(ctClass.getName(), e);
        }
    }

    protected String convertName(CtClass clazz) {
        CtClass temp = clazz;
        if (temp.isArray()) {
            JBossStringBuilder buffer = new JBossStringBuilder();
            try {
                while (temp.isArray()) {
                    buffer.append('[');
                    temp = temp.getComponentType();
                }
                if (temp.isPrimitive()) {
                    CtPrimitiveType primitive = (CtPrimitiveType)temp;
                    buffer.append(Character.toString(primitive.getDescriptor()));
                } else {
                    buffer.append('L');
                    buffer.append(temp.getName());
                    buffer.append(';');
                }
                return buffer.toString();
            }
            catch (NotFoundException e) {
                throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(clazz.getName(), e);
            }
        }
        return clazz.getName();
    }

    protected CtClass getCtClass(String name) {
        try {
            return pool.get(name);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound(name, e);
        }
    }

    protected void generate(Class clazz, Object result) {
    }

    public TypeInfo getTypeInfo(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null class");
        }
        PrimitiveInfo primitive = PrimitiveInfo.valueOf(clazz.getName());
        if (primitive != null) {
            return primitive;
        }
        return (TypeInfo)this.get(clazz);
    }

    public TypeInfo getTypeInfo(String name, ClassLoader cl) throws ClassNotFoundException {
        PrimitiveInfo primitive;
        if (name == null) {
            throw new IllegalArgumentException("Null class name");
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if ((primitive = PrimitiveInfo.valueOf(name)) != null) {
            return primitive;
        }
        Class<?> clazz = cl.loadClass(name);
        return this.getTypeInfo(clazz);
    }
}

