/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.util.HashMap;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.w3c.dom.Element;

public class SessionMetaData
extends BeanMetaData {
    public static final String DEFAULT_STATEFUL_INVOKER = "stateful-unified-invoker";
    public static final String DEFAULT_CLUSTERED_STATEFUL_INVOKER = "clustered-stateful-rmi-invoker";
    public static final String DEFAULT_STATELESS_INVOKER = "stateless-unified-invoker";
    public static final String DEFAULT_CLUSTERED_STATELESS_INVOKER = "clustered-stateless-rmi-invoker";
    private boolean stateful;

    public SessionMetaData(ApplicationMetaData app) {
        super(app, 'S');
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        stateful = true;
    }

    public boolean isStateless() {
        return !this.stateful;
    }

    public String getDefaultConfigurationName() {
        if (this.isStateful()) {
            if (this.isClustered()) {
                return "Clustered Stateful SessionBean";
            }
            return "Standard Stateful SessionBean";
        }
        if (this.isClustered()) {
            return "Clustered Stateless SessionBean";
        }
        return "Standard Stateless SessionBean";
    }

    protected void defaultInvokerBindings() {
        this.invokerBindings = new HashMap();
        if (this.isClustered()) {
            if (this.stateful) {
                this.invokerBindings.put(DEFAULT_CLUSTERED_STATEFUL_INVOKER, this.getJndiName());
            } else {
                this.invokerBindings.put(DEFAULT_CLUSTERED_STATELESS_INVOKER, this.getJndiName());
            }
        } else if (this.stateful) {
            this.invokerBindings.put(DEFAULT_STATEFUL_INVOKER, this.getJndiName());
        } else {
            this.invokerBindings.put(DEFAULT_STATELESS_INVOKER, this.getJndiName());
        }
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        super.importEjbJarXml(element);
        String sessionType = SessionMetaData.getElementContent(SessionMetaData.getUniqueChild(element, "session-type"));
        if (sessionType.equals("Stateful")) {
            this.stateful = true;
        } else if (sessionType.equals("Stateless")) {
            this.stateful = false;
        } else {
            throw new DeploymentException("session type should be 'Stateful' or 'Stateless'");
        }
        String transactionType = SessionMetaData.getElementContent(SessionMetaData.getUniqueChild(element, "transaction-type"));
        if (transactionType.equals("Bean")) {
            this.containerManagedTx = false;
        } else if (transactionType.equals("Container")) {
            this.containerManagedTx = true;
        } else {
            throw new DeploymentException("transaction type should be 'Bean' or 'Container'");
        }
        this.serviceEndpointClass = SessionMetaData.getElementContent(SessionMetaData.getOptionalChild(element, "service-endpoint"));
    }

    public void importJbossXml(Element element) throws DeploymentException {
        super.importJbossXml(element);
        Element portElement = SessionMetaData.getOptionalChild(element, "port-component");
        if (portElement != null) {
            this.portComponent = new EjbPortComponentMetaData(this);
            this.portComponent.importJBossXml(portElement);
        }
    }
}

