/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.invocation.http.interfaces.HttpInvokerProxy;
import org.jboss.invocation.http.server.HttpInvokerMBean;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;
import org.jboss.util.StringPropertyReplacer;

public class HttpInvoker
extends ServiceMBeanSupport
implements HttpInvokerMBean {
    private String invokerURL;
    private String invokerURLPrefix = "http://";
    private String invokerURLSuffix = ":8080/invoker/JMXInvokerServlet";
    private boolean useHostName = false;

    public String getInvokerURL() {
        return this.invokerURL;
    }

    public void setInvokerURL(String invokerURL) {
        String tmp;
        this.invokerURL = tmp = StringPropertyReplacer.replaceProperties(invokerURL);
        this.log.debug("Set invokerURL to " + this.invokerURL);
    }

    public String getInvokerURLPrefix() {
        return this.invokerURLPrefix;
    }

    public void setInvokerURLPrefix(String invokerURLPrefix) {
        this.invokerURLPrefix = invokerURLPrefix;
    }

    public String getInvokerURLSuffix() {
        return this.invokerURLSuffix;
    }

    public void setInvokerURLSuffix(String invokerURLSuffix) {
        this.invokerURLSuffix = invokerURLSuffix;
    }

    public boolean getUseHostName() {
        return this.useHostName;
    }

    public void setUseHostName(boolean flag) {
        this.useHostName = flag;
    }

    protected void startService() throws Exception {
        this.checkInvokerURL();
        HttpInvokerProxy delegateInvoker = new HttpInvokerProxy(this.invokerURL);
        ObjectName name = super.getServiceName();
        Registry.bind(name, delegateInvoker);
        this.log.debug("Bound Http invoker for JMX node");
    }

    protected void stopService() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind("invokers/" + InetAddress.getLocalHost().getHostName() + "/http");
        }
        catch (NamingException ignore) {
        }
        catch (Throwable e) {
            this.log.error("Failed", e);
            return;
        }
    }

    protected void destroyService() {
        Registry.unbind(this.serviceName);
    }

    public Object invoke(Invocation invocation) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Object obj;
            MarshalledInvocation mi = (MarshalledInvocation)invocation;
            Object tpc = mi.getTransactionPropagationContext();
            Transaction tx = this.importTPC(tpc);
            invocation.setTransaction(tx);
            Integer nameHash = (Integer)invocation.getObjectName();
            ObjectName mbean = (ObjectName)Registry.lookup(nameHash);
            Object[] args = new Object[]{invocation};
            String[] sig = new String[]{"org.jboss.invocation.Invocation"};
            Object object = obj = super.getServer().invoke(mbean, "invoke", args, sig);
            return object;
        }
        catch (Exception e) {
            if (e instanceof MBeanException) {
                e = ((MBeanException)e).getTargetException();
            }
            if (e instanceof RuntimeMBeanException) {
                e = ((RuntimeMBeanException)e).getTargetException();
            }
            if (e instanceof RuntimeOperationsException) {
                e = ((RuntimeOperationsException)e).getTargetException();
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("operation failed", e);
            }
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    protected Transaction importTPC(Object tpc) {
        return null;
    }

    protected void checkInvokerURL() throws UnknownHostException {
        if (this.invokerURL == null) {
            InetAddress addr = InetAddress.getLocalHost();
            String host = ServerConfigUtil.getSpecificBindAddress();
            if (host == null) {
                host = this.useHostName ? addr.getHostName() : addr.getHostAddress();
            }
            String url = this.invokerURLPrefix + host + this.invokerURLSuffix;
            this.setInvokerURL(url);
        }
    }
}

