/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.ejb.EJBContext;
import javax.persistence.EntityManager;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulBeanContextReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxiedStatefulBeanContext
extends StatefulBeanContext
implements Externalizable {
    private transient StatefulBeanContext delegate;
    private Object oid;
    private String containerId;
    private StatefulBeanContextReference parentRef;

    public ProxiedStatefulBeanContext(StatefulBeanContext delegate) {
        this.delegate = delegate;
        this.oid = delegate.getId();
        this.containerId = delegate.getContainer().getObjectName().getCanonicalName();
    }

    public ProxiedStatefulBeanContext() {
    }

    protected StatefulBeanContext getDelegate() {
        if (this.delegate == null) {
            for (StatefulBeanContext ctx : this.parentRef.getBeanContext().getContains()) {
                Object matchingOid = ctx.getId();
                if (!this.oid.equals(matchingOid) || !ctx.getContainer().getObjectName().getCanonicalName().equals(this.containerId)) continue;
                this.parentRef = null;
                this.delegate = ctx;
                break;
            }
            if (this.delegate == null) {
                throw new RuntimeException("Failed to read delegate");
            }
        }
        return this.delegate;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.oid);
        out.writeUTF(this.containerId);
        out.writeObject(new StatefulBeanContextReference(this.getDelegate().getContainedIn()));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.oid = in.readObject();
        this.containerId = in.readUTF();
        this.parentRef = (StatefulBeanContextReference)in.readObject();
    }

    @Override
    public void prePassivate() {
    }

    @Override
    public void postActivate() {
    }

    @Override
    public List<StatefulBeanContext> getContains() {
        return this.getDelegate().getContains();
    }

    @Override
    public EntityManager getExtendedPersistenceContext(String id) {
        return this.getDelegate().getExtendedPersistenceContext(id);
    }

    @Override
    public void addExtendedPersistenceContext(String id, EntityManager pc) {
        this.getDelegate().addExtendedPersistenceContext(id, pc);
    }

    @Override
    public Map<String, EntityManager> getExtendedPersistenceContexts() {
        return this.getDelegate().getExtendedPersistenceContexts();
    }

    @Override
    public StatefulBeanContext getContainedIn() {
        return this.getDelegate().getContainedIn();
    }

    @Override
    public void addContains(StatefulBeanContext ctx) {
        this.getDelegate().addContains(ctx);
    }

    @Override
    public StatefulBeanContext pushContainedIn() {
        return this.getDelegate().pushContainedIn();
    }

    @Override
    public void popContainedIn() {
        this.getDelegate().popContainedIn();
    }

    @Override
    public boolean isDiscarded() {
        return this.getDelegate().isDiscarded();
    }

    @Override
    public void setDiscarded(boolean discarded) {
        this.getDelegate().setDiscarded(discarded);
    }

    @Override
    public ReentrantLock getLock() {
        return this.getDelegate().getLock();
    }

    @Override
    public boolean isInInvocation() {
        return this.getDelegate().isInInvocation();
    }

    @Override
    public void setInInvocation(boolean inInvocation) {
        this.getDelegate().setInInvocation(inInvocation);
    }

    @Override
    public Object getId() {
        return this.getDelegate().getId();
    }

    @Override
    public void setId(Object id) {
        this.oid = id;
        this.getDelegate().setId(id);
    }

    @Override
    public boolean isTxSynchronized() {
        return this.getDelegate().isTxSynchronized();
    }

    @Override
    public void setTxSynchronized(boolean txSynchronized) {
        this.getDelegate().setTxSynchronized(txSynchronized);
    }

    @Override
    public void remove() {
        this.getDelegate().remove();
    }

    @Override
    public void setContainer(Container container) {
        this.getDelegate().setContainer(container);
    }

    @Override
    public Container getContainer() {
        return this.getDelegate().getContainer();
    }

    @Override
    public Object getInstance() {
        return this.getDelegate().getInstance();
    }

    @Override
    public SimpleMetaData getMetaData() {
        return this.getDelegate().getMetaData();
    }

    @Override
    public Object[] getInterceptorInstances(InterceptorInfo[] interceptorInfos) {
        return this.getDelegate().getInterceptorInstances(interceptorInfos);
    }

    @Override
    public void extractBeanAndInterceptors() {
        this.getDelegate().extractBeanAndInterceptors();
    }

    @Override
    public void setInstance(Object instance) {
        this.getDelegate().setInstance(instance);
    }

    @Override
    public void initialiseInterceptorInstances() {
        this.getDelegate().initialiseInterceptorInstances();
    }

    @Override
    public EJBContext getEJBContext() {
        return this.getDelegate().getEJBContext();
    }
}

