/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Timeout;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.injection.DependsHandler;
import org.jboss.ejb3.injection.EJBHandler;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.JndiInjectHandler;
import org.jboss.ejb3.injection.PersistenceContextHandler;
import org.jboss.ejb3.injection.PersistenceUnitHandler;
import org.jboss.ejb3.injection.ResourceHandler;
import org.jboss.ejb3.injection.WebServiceHandler;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.interceptor.InterceptorInjector;
import org.jboss.ejb3.interceptor.LifecycleInterceptorHandler;
import org.jboss.ejb3.metamodel.AssemblyDescriptor;
import org.jboss.ejb3.metamodel.EnterpriseBean;
import org.jboss.ejb3.metamodel.PersistenceContextRef;
import org.jboss.ejb3.security.JaccHelper;
import org.jboss.ejb3.tx.UserTransactionImpl;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EJBContainer
extends ClassContainer
implements Container {
    private static final Logger log = Logger.getLogger(EJBContainer.class);
    protected Pool pool;
    protected String ejbName;
    protected ObjectName objectName;
    protected int defaultConstructorIndex;
    protected String beanClassName;
    protected ClassLoader classloader;
    protected Injector[] injectors;
    protected Context enc;
    protected Context encEnv;
    protected Class beanContextClass;
    protected LifecycleInterceptorHandler callbackHandler;
    protected Hashtable initialContextProperties;
    protected HashMap envEntries = new HashMap();
    protected HashMap<String, String> encLinkRefEntries = new HashMap();
    protected HashMap<String, String> ejbRefDependencies = new HashMap();
    protected HashMap<String, String> puEncXmlEntries = new HashMap();
    protected HashMap<String, PersistenceContextRef> pcEncXmlEntries = new HashMap();
    protected EnterpriseBean xml;
    protected AssemblyDescriptor assembly;
    protected HashMap<AccessibleObject, Injector> encInjections = new HashMap();
    protected InterceptorInfoRepository interceptorRepository;
    protected List<InterceptorInfo> classInterceptors = new ArrayList<InterceptorInfo>();
    protected LinkedHashSet<InterceptorInfo> applicableInterceptors;
    private HashMap<Class, InterceptorInjector> interceptorInjectors;
    private Ejb3Deployment deployment;
    private DependencyPolicy dependencyPolicy;
    private String jaccContextId;
    protected HashMap extendedPCs = new HashMap();
    protected HashMap invokedMethod = new HashMap();
    public static final String MANAGED_ENTITY_MANAGER_FACTORY = "ManagedEntityManagerFactory";
    public static final String ENTITY_MANAGER_FACTORY = "EntityManagerFactory";

    public EJBContainer(String name, AspectManager manager, ClassLoader cl, String beanClassName, String ejbName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(name, manager);
        this.xml = this.xml;
        this.deployment = deployment;
        this.beanClassName = beanClassName;
        this.classloader = cl;
        try {
            this.clazz = this.classloader.loadClass(beanClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.ejbName = ejbName;
        String on = "jboss.j2ee:service=EJB3" + deployment.getScopeKernelName() + ",name=" + ejbName;
        try {
            this.objectName = new ObjectName(on);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        this.initialContextProperties = ctxProperties;
        InitialContext ctx = this.getInitialContext();
        try {
            this.enc = ThreadLocalENCFactory.create(ctx);
            this.encEnv = Util.createSubcontext(this.enc, "env");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.interceptorRepository = interceptorRepository;
        this.interceptorRepository.addBeanClass(this.clazz.getName());
    }

    public HashMap<String, String> getEjbRefDependencies() {
        return this.ejbRefDependencies;
    }

    public HashMap<String, String> getPuEncXmlEntries() {
        return this.puEncXmlEntries;
    }

    public HashMap<String, PersistenceContextRef> getPcEncXmlEntries() {
        return this.pcEncXmlEntries;
    }

    public String getJaccContextId() {
        return this.jaccContextId;
    }

    public void setJaccContextId(String jaccContextId) {
        this.jaccContextId = jaccContextId;
    }

    public Ejb3Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public DependencyPolicy getDependencyPolicy() {
        return this.dependencyPolicy;
    }

    public void instantiated() {
    }

    @Override
    public void processMetadata(DependencyPolicy dependencyPolicy) {
        this.dependencyPolicy = dependencyPolicy;
        PersistenceContextHandler.loadDependencies(this.xml, this, this.clazz, true);
        PersistenceUnitHandler.loadDependencies(this.xml, this, this.clazz, true);
        if (this.xml != null) {
            for (String depends : this.xml.getDependencies()) {
                dependencyPolicy.addDependency(depends);
            }
        }
        DependsHandler.loadDependencies(this, this.clazz);
        EJBHandler.loadDependencies(this.xml, this, this.clazz, true);
        this.initialiseInterceptors();
        for (InterceptorInfo interceptorInfo : this.applicableInterceptors) {
            PersistenceContextHandler.loadDependencies(interceptorInfo.getXml(), this, interceptorInfo.getClazz(), false);
            PersistenceUnitHandler.loadDependencies(interceptorInfo.getXml(), this, interceptorInfo.getClazz(), false);
            DependsHandler.loadDependencies(this, interceptorInfo.getClazz());
            EJBHandler.loadDependencies(interceptorInfo.getXml(), this, interceptorInfo.getClazz(), true);
        }
    }

    public EnterpriseBean getXml() {
        return this.xml;
    }

    public void setXml(EnterpriseBean xml) {
        this.xml = xml;
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        return this.assembly;
    }

    public void setAssemblyDescriptor(AssemblyDescriptor assembly) {
        this.assembly = assembly;
    }

    public InterceptorInfoRepository getInterceptorRepository() {
        return this.interceptorRepository;
    }

    public List<InterceptorInfo> getClassInterceptors() {
        this.initialiseInterceptors();
        return this.classInterceptors;
    }

    public HashSet<InterceptorInfo> getApplicableInterceptors() {
        this.initialiseInterceptors();
        return this.applicableInterceptors;
    }

    public HashMap<Class, InterceptorInjector> getInterceptorInjectors() {
        this.initialiseInterceptors();
        return this.interceptorInjectors;
    }

    public ClassLoader getClassloader() {
        return this.classloader;
    }

    public HashMap<String, String> getEncLinkRefEntries() {
        return this.encLinkRefEntries;
    }

    @Override
    public void addEncLinkRefEntry(String name, String mappedName) {
        this.encLinkRefEntries.put(name, mappedName);
    }

    public void addEncInjector(AccessibleObject acc, Injector inj) {
        this.encInjections.put(acc, inj);
    }

    @Override
    public InitialContext getInitialContext() {
        try {
            if (this.initialContextProperties == null) {
                return new InitialContext();
            }
            return new InitialContext(this.initialContextProperties);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public HashMap<AccessibleObject, Injector> getEncInjections() {
        return this.encInjections;
    }

    public boolean hasEnvEntry(String name) {
        return this.envEntries.containsKey(name);
    }

    public void addEnvEntry(String name, String type, String value) throws ClassNotFoundException {
        this.envEntries.put(name, this.getEnvEntryValue(name, type, value));
    }

    public boolean hasEncEntry(String name) {
        return this.encLinkRefEntries.containsKey(name);
    }

    @Override
    public Context getEnc() {
        return this.enc;
    }

    public Context getEncEnv() {
        return this.enc;
    }

    protected Object getEnvEntryValue(String name, String entryType, String value) throws ClassNotFoundException {
        Class<?> type = this.classloader.loadClass(entryType);
        if (type == String.class) {
            return value;
        }
        if (type == Integer.class) {
            return new Integer(value);
        }
        if (type == Long.class) {
            return new Long(value);
        }
        if (type == Double.class) {
            return new Double(value);
        }
        if (type == Float.class) {
            return new Float(value);
        }
        if (type == Byte.class) {
            return new Byte(value);
        }
        if (type == Character.class) {
            String input = value;
            if (input == null || input.length() == 0) {
                return new Character('\u0000');
            }
            if (input.length() > 1) {
                log.warn("Warning character env-entry is too long: binding=" + name + " value=" + input);
            }
            return new Character(input.charAt(0));
        }
        if (type == Short.class) {
            return new Short(value);
        }
        if (type == Boolean.class) {
            return new Boolean(value);
        }
        return value;
    }

    @Override
    public Hashtable getInitialContextProperties() {
        return this.initialContextProperties;
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public String getEjbName() {
        return this.ejbName;
    }

    public String getBeanClassName() {
        return this.beanClassName;
    }

    @Override
    public Class getBeanClass() {
        return this.clazz;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public Object construct() {
        Interceptor[] cInterceptors = this.constructorInterceptors[this.defaultConstructorIndex];
        if (cInterceptors == null) {
            try {
                return this.constructors[this.defaultConstructorIndex].newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        ConstructorInvocation invocation = new ConstructorInvocation(cInterceptors);
        invocation.setAdvisor(this);
        invocation.setConstructor(this.constructors[this.defaultConstructorIndex]);
        try {
            return invocation.invokeNext();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    public void start() throws Exception {
        this.initializeClassContainer();
        for (int i = 0; i < this.constructors.length; ++i) {
            if (this.constructors[i].getParameterTypes().length != 0) continue;
            this.defaultConstructorIndex = i;
            break;
        }
        this.createEnvEntries();
        this.initializePool();
        this.resolveInterceptorInjectors();
        ArrayList<Object> injectors2 = new ArrayList<Object>();
        injectors2.addAll(this.extendedPCs.values());
        if (this.injectors != null) {
            injectors2.addAll(Arrays.asList(this.injectors));
        }
        this.injectors = injectors2.toArray(new Injector[injectors2.size()]);
        if (this.pool != null) {
            this.pool.setInjectors(this.injectors);
        }
        this.createCallbackHandler();
        for (String encName : this.encLinkRefEntries.keySet()) {
            String mappedName = this.encLinkRefEntries.get(encName);
            try {
                Util.bind(this.enc, encName, (Object)new LinkRef(mappedName));
                log.debug("binding enc: " + encName + " to " + mappedName);
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind EJB container with ejb name " + this.ejbName + " into JNDI under jndiName: " + this.enc.getNameInNamespace() + "/" + encName);
                namingException.setRootCause(e);
                throw namingException;
            }
        }
        JaccHelper.configureContainer(this.jaccContextId, this);
        log.info("STARTED EJB: " + this.clazz.getName() + " ejbName: " + this.ejbName);
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public void destroy() throws Exception {
    }

    protected void createEnvEntries() throws NamingException {
        for (String name : this.envEntries.keySet()) {
            Object value = this.envEntries.get(name);
            try {
                Util.bind(this.encEnv, name, value);
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind env entry for ejb name " + this.ejbName + " into JNDI under jndiName: " + this.encEnv.getNameInNamespace() + "/" + name);
                namingException.setRootCause(e);
                throw namingException;
            }
        }
    }

    public void initializePool() throws Exception {
        PoolClass poolClass = (PoolClass)this.resolveAnnotation(PoolClass.class);
        Class poolClazz = poolClass.value();
        int maxSize = poolClass.maxSize();
        long timeout = poolClass.timeout();
        this.pool = (Pool)poolClazz.newInstance();
        this.pool.initialize(this, this.beanContextClass, this.clazz, maxSize, timeout);
        this.resolveInjectors();
        this.pool.setInjectors(this.injectors);
    }

    @Override
    public void invokePostConstruct(BeanContext beanContext) {
        this.callbackHandler.postConstruct(beanContext);
    }

    @Override
    public void invokePreDestroy(BeanContext beanContext) {
        this.callbackHandler.preDestroy(beanContext);
    }

    @Override
    public void invokePostActivate(BeanContext beanContext) {
        throw new RuntimeException("PostActivate not implemented for container");
    }

    @Override
    public void invokePrePassivate(BeanContext beanContext) {
        throw new RuntimeException("PostActivate not implemented for container");
    }

    @Override
    public void invokeInit(Object bean) {
    }

    @Override
    public void invokeInit(Object bean, Class[] initParameterTypes, Object[] initParameterValues) {
    }

    public HashMap getExtendedPCs() {
        return this.extendedPCs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInjectors() throws Exception {
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            try {
                Util.bind(this.enc, "UserTransaction", (Object)new UserTransactionImpl());
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind user transaction for ejb name " + this.ejbName + " into JNDI under jndiName: " + this.enc.getNameInNamespace() + "/" + "UserTransaction");
                namingException.setRootCause(e);
                throw namingException;
            }
            ArrayList<Injector> list = new ArrayList<Injector>();
            PersistenceContextHandler.loadInjectors(this);
            PersistenceUnitHandler.loadInjectors(this);
            list.addAll(JndiInjectHandler.loadInjectors(this));
            ResourceHandler.loadInjectors(this);
            WebServiceHandler.loadInjectors(this);
            EJBHandler.loadInjectors(this);
            list.addAll(DependsHandler.loadInjectors(this));
            list.addAll(this.encInjections.values());
            this.injectors = list.toArray(new Injector[list.size()]);
        }
        finally {
            ThreadLocalENCFactory.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInterceptorInjectors() throws Exception {
        ThreadLocalENCFactory.push(this.enc);
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            if (this.applicableInterceptors != null && this.applicableInterceptors.size() > 0) {
                this.interceptorInjectors = new HashMap();
                for (InterceptorInfo interceptorInfo : this.applicableInterceptors) {
                    InterceptorInjector injector = new InterceptorInjector(this, interceptorInfo);
                    this.interceptorInjectors.put(interceptorInfo.getClazz(), injector);
                }
            }
        }
        finally {
            ThreadLocalENCFactory.pop();
        }
    }

    protected void createCallbackHandler() {
        try {
            this.callbackHandler = new LifecycleInterceptorHandler(this, this.getHandledCallbacks());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating callback handler for bean " + this.beanClassName, e);
        }
    }

    protected Class[] getHandledCallbacks() {
        return new Class[]{PostConstruct.class, PreDestroy.class, Timeout.class};
    }

    private void initialiseInterceptors() {
        if (this.applicableInterceptors == null) {
            log.debug("Initialising interceptors for " + this.getEjbName() + "...");
            HashSet<InterceptorInfo> defaultInterceptors = this.interceptorRepository.getDefaultInterceptors();
            log.debug("Default interceptors: " + defaultInterceptors);
            this.classInterceptors = this.interceptorRepository.getClassInterceptors(this);
            log.debug("Class interceptors: " + this.classInterceptors);
            this.applicableInterceptors = new LinkedHashSet();
            if (defaultInterceptors != null) {
                this.applicableInterceptors.addAll(defaultInterceptors);
            }
            if (this.classInterceptors != null) {
                this.applicableInterceptors.addAll(this.classInterceptors);
            }
            Method[] methods = this.clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                ArrayList<InterceptorInfo> methodIcptrs = this.interceptorRepository.getMethodInterceptors(this, methods[i]);
                if (methodIcptrs == null || methodIcptrs.size() <= 0) continue;
                log.debug("Method interceptors for  " + methods[i] + ": " + methodIcptrs);
                this.applicableInterceptors.addAll(methodIcptrs);
            }
            log.debug("All applicable interceptor classes: " + this.applicableInterceptors);
        }
    }

    public Object getBusinessObject(BeanContext beanContext, Class businessObject) throws IllegalStateException {
        throw new IllegalStateException("Not implemented");
    }

    public Object getInvokedBusinessInterface(BeanContext beanContext) throws IllegalStateException {
        throw new IllegalStateException("Not implemented");
    }

    protected Object getInvokedInterface(Method method) {
        Local localAnnotation;
        Remote remoteAnnotation = (Remote)this.resolveAnnotation(Remote.class);
        if (remoteAnnotation != null) {
            Class[] remotes = remoteAnnotation.value();
            for (int i = 0; i < remotes.length; ++i) {
                try {
                    remotes[i].getMethod(method.getName(), method.getParameterTypes());
                    return remotes[i];
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
        }
        if ((localAnnotation = (Local)this.resolveAnnotation(Local.class)) != null) {
            Class[] locals = localAnnotation.value();
            for (int i = 0; i < locals.length; ++i) {
                Method[] interfaceMethods = locals[i].getMethods();
                for (int j = 0; j < interfaceMethods.length; ++j) {
                    if (!interfaceMethods[j].equals(method)) continue;
                    return locals[i];
                }
            }
        }
        return null;
    }

    private Class loadPublicAnnotation(String annotation) {
        try {
            Class<?> ann = this.classloader.loadClass(annotation);
            if (!ann.isAnnotation()) {
                return null;
            }
            Retention retention = ann.getAnnotation(Retention.class);
            if (retention != null && retention.value() == RetentionPolicy.RUNTIME) {
                return ann;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean hasAnnotation(Class tgt, String annotation) {
        if (this.annotations.hasClassAnnotation(annotation)) {
            return true;
        }
        if (tgt == null) {
            return false;
        }
        try {
            Class ann = this.loadPublicAnnotation(annotation);
            if (ann == null) {
                return AnnotationElement.isAnyAnnotationPresent(tgt, annotation);
            }
            return tgt.isAnnotationPresent(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasAnnotation(Method m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            Class ann = this.loadPublicAnnotation(annotation);
            if (ann == null) {
                return AnnotationElement.isAnyAnnotationPresent(m, annotation);
            }
            return m.isAnnotationPresent(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasAnnotation(Field m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            Class ann = this.loadPublicAnnotation(annotation);
            if (ann == null) {
                return AnnotationElement.isAnyAnnotationPresent(m, annotation);
            }
            return m.isAnnotationPresent(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasAnnotation(Constructor m, String annotation) {
        if (this.annotations.hasAnnotation((Member)m, annotation)) {
            return true;
        }
        try {
            Class ann = this.loadPublicAnnotation(annotation);
            if (ann == null) {
                return AnnotationElement.isAnyAnnotationPresent(m, annotation);
            }
            return m.isAnnotationPresent(ann);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

