/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import org.jboss.ejb.plugins.cmp.jdbc.JDBCParameterSetter;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
import org.jboss.ejb.plugins.cmp.jdbc.Mapper;

public final class JDBCTypeSimple
implements JDBCType {
    private final String[] columnNames;
    private final Class[] javaTypes;
    private final int[] jdbcTypes;
    private final String[] sqlTypes;
    private final boolean[] notNull;
    private final boolean[] autoIncrement;
    private final JDBCResultSetReader[] resultSetReader;
    private final JDBCParameterSetter[] paramSetter;
    private final Mapper mapper;

    public JDBCTypeSimple(String columnName, Class javaType, int jdbcType, String sqlType, boolean notNull, boolean autoIncrement, Mapper mapper, JDBCParameterSetter paramSetter, JDBCResultSetReader resultReader) {
        this.columnNames = new String[]{columnName};
        this.javaTypes = new Class[]{javaType};
        this.jdbcTypes = new int[]{jdbcType};
        this.sqlTypes = new String[]{sqlType};
        this.notNull = new boolean[]{notNull};
        this.autoIncrement = new boolean[]{autoIncrement};
        this.mapper = mapper;
        this.resultSetReader = new JDBCResultSetReader[]{resultReader};
        this.paramSetter = new JDBCParameterSetter[]{paramSetter};
    }

    public final String[] getColumnNames() {
        return this.columnNames;
    }

    public final Class[] getJavaTypes() {
        return this.javaTypes;
    }

    public final int[] getJDBCTypes() {
        return this.jdbcTypes;
    }

    public final String[] getSQLTypes() {
        return this.sqlTypes;
    }

    public final boolean[] getNotNull() {
        return this.notNull;
    }

    public final boolean[] getAutoIncrement() {
        return this.autoIncrement;
    }

    public final Object getColumnValue(int index, Object value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("JDBCSimpleType does not support an index>0.");
        }
        return this.mapper == null ? value : this.mapper.toColumnValue(value);
    }

    public final Object setColumnValue(int index, Object value, Object columnValue) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("JDBCSimpleType does not support an index>0.");
        }
        return this.mapper == null ? columnValue : this.mapper.toFieldValue(columnValue);
    }

    public boolean hasMapper() {
        return this.mapper != null;
    }

    public final JDBCResultSetReader[] getResultSetReaders() {
        return this.resultSetReader;
    }

    public JDBCParameterSetter[] getParameterSetter() {
        return this.paramSetter;
    }
}

