/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.QLCompiler;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCJBossQLQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;

public final class JDBCJBossQLQuery
extends JDBCAbstractQueryCommand {
    public JDBCJBossQLQuery(JDBCStoreManager manager, JDBCQueryMetaData q) throws DeploymentException {
        super(manager, q);
        JDBCJBossQLQueryMetaData metadata = (JDBCJBossQLQueryMetaData)q;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("JBossQL: " + metadata.getJBossQL());
        }
        QLCompiler compiler = JDBCQueryManager.getInstance(metadata.getQLCompilerClass(), manager.getCatalog());
        try {
            compiler.compileJBossQL(metadata.getJBossQL(), metadata.getMethod().getReturnType(), metadata.getMethod().getParameterTypes(), metadata);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DeploymentException("Error compiling JBossQL statement '" + metadata.getJBossQL() + "'", t);
        }
        this.setSQL(compiler.getSQL());
        this.setOffsetParam(compiler.getOffsetParam());
        this.setOffsetValue(compiler.getOffsetValue());
        this.setLimitParam(compiler.getLimitParam());
        this.setLimitValue(compiler.getLimitValue());
        if (compiler.isSelectEntity()) {
            JDBCEntityBridge selectEntity = (JDBCEntityBridge)compiler.getSelectEntity();
            this.setSelectEntity(selectEntity);
            JDBCReadAheadMetaData readahead = metadata.getReadAhead();
            if (readahead.isOnFind()) {
                this.setEagerLoadGroup(readahead.getEagerLoadGroup());
                this.setOnFindCMRList(compiler.getLeftJoinCMRList());
            }
        } else if (compiler.isSelectField()) {
            this.setSelectField((JDBCCMPFieldBridge)compiler.getSelectField());
        } else {
            this.setSelectFunction(compiler.getSelectFunction(), (JDBCStoreManager)compiler.getStoreManager());
        }
        this.setParameterList(compiler.getInputParameters());
    }
}

