/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.IsLocalInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.PojiProxy;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
import org.jboss.remoting.InvokerLocator;

public class Remoting {
    public static ClassProxy createRemoteProxy(Object objectId, Class clazz, String uri) throws Exception {
        return Remoting.createRemoteProxy(objectId, clazz, new InvokerLocator(uri));
    }

    public static ClassProxy createRemoteProxy(Object objectId, Class clazz, InvokerLocator locator) throws Exception {
        ClassProxy proxy = ClassProxyFactory.newInstance(clazz);
        Remoting.makeRemotable(proxy, locator, objectId);
        return proxy;
    }

    public static Object createPojiProxy(Object oid, Class[] interfaces, String uri) throws Exception {
        InvokerLocator locator = new InvokerLocator(uri);
        Interceptor[] interceptors = new Interceptor[]{IsLocalInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        PojiProxy proxy = new PojiProxy(oid, locator, interceptors);
        return Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)proxy);
    }

    public static void makeRemotable(InstanceAdvised proxy, InvokerLocator locator, Object objectId) {
        InstanceAdvisor advisor = proxy._getInstanceAdvisor();
        advisor.insertInterceptor(IsLocalInterceptor.singleton);
        advisor.insertInterceptor(SecurityClientInterceptor.singleton);
        advisor.insertInterceptor(ClientTxPropagationInterceptor.singleton);
        advisor.insertInterceptor(MergeMetaDataInterceptor.singleton);
        advisor.insertInterceptor(InvokeRemoteInterceptor.singleton);
        advisor.getMetaData().addMetaData("REMOTING", "INVOKER_LOCATOR", locator, PayloadKey.AS_IS);
        advisor.getMetaData().addMetaData("REMOTING", "SUBSYSTEM", "AOP", PayloadKey.AS_IS);
        advisor.getMetaData().addMetaData("DISPATCHER", "OID", objectId, PayloadKey.AS_IS);
    }
}

