/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.Serializable;
import java.net.URL;
import java.security.Principal;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.invocation.SecurityAdaptor;
import org.jboss.wsf.spi.invocation.SecurityAdaptorFactory;
import org.jboss.wsf.test.TestDeployer;

public class TestDeployerJBoss
implements TestDeployer {
    private static final String MAIN_DEPLOYER = "jboss.system:service=MainDeployer";
    private MBeanServerConnection server;
    private String username;
    private String password;

    public TestDeployerJBoss(MBeanServerConnection mBeanServerConnection) {
        this.server = mBeanServerConnection;
        this.username = System.getProperty("jmx.authentication.username");
        if ("${jmx.authentication.username}".equals(this.username)) {
            this.username = null;
        }
        this.password = System.getProperty("jmx.authentication.password");
        if ("${jmx.authentication.password}".equals(this.password)) {
            this.password = null;
        }
    }

    public void deploy(URL uRL) throws Exception {
        this.invokeMainDeployer("deploy", uRL);
    }

    public void undeploy(URL uRL) throws Exception {
        this.invokeMainDeployer("undeploy", uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMainDeployer(String string, URL uRL) throws Exception {
        Principal principal = null;
        Object object = null;
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        SecurityAdaptor securityAdaptor = ((SecurityAdaptorFactory)sPIProvider.getSPI(SecurityAdaptorFactory.class)).newSecurityAdapter();
        if (this.username != null || this.password != null) {
            principal = securityAdaptor.getPrincipal();
            object = securityAdaptor.getCredential();
            securityAdaptor.setPrincipal((Principal)new SimplePrincipal(this.username));
            securityAdaptor.setCredential((Object)this.password);
        }
        try {
            this.server.invoke(new ObjectName(MAIN_DEPLOYER), string, new Object[]{uRL}, new String[]{"java.net.URL"});
        }
        finally {
            if (this.username != null || this.password != null) {
                securityAdaptor.setPrincipal(principal);
                securityAdaptor.setCredential(object);
            }
        }
    }

    public static class SimplePrincipal
    implements Principal,
    Serializable {
        private String name;

        public SimplePrincipal(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }
}

