/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.naming.NamingException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;
import org.jboss.wsf.test.JBossWSTestHelper;

public class JBossWSTestSetup
extends TestSetup {
    private static Logger log = Logger.getLogger(JBossWSTestSetup.class);
    private JBossWSTestHelper delegate = new JBossWSTestHelper();
    private String[] archives = new String[0];

    public JBossWSTestSetup(Class clazz, String string) {
        super((Test)new TestSuite(clazz));
        this.getArchiveArray(string);
    }

    public JBossWSTestSetup(Test test, String string) {
        super(test);
        this.getArchiveArray(string);
    }

    public JBossWSTestSetup(Test test) {
        super(test);
    }

    private void getArchiveArray(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
            this.archives = new String[stringTokenizer.countTokens()];
            for (int i = 0; i < this.archives.length; ++i) {
                this.archives[i] = stringTokenizer.nextToken();
            }
        }
    }

    protected void setUp() throws Exception {
        URL[] uRLArray;
        String string = this.delegate.getIntegrationTarget();
        log.debug((Object)("Integration target: " + string));
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < this.archives.length; ++i) {
            uRLArray = this.archives[i];
            try {
                this.delegate.deploy((String)uRLArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.delegate.undeploy((String)uRLArray);
            }
            if (!uRLArray.endsWith("-client.jar")) continue;
            URL uRL = this.delegate.getArchiveURL((String)uRLArray);
            arrayList.add(uRL);
        }
        if (!arrayList.isEmpty()) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            uRLArray = new URL[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                uRLArray[i] = (URL)arrayList.get(i);
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, classLoader);
            Thread.currentThread().setContextClassLoader(uRLClassLoader);
        }
    }

    protected void tearDown() throws Exception {
        for (int i = 0; i < this.archives.length; ++i) {
            String string = this.archives[this.archives.length - i - 1];
            this.delegate.undeploy(string);
        }
    }

    public MBeanServerConnection getServer() throws NamingException {
        JBossWSTestSetup jBossWSTestSetup = this;
        return jBossWSTestSetup.delegate.getServer();
    }
}

