/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.test.TestDeployer;
import org.jboss.wsf.test.TestDeployerJBoss;

public class JBossWSTestHelper {
    private static Logger log = Logger.getLogger(JBossWSTestHelper.class);
    private static MBeanServerConnection server;
    private static String integrationTarget;
    private static String implVendor;
    private static String implTitle;
    private static String implVersion;

    public void deploy(String string) throws Exception {
        URL uRL = this.getArchiveURL(string);
        this.getDeployer().deploy(uRL);
    }

    public void undeploy(String string) throws Exception {
        URL uRL = this.getArchiveURL(string);
        this.getDeployer().undeploy(uRL);
    }

    public boolean isTargetJBoss50() {
        String string = this.getIntegrationTarget();
        return "jboss50".equals(string);
    }

    public boolean isTargetJBoss42() {
        String string = this.getIntegrationTarget();
        return "jboss42".equals(string);
    }

    public boolean isTargetJBoss40() {
        String string = this.getIntegrationTarget();
        return "jboss40".equals(string);
    }

    public boolean isIntegrationNative() {
        String string = this.getImplementationVendor();
        return string.indexOf("JBoss") != -1;
    }

    public boolean isIntegrationSunRI() {
        String string = this.getImplementationVendor();
        return string.indexOf("Sun") != -1;
    }

    public boolean isIntegrationXFire() {
        String string = this.getImplementationVendor();
        return string.indexOf("Apache") != -1;
    }

    private String getImplementationVendor() {
        if (implVendor == null) {
            Service service = Service.create((QName)new QName("dummyService"));
            HandlerResolver handlerResolver = service.getHandlerResolver();
            if (handlerResolver == null) {
                service.addPort(new QName("dummyPort"), "http://schemas.xmlsoap.org/wsdl/soap/http", "http://dummy-address");
                handlerResolver = service.createDispatch(new QName("dummyPort"), Source.class, Service.Mode.PAYLOAD);
            }
            implVendor = handlerResolver.getClass().getPackage().getImplementationVendor();
            implTitle = handlerResolver.getClass().getPackage().getImplementationTitle();
            implVersion = handlerResolver.getClass().getPackage().getImplementationVersion();
            System.out.println(implVendor + ", " + implTitle + ", " + implVersion);
        }
        return implVendor;
    }

    public static String getServerHost() {
        String string = System.getProperty("jboss.bind.address", "localhost");
        return string;
    }

    public static MBeanServerConnection getServer() {
        if (server == null) {
            Hashtable<?, ?> hashtable = null;
            try {
                InitialContext initialContext = new InitialContext();
                hashtable = initialContext.getEnvironment();
                server = (MBeanServerConnection)initialContext.lookup("jmx/invoker/RMIAdaptor");
            }
            catch (NamingException namingException) {
                throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + hashtable, namingException);
            }
        }
        return server;
    }

    private TestDeployer getDeployer() {
        return new TestDeployerJBoss(JBossWSTestHelper.getServer());
    }

    public String getIntegrationTarget() {
        if (integrationTarget == null) {
            integrationTarget = System.getProperty("jbossws.integration.target");
            if (integrationTarget == null) {
                throw new IllegalStateException("Cannot obtain jbossws.integration.target");
            }
            String string = null;
            try {
                ObjectName objectName = ObjectNameFactory.create("jboss.system:type=ServerConfig");
                string = (String)JBossWSTestHelper.getServer().getAttribute(objectName, "SpecificationVersion");
                if (string.startsWith("5.0")) {
                    string = "jboss50";
                } else if (string.startsWith("4.2")) {
                    string = "jboss42";
                } else if (string.startsWith("4.0")) {
                    string = "jboss40";
                } else {
                    log.warn((Object)("Unsupported jboss version: " + string));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (string != null && !string.equals(integrationTarget)) {
                log.warn((Object)("Integration target mismatch, using: " + integrationTarget));
            }
        }
        return integrationTarget;
    }

    public URL getArchiveURL(String string) throws MalformedURLException {
        File file;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL == null && (file = new File(string)).exists()) {
            uRL = file.toURL();
        }
        if (uRL == null && (file = new File("libs/" + string)).exists()) {
            uRL = file.toURL();
        }
        if (uRL == null) {
            throw new IllegalArgumentException("Cannot obtain URL for: " + string);
        }
        return uRL;
    }
}

