/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.util.NestedRuntimeException;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;

public abstract class JMSTransportSupport
implements MessageDrivenBean,
MessageListener {
    protected Logger log = Logger.getLogger(JMSTransportSupport.class);
    private QueueConnectionFactory queueFactory;

    public void onMessage(Message message) {
        try {
            String string = null;
            if (message instanceof BytesMessage) {
                string = this.getMessageStr((BytesMessage)message);
            } else if (message instanceof TextMessage) {
                string = ((TextMessage)message).getText();
            } else {
                this.log.warn((Object)("Invalid message type: " + message));
                return;
            }
            this.log.debug((Object)("Incomming SOAP message: " + string));
            String string2 = null;
            Destination destination = message.getJMSDestination();
            if (destination instanceof Queue) {
                string2 = "queue/" + ((Queue)destination).getQueueName();
            }
            if (destination instanceof Topic) {
                string2 = "topic/" + ((Topic)destination).getTopicName();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
            this.processSOAPMessage(string2, byteArrayInputStream, byteArrayOutputStream);
            string = new String(byteArrayOutputStream.toByteArray());
            this.log.debug((Object)("Outgoing SOAP message: " + string));
            if (string.length() > 0) {
                Queue queue = this.getReplyQueue(message);
                if (queue != null) {
                    this.sendResponse(queue, string);
                } else {
                    this.log.warn((Object)"No reply queue, ignore response message");
                }
            } else {
                this.log.debug((Object)"SOAP response message is null");
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new EJBException(exception);
        }
    }

    protected void processSOAPMessage(String string, InputStream inputStream, OutputStream outputStream) throws SOAPException, IOException, RemoteException {
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        EndpointRegistry endpointRegistry = ((EndpointRegistryFactory)sPIProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
        Endpoint endpoint = this.getEndpointForDestination(endpointRegistry, string);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find endpoint for: " + string);
        }
        this.log.debug((Object)("dipatchMessage: " + endpoint.getName()));
        RequestHandler requestHandler = endpoint.getRequestHandler();
        try {
            InvocationContext invocationContext = new InvocationContext();
            invocationContext.setTargetBean((Object)this);
            requestHandler.handleRequest(endpoint, inputStream, outputStream, invocationContext);
        }
        catch (Exception exception) {
            throw new RemoteException("Cannot process SOAP request", exception);
        }
    }

    private Endpoint getEndpointForDestination(EndpointRegistry endpointRegistry, String string) {
        Endpoint endpoint = null;
        for (ObjectName objectName : endpointRegistry.getEndpoints()) {
            Endpoint endpoint2 = endpointRegistry.getEndpoint(objectName);
            String string2 = endpoint2.getName().getKeyProperty("jms");
            if (string2 == null || !string2.equals(string)) continue;
            endpoint = endpoint2;
            break;
        }
        return endpoint;
    }

    private String getMessageStr(BytesMessage bytesMessage) throws Exception {
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n = bytesMessage.readBytes(byArray);
        while (n != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = bytesMessage.readBytes(byArray);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return new String(byArray2);
    }

    protected Queue getReplyQueue(Message message) throws JMSException {
        Queue queue = (Queue)message.getJMSReplyTo();
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(Queue queue, String string) throws SOAPException, IOException, JMSException {
        QueueConnection queueConnection = this.queueFactory.createQueueConnection();
        QueueSession queueSession = queueConnection.createQueueSession(false, 1);
        QueueSender queueSender = null;
        try {
            queueSender = queueSession.createSender(queue);
            TextMessage textMessage = queueSession.createTextMessage(string);
            queueSender.send((Message)textMessage);
            this.log.info((Object)"Sent response");
        }
        finally {
            try {
                queueSender.close();
            }
            catch (JMSException jMSException) {}
            try {
                queueSession.close();
            }
            catch (JMSException jMSException) {}
            try {
                queueConnection.close();
            }
            catch (JMSException jMSException) {}
        }
    }

    public void ejbCreate() {
        try {
            InitialContext initialContext = new InitialContext();
            this.queueFactory = (QueueConnectionFactory)initialContext.lookup("java:/ConnectionFactory");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new NestedRuntimeException((Throwable)exception);
        }
    }

    public void ejbRemove() throws EJBException {
    }

    public void setMessageDrivenContext(MessageDrivenContext messageDrivenContext) throws EJBException {
    }
}

