/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class URLLoaderAdapter
implements UnifiedVirtualFile {
    private URL rootURL;
    private URL resourceURL;
    private transient URLClassLoader loader;

    public URLLoaderAdapter(URL uRL) {
        this.rootURL = uRL;
    }

    private URLLoaderAdapter(URL uRL, URLClassLoader uRLClassLoader, URL uRL2) {
        this.rootURL = uRL;
        this.resourceURL = uRL2;
        this.loader = uRLClassLoader;
    }

    public UnifiedVirtualFile findChild(String string) throws IOException {
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) {
                try {
                    File file = new File(string);
                    if (file.exists()) {
                        uRL = file.toURL();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null) {
                try {
                    uRL = this.getResourceLoader().getResource(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (uRL == null) {
            throw new IOException("Cannot get URL for: " + string);
        }
        return new URLLoaderAdapter(this.rootURL, this.loader, uRL);
    }

    public URL toURL() {
        if (this.resourceURL != null) {
            return this.resourceURL;
        }
        return this.rootURL;
    }

    private URLClassLoader getResourceLoader() {
        if (this.loader == null) {
            this.loader = new URLClassLoader(new URL[]{this.rootURL});
        }
        return this.loader;
    }
}

