/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.instrument.javassist;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javassist.bytecode.ClassFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.tool.instrument.javassist.FieldFilter;
import org.hibernate.tool.instrument.javassist.FieldTransformer;

public class InstrumentTask
extends Task {
    private List filesets = new ArrayList();
    private boolean verbose;
    static /* synthetic */ Class class$org$hibernate$tool$instrument$javassist$FieldHandled;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void execute() throws BuildException {
        Project project = this.getProject();
        Iterator filesets = this.filesets.iterator();
        while (filesets.hasNext()) {
            FileSet fs = (FileSet)filesets.next();
            DirectoryScanner ds = fs.getDirectoryScanner(project);
            String[] includedFiles = ds.getIncludedFiles();
            File d = fs.getDir(project);
            for (int i = 0; i < includedFiles.length; ++i) {
                File file = new File(d, includedFiles[i]);
                try {
                    this.transformFile(file);
                    continue;
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transformFile(File file) throws Exception {
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        ClassFile classfile = null;
        try {
            classfile = new ClassFile(in);
        }
        catch (IOException e) {
            System.err.println("ignoring " + file.toURL() + " : " + e);
            return;
        }
        FieldTransformer transformer = this.getFieldTransformer(classfile);
        if (transformer == null) {
            return;
        }
        if (this.verbose) {
            System.out.println("processing " + file.toURL());
        }
        transformer.transform(classfile);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
        try {
            classfile.write(out);
        }
        finally {
            out.close();
        }
    }

    protected FieldTransformer getFieldTransformer(ClassFile classfile) {
        if (this.alreadyInstrumented(classfile)) {
            return null;
        }
        return new FieldTransformer(new FieldFilter(){

            public boolean handleRead(String desc, String name) {
                return true;
            }

            public boolean handleWrite(String desc, String name) {
                return true;
            }
        });
    }

    private boolean alreadyInstrumented(ClassFile classfile) {
        String[] intfs = classfile.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            if (!(class$org$hibernate$tool$instrument$javassist$FieldHandled == null ? InstrumentTask.class$("org.hibernate.tool.instrument.javassist.FieldHandled") : class$org$hibernate$tool$instrument$javassist$FieldHandled).getName().equals(intfs[i])) continue;
            return true;
        }
        return false;
    }
}

