/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.lucene.event;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.Initializable;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.lucene.DocumentBuilder;
import org.hibernate.lucene.Indexed;
import org.hibernate.mapping.PersistentClass;

public class LuceneEventListener
implements PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
Initializable {
    private Map<Class, DocumentBuilder> documentBuilders = new HashMap<Class, DocumentBuilder>();
    private boolean initialized;
    private static final Log log = LogFactory.getLog(LuceneEventListener.class);

    public void initialize(Configuration cfg) {
        File indexDir;
        Analyzer analyzer;
        Class analyzerClass;
        if (this.initialized) {
            return;
        }
        String analyzerClassName = cfg.getProperty("hibernate.lucene.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = Class.forName(analyzerClassName);
            }
            catch (Exception e) {
                throw new HibernateException("Lucene analyzer class '" + analyzerClassName + "' defined in property '" + "hibernate.lucene.analyzer" + "' could not be found.", e);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        try {
            analyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Failed to instantiate lucene analyzer with type " + analyzerClassName);
        }
        String indexDirName = cfg.getProperty("hibernate.lucene.index_dir");
        File file = indexDir = indexDirName != null ? new File(indexDirName) : new File(".");
        if (!indexDir.exists() || !indexDir.isDirectory()) {
            throw new HibernateException("Index directory does not exists: hibernate.lucene.index_dir");
        }
        if (!indexDir.canWrite()) {
            throw new HibernateException("Cannot write into index directory: hibernate.lucene.index_dir");
        }
        log.info((Object)("Setting index dir to " + indexDir));
        Iterator iter = cfg.getClassMappings();
        while (iter.hasNext()) {
            PersistentClass clazz = (PersistentClass)iter.next();
            Class mappedClass = clazz.getMappedClass();
            if (mappedClass == null || mappedClass.getAnnotation(Indexed.class) == null) continue;
            DocumentBuilder documentBuilder = new DocumentBuilder(mappedClass, analyzer, indexDir);
            this.documentBuilders.put(mappedClass, documentBuilder);
            log.info((Object)("index: " + documentBuilder.getFile().getAbsolutePath()));
        }
        this.initialized = true;
    }

    public void onPostDelete(PostDeleteEvent event) {
        DocumentBuilder builder = this.documentBuilders.get(event.getEntity().getClass());
        if (builder != null) {
            this.remove(builder, event.getId());
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        Object entity = event.getEntity();
        DocumentBuilder builder = this.documentBuilders.get(entity.getClass());
        if (builder != null) {
            this.add(entity, builder, event.getId());
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        Object entity = event.getEntity();
        DocumentBuilder builder = this.documentBuilders.get(entity.getClass());
        if (builder != null) {
            Serializable id = event.getId();
            this.remove(builder, id);
            this.add(entity, builder, id);
        }
    }

    private void remove(DocumentBuilder builder, Serializable id) {
        Term term = builder.getTerm(id);
        log.debug((Object)("removing: " + term));
        try {
            IndexReader reader = IndexReader.open((File)builder.getFile());
            reader.delete(term);
            reader.close();
        }
        catch (IOException ioe) {
            throw new HibernateException(ioe);
        }
    }

    private void add(Object entity, DocumentBuilder builder, Serializable id) {
        Document doc = builder.getDocument(entity, id);
        log.debug((Object)("adding: " + doc));
        try {
            File file = builder.getFile();
            IndexWriter writer = new IndexWriter(file, builder.getAnalyzer(), !file.exists());
            writer.addDocument(doc);
            writer.close();
        }
        catch (IOException ioe) {
            throw new HibernateException(ioe);
        }
    }
}

