/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.util.FastCollection;
import org.drools.util.FastComparator;

public class FastMap
implements Map,
Serializable {
    private static final long serialVersionUID = -4281546938715716829L;
    private static final int R0 = 5;
    private static final int M0 = 31;
    private transient Entry[][] _entries;
    private transient Entry _head = new Entry();
    private transient Entry _tail = new Entry();
    private transient int _size;
    private transient Values _values = new Values();
    private transient KeySet _keySet = new KeySet();
    private transient EntrySet _entrySet = new EntrySet();
    private transient Map _unmodifiable = new Unmodifiable();
    private transient FastMap _oldEntries;
    private transient FastComparator _keyComparator = FastComparator.DEFAULT;
    private transient FastComparator _keyComp = FastComparator.REHASH_SYSTEM_HASHCODE ? FastComparator.REHASH : null;
    private transient boolean _isShared;
    private static final Entry[] NULL_BLOCK = new Entry[32];
    static volatile boolean CHECK_POINT;

    public FastMap() {
        this(4);
    }

    public FastMap(int n) {
        int n2;
        for (n2 = 32; n2 < n; n2 <<= 1) {
        }
        this._entries = new Entry[n2 >> 5][];
        int n3 = 0;
        while (n3 < this._entries.length) {
            this._entries[n3++] = new Entry[32];
        }
        this._head._next = this._tail;
        this._tail._previous = this._head;
        Entry entry = this._tail;
        int n4 = 0;
        while (n4++ < n) {
            Entry entry2 = new Entry();
            entry2._previous = entry;
            entry._next = entry2;
            entry = entry2;
        }
    }

    public FastMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    private FastMap(Entry[][] entryArray) {
        this._entries = entryArray;
        this._head._next = this._tail;
        this._tail._previous = this._head;
    }

    public final Entry head() {
        return this._head;
    }

    public final Entry tail() {
        return this._tail;
    }

    public final int size() {
        return this._size;
    }

    public final boolean isEmpty() {
        return this._head._next == this._tail;
    }

    public final boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    public final boolean containsValue(Object object) {
        return this._values.contains(object);
    }

    public final Object get(Object object) {
        Entry entry = this.getEntry(object, this._keyComp == null ? object.hashCode() : this._keyComp.hashCodeOf(object));
        return entry != null ? entry._value : null;
    }

    public final Entry getEntry(Object object) {
        return this.getEntry(object, this._keyComp == null ? object.hashCode() : this._keyComp.hashCodeOf(object));
    }

    public final Object put(Object object, Object object2) {
        int n;
        int n2 = n = this._keyComp == null ? object.hashCode() : this._keyComp.hashCodeOf(object);
        if (this._isShared) {
            return this.putShared(object, object2, n);
        }
        Entry entry = this.getEntry(object, n);
        if (entry == null) {
            this.addEntry(n, object, object2);
            return null;
        }
        Object object3 = entry._value;
        entry._value = object2;
        return object3;
    }

    private synchronized Object putShared(Object object, Object object2, int n) {
        Entry entry = this.getEntry(object, n);
        if (entry == null) {
            this.addEntry(n, object, object2);
            return null;
        }
        Object object3 = entry._value;
        entry._value = object2;
        return object3;
    }

    public final void putAll(Map map) {
        if (map instanceof FastMap) {
            FastMap fastMap = (FastMap)map;
            Entry entry = fastMap._head;
            Entry entry2 = fastMap._tail;
            while ((entry = entry._next) != entry2) {
                this.put(entry._key, entry._value);
            }
        } else {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public final Object remove(Object object) {
        if (this._isShared) {
            return this.removeShared(object);
        }
        Entry entry = this.getEntry(object);
        if (entry != null) {
            Object object2 = entry._value;
            this.removeEntry(entry);
            return object2;
        }
        return null;
    }

    private synchronized Object removeShared(Object object) {
        Entry entry = this.getEntry(object);
        if (entry != null) {
            --this._size;
            entry.detach();
            return entry._value;
        }
        return null;
    }

    public FastMap setShared(boolean bl) {
        this._isShared = bl;
        return this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    public FastMap setKeyComparator(FastComparator fastComparator) {
        this._keyComparator = fastComparator;
        this._keyComp = fastComparator instanceof FastComparator.Default ? (FastComparator.REHASH_SYSTEM_HASHCODE ? FastComparator.REHASH : null) : (fastComparator instanceof FastComparator.Direct ? null : fastComparator);
        return this;
    }

    public FastComparator getKeyComparator() {
        return this._keyComparator;
    }

    public FastMap setValueComparator(FastComparator fastComparator) {
        this._values.setValueComparator(fastComparator);
        return this;
    }

    public FastComparator getValueComparator() {
        return this._values.getValueComparator();
    }

    public final void clear() {
        if (this._isShared) {
            this.clearShared();
            return;
        }
        Entry entry = this._head;
        Entry entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            entry._key = null;
            entry._value = null;
            Entry[][] entryArray = entry._table;
            entryArray[((Entry)entry)._keyHash >> 5 & entryArray.length - 1][((Entry)entry)._keyHash & 0x1F] = null;
        }
        this._tail = this._head._next;
        this._size = 0;
        this._oldEntries = null;
    }

    private synchronized void clearShared() {
        Entry entry = this._head;
        Entry entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            Entry[][] entryArray = entry._table;
            entryArray[((Entry)entry)._keyHash >> 5 & entryArray.length - 1][((Entry)entry)._keyHash & 0x1F] = null;
        }
        this._head._next = this._tail;
        this._tail._previous = this._head;
        this._oldEntries = null;
        this._size = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() == map.size()) {
                Set set = map.entrySet();
                Entry entry = this._head;
                Entry entry2 = this._tail;
                while ((entry = entry._next) != entry2) {
                    if (set.contains(entry)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        Entry entry = this._head;
        Entry entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            n += entry.hashCode();
        }
        return n;
    }

    public String toString() {
        return this._entrySet.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream printStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this._entries.length; ++i) {
            for (int j = 0; j < this._entries[i].length; ++j) {
                Entry entry = this._entries[i][j];
                int n4 = 0;
                while (entry != null) {
                    if (++n4 > n) {
                        n = n4;
                    }
                    if (n4 > 1) {
                        ++n2;
                    }
                    entry = entry._beside;
                    ++n3;
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 != 0) {
            stringBuffer.append(100 * n2 / n3);
            stringBuffer.append('%');
        } else {
            stringBuffer.append("N/A");
        }
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.print("SIZE: " + n3);
            printStream.print(", TABLE LENGTH: " + this._entries.length * this._entries[0].length);
            printStream.print(", AVG COLLISIONS: " + stringBuffer);
            printStream.print(", MAX SLOT OCCUPANCY: " + n);
            printStream.print(", KEY COMPARATOR: " + (this._keyComp == null ? FastComparator.DIRECT : this._keyComp));
            printStream.print(", SHARED: " + this._isShared);
            printStream.println();
            if (this._oldEntries != null) {
                printStream.print(" + ");
                this._oldEntries.printStatistics(printStream);
            }
        }
    }

    public final Collection values() {
        return this._values;
    }

    public final Set entrySet() {
        return this._entrySet;
    }

    public final Set keySet() {
        return this._keySet;
    }

    public final Map unmodifiable() {
        return this._unmodifiable;
    }

    private final Entry getEntry(Object object, int n) {
        Entry entry = this._entries[n >> 5 & this._entries.length - 1][n & 0x1F];
        while (entry != null) {
            if (object == entry._key || entry._keyHash == n && (this._keyComp == null ? object.equals(entry._key) : this._keyComp.areEqual(object, entry._key))) {
                return entry;
            }
            entry = entry._beside;
        }
        return this._oldEntries != null ? this._oldEntries.getEntry(object, n) : null;
    }

    private void addEntry(int n, Object object, Object object2) {
        if (this._size++ >> 5 >= this._entries.length) {
            this.increaseEntryTable();
        }
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        Entry entry = this._tail._next;
        this._tail._key = object;
        this._tail._value = object2;
        this._tail._keyHash = n;
        Entry.access$1002(this._tail, this._entries);
        int n2 = n >> 5 & this._entries.length - 1;
        Entry[] entryArray = this._entries[n2];
        if (entryArray == NULL_BLOCK) {
            this.newBlock(n2);
            entryArray = this._entries[n2];
        }
        Entry entry2 = entryArray[n & 0x1F];
        this._tail._beside = entry2;
        entryArray[n & 0x1F] = this._tail;
        this._tail = entry;
    }

    private final void removeEntry(Entry entry) {
        --this._size;
        entry._key = null;
        entry._value = null;
        entry.detach();
        Entry entry2 = this._tail._next;
        entry._previous = this._tail;
        entry._next = entry2;
        this._tail._next = entry;
        if (entry2 != null) {
            entry2._previous = entry;
        }
    }

    private void newBlock(int n) {
        this._entries[n] = new Entry[32];
    }

    private void increaseCapacity() {
        Entry entry = new Entry();
        this._tail._next = entry;
        entry._previous = this._tail;
        Entry entry2 = new Entry();
        entry._next = entry2;
        entry2._previous = entry;
        Entry entry3 = new Entry();
        entry2._next = entry3;
        entry3._previous = entry2;
        Entry entry4 = new Entry();
        entry3._next = entry4;
        entry4._previous = entry3;
    }

    private void increaseEntryTable() {
        FastMap fastMap;
        int n = this._entries.length << 3;
        if (n <= 8) {
            fastMap = new FastMap(new Entry[8][]);
        } else if (n <= 64) {
            fastMap = new FastMap(new Entry[64][]);
        } else if (n <= 512) {
            fastMap = new FastMap(new Entry[512][]);
        } else if (n <= 4096) {
            fastMap = new FastMap(new Entry[4096][]);
        } else if (n <= 32768) {
            fastMap = new FastMap(new Entry[32768][]);
        } else if (n <= 262144) {
            fastMap = new FastMap(new Entry[262144][]);
        } else if (n <= 0x200000) {
            fastMap = new FastMap(new Entry[0x200000][]);
        } else if (n <= 0x1000000) {
            fastMap = new FastMap(new Entry[0x1000000][]);
        } else if (n <= 0x8000000) {
            fastMap = new FastMap(new Entry[0x8000000][]);
        } else {
            return;
        }
        int n2 = 0;
        while (n2 < fastMap._entries.length) {
            fastMap._entries[n2++] = NULL_BLOCK;
        }
        Entry[][] entryArray = fastMap._entries;
        fastMap._entries = this._entries;
        fastMap._oldEntries = this._oldEntries;
        fastMap._keyComp = this._keyComp;
        fastMap._head = null;
        fastMap._tail = null;
        fastMap._size = -1;
        this._oldEntries = fastMap;
        FastMap.checkpoint();
        this._entries = entryArray;
    }

    public void reset() {
        this.setShared(false);
        this.clear();
        this.setKeyComparator(FastComparator.DEFAULT);
        this.setValueComparator(FastComparator.DEFAULT);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        this._entries = new Entry[n2][];
        int n3 = 0;
        while (n3 < this._entries.length) {
            this._entries[n3++] = NULL_BLOCK;
        }
        this._head = new Entry();
        this._tail = new Entry();
        this._head._next = this._tail;
        this._tail._previous = this._head;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._unmodifiable = new Unmodifiable();
        this.setShared(objectInputStream.readBoolean());
        this.setKeyComparator((FastComparator)objectInputStream.readObject());
        this.setValueComparator((FastComparator)objectInputStream.readObject());
        for (n3 = 0; n3 < n; ++n3) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.addEntry(this._keyComparator.hashCodeOf(object), object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._size);
        objectOutputStream.writeInt(this._entries.length);
        objectOutputStream.writeBoolean(this._isShared);
        objectOutputStream.writeObject(this._keyComparator);
        objectOutputStream.writeObject(this._values.getValueComparator());
        Entry entry = this._head;
        Entry entry2 = this._tail;
        while ((entry = entry._next) != entry2) {
            objectOutputStream.writeObject(entry._key);
            objectOutputStream.writeObject(entry._value);
        }
    }

    private static void checkpoint() {
        if (CHECK_POINT) {
            throw new Error();
        }
    }

    private final class Unmodifiable
    implements Map,
    Serializable {
        private static final long serialVersionUID = 2699246906507262549L;

        private Unmodifiable() {
        }

        public boolean equals(Object object) {
            return FastMap.this.equals(object);
        }

        public int hashCode() {
            return FastMap.this.hashCode();
        }

        public String toString() {
            return FastMap.this.toString();
        }

        public int size() {
            return FastMap.this.size();
        }

        public boolean isEmpty() {
            return FastMap.this.isEmpty();
        }

        public boolean containsKey(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return FastMap.this.containsValue(object);
        }

        public Object get(Object object) {
            return FastMap.this.get(object);
        }

        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Object remove(Object object) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void putAll(Map map) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public void clear() {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        public Set keySet() {
            return (Set)FastMap.this._keySet.unmodifiable();
        }

        public Collection values() {
            return FastMap.this._values.unmodifiable();
        }

        public Set entrySet() {
            throw new UnsupportedOperationException("Direct view over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the keySet() and values() fast collection views in conjonction.");
        }
    }

    public static final class Entry
    implements Map.Entry,
    FastCollection.Record {
        private Entry _next;
        private Entry _previous;
        private Object _key;
        private Object _value;
        private Entry _beside;
        private Entry[][] _table;
        private int _keyHash;

        private Entry() {
        }

        public final FastCollection.Record getNext() {
            return this._next;
        }

        public final FastCollection.Record getPrevious() {
            return this._previous;
        }

        public final Object getKey() {
            return this._key;
        }

        public final Object getValue() {
            return this._value;
        }

        public final Object setValue(Object object) {
            Object object2 = this._value;
            this._value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this._key.equals(entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        private final void detach() {
            this._previous._next = this._next;
            this._next._previous = this._previous;
            int n = this._keyHash >> 5 & this._table.length - 1;
            Entry entry = this._beside;
            Entry entry2 = this._table[n][this._keyHash & 0x1F];
            if (entry2 == this) {
                this._table[n][this._keyHash & 0x1F] = entry;
            } else {
                while (entry2._beside != this) {
                    entry2 = entry2._beside;
                }
                entry2._beside = entry;
            }
        }

        static /* synthetic */ Entry[][] access$1002(Entry entry, Entry[][] entryArray) {
            entry._table = entryArray;
            return entryArray;
        }
    }

    private final class KeySet
    extends FastCollection
    implements Set {
        private static final long serialVersionUID = -2629453921452583782L;

        private KeySet() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            return FastMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return FastMap.this.remove(object) != null;
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._key;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    private final class EntrySet
    extends FastCollection
    implements Set {
        private static final long serialVersionUID = 8729117163337735415L;

        private EntrySet() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Entry entry = (Entry)object;
                Entry entry2 = FastMap.this.getEntry(entry.getKey());
                return ((Object)entry).equals(entry2);
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[");
            Entry entry = FastMap.this._head;
            Entry entry2 = FastMap.this._tail;
            while ((entry = entry._next) != entry2) {
                stringBuffer = stringBuffer.append(String.valueOf(entry._key)).append("=").append(String.valueOf(entry._value));
                if (entry._next == entry2) continue;
                stringBuffer = stringBuffer.append(", ");
            }
            return stringBuffer.append(']').toString();
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return record;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }

    private final class Values
    extends FastCollection {
        private static final long serialVersionUID = 8804295702684770940L;

        private Values() {
        }

        public int size() {
            return FastMap.this._size;
        }

        public void clear() {
            FastMap.this.clear();
        }

        public FastCollection.Record head() {
            return FastMap.this._head;
        }

        public FastCollection.Record tail() {
            return FastMap.this._tail;
        }

        public Object valueOf(FastCollection.Record record) {
            return ((Entry)record)._value;
        }

        public void delete(FastCollection.Record record) {
            FastMap.this.remove(((Entry)record).getKey());
        }
    }
}

