/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.FactHandle;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.FactHandleList;

class TupleKey
implements Serializable {
    private static final long serialVersionUID = -880184112928387666L;
    public static final TupleKey EMPTY_KEY = new TupleKey();
    private final FactHandleList handles;
    private long recency = 0L;

    private TupleKey() {
        this.handles = FactHandleList.EMPTY_LIST;
    }

    public TupleKey(TupleKey tupleKey) {
        this.handles = tupleKey.handles;
        this.recency = tupleKey.recency;
    }

    public TupleKey(DefaultFactHandle defaultFactHandle) {
        this.handles = new FactHandleList(defaultFactHandle);
        this.recency = defaultFactHandle.getRecency();
    }

    public TupleKey(TupleKey tupleKey, DefaultFactHandle defaultFactHandle) {
        this.handles = new FactHandleList(tupleKey.handles, defaultFactHandle);
        this.recency = tupleKey.recency + defaultFactHandle.getRecency();
    }

    public String toString() {
        return "[TupleKey: recency=" + this.recency + " handles=" + this.handles + "]";
    }

    public InternalFactHandle get(int n) {
        return this.handles.get(n);
    }

    public boolean containsFactHandle(FactHandle factHandle) {
        return this.handles.contains(factHandle);
    }

    public boolean containsAll(TupleKey tupleKey) {
        return this.handles.containsAll(tupleKey.handles);
    }

    InternalFactHandle[] getFactHandles() {
        return this.handles.getHandles();
    }

    public int size() {
        return this.handles.size();
    }

    public long getRecency() {
        return this.recency;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.handles.equals(((TupleKey)object).handles);
    }

    public int hashCode() {
        return this.handles.hashCode();
    }
}

