/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class ShortFactory {
    public static Evaluator getShortEvaluator(int n) {
        switch (n) {
            case 1: {
                return ShortEqualEvaluator.getInstance();
            }
            case 10: {
                return ShortNotEqualEvaluator.getInstance();
            }
            case 20: {
                return ShortLessEvaluator.getInstance();
            }
            case 30: {
                return ShortLessOrEqualEvaluator.getInstance();
            }
            case 40: {
                return ShortGreaterEvaluator.getInstance();
            }
            case 50: {
                return ShortGreaterOrEqualEvaluator.getInstance();
            }
        }
        throw new RuntimeException("Operator '" + n + "' does not exist for ShortEvaluator");
    }

    static class ShortGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 1254418853497580320L;
        private static Evaluator INSTANCE;

        public static Evaluator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ShortGreaterOrEqualEvaluator();
            }
            return INSTANCE;
        }

        private ShortGreaterOrEqualEvaluator() {
            super(120, 50);
        }

        public boolean evaluate(Object object, Object object2) {
            return ((Number)object).shortValue() >= ((Number)object2).shortValue();
        }

        public String toString() {
            return "Short >=";
        }
    }

    static class ShortGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -3260955087091852509L;
        private static Evaluator INSTANCE;

        public static Evaluator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ShortGreaterEvaluator();
            }
            return INSTANCE;
        }

        private ShortGreaterEvaluator() {
            super(120, 40);
        }

        public boolean evaluate(Object object, Object object2) {
            return ((Number)object).shortValue() > ((Number)object2).shortValue();
        }

        public String toString() {
            return "Short >";
        }
    }

    static class ShortLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -1541816846266081605L;
        private static Evaluator INSTANCE;

        public static Evaluator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ShortLessOrEqualEvaluator();
            }
            return INSTANCE;
        }

        private ShortLessOrEqualEvaluator() {
            super(120, 30);
        }

        public boolean evaluate(Object object, Object object2) {
            return ((Number)object).shortValue() <= ((Number)object2).shortValue();
        }

        public String toString() {
            return "Boolean <=";
        }
    }

    static class ShortLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -1562867187426899162L;
        private static Evaluator INSTANCE;

        public static Evaluator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ShortLessEvaluator();
            }
            return INSTANCE;
        }

        private ShortLessEvaluator() {
            super(120, 20);
        }

        public boolean evaluate(Object object, Object object2) {
            return ((Number)object).shortValue() < ((Number)object2).shortValue();
        }

        public String toString() {
            return "Short <";
        }
    }

    static class ShortNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -273350270376804828L;
        private static Evaluator INSTANCE;

        public static Evaluator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ShortNotEqualEvaluator();
            }
            return INSTANCE;
        }

        private ShortNotEqualEvaluator() {
            super(120, 10);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 != null;
            }
            return !((Number)object).equals(object2);
        }

        public String toString() {
            return "Short !=";
        }
    }

    static class ShortEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 8933390138182317179L;
        private static Evaluator INSTANCE;

        public static Evaluator getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new ShortEqualEvaluator();
            }
            return INSTANCE;
        }

        private ShortEqualEvaluator() {
            super(120, 1);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            return ((Number)object).equals(object2);
        }

        public String toString() {
            return "Short ==";
        }
    }
}

