/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.drools.base.BaseEvaluator;
import org.drools.spi.Evaluator;

public class DateFactory {
    private static final String DEFAULT_FORMAT_MASK = "dd-MMM-yyyy";
    private static final String DATE_FORMAT_MASK = DateFactory.getDateFormatMask();

    public static Evaluator getDateEvaluator(int n) {
        switch (n) {
            case 1: {
                return DateEqualEvaluator.INSTANCE;
            }
            case 10: {
                return DateNotEqualEvaluator.INSTANCE;
            }
            case 20: {
                return DateLessEvaluator.INSTANCE;
            }
            case 30: {
                return DateLessOrEqualEvaluator.INSTANCE;
            }
            case 40: {
                return DateGreaterEvaluator.INSTANCE;
            }
            case 50: {
                return DateGreaterOrEqualEvaluator.INSTANCE;
            }
        }
        throw new RuntimeException("Operator '" + n + "' does not exist for DateEvaluator");
    }

    private static Date parseDate(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT_MASK);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid date input format: [" + string + "] it should follow: [" + DATE_FORMAT_MASK + "]");
        }
    }

    private static Date getRightDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return DateFactory.parseDate((String)object);
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        throw new IllegalArgumentException("Unable to convert " + object.getClass() + " to a Date.");
    }

    private static String getDateFormatMask() {
        String string = System.getProperty("drools.dateformat");
        if (string == null) {
            string = DEFAULT_FORMAT_MASK;
        }
        return string;
    }

    static class DateGreaterOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -6149840707848164332L;
        private static final Evaluator INSTANCE = new DateGreaterOrEqualEvaluator();

        private DateGreaterOrEqualEvaluator() {
            super(190, 50);
        }

        public boolean evaluate(Object object, Object object2) {
            Date date = (Date)object;
            return date.compareTo(DateFactory.getRightDate(object2)) >= 0;
        }

        public String toString() {
            return "Date >=";
        }
    }

    static class DateGreaterEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 1450531664603794369L;
        public static final Evaluator INSTANCE = new DateGreaterEvaluator();

        private DateGreaterEvaluator() {
            super(190, 40);
        }

        public boolean evaluate(Object object, Object object2) {
            Date date = (Date)object;
            return date.compareTo(DateFactory.getRightDate(object2)) > 0;
        }

        public String toString() {
            return "Date >";
        }
    }

    static class DateLessOrEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -1545183091770593710L;
        public static final Evaluator INSTANCE = new DateLessOrEqualEvaluator();

        private DateLessOrEqualEvaluator() {
            super(190, 30);
        }

        public boolean evaluate(Object object, Object object2) {
            Date date = (Date)object;
            return date.compareTo(DateFactory.getRightDate(object2)) <= 0;
        }

        public String toString() {
            return "Date <=";
        }
    }

    static class DateLessEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -4362504881470806670L;
        public static final Evaluator INSTANCE = new DateLessEvaluator();

        private DateLessEvaluator() {
            super(190, 20);
        }

        public boolean evaluate(Object object, Object object2) {
            Date date = (Date)object;
            return date.compareTo(DateFactory.getRightDate(object2)) < 0;
        }

        public String toString() {
            return "Date <";
        }
    }

    static class DateNotEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -999744404766802074L;
        public static final Evaluator INSTANCE = new DateNotEqualEvaluator();

        private DateNotEqualEvaluator() {
            super(190, 10);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 != null;
            }
            if (object2 == null) {
                return true;
            }
            Date date = (Date)object;
            return date.compareTo(DateFactory.getRightDate(object2)) != 0;
        }

        public String toString() {
            return "Date !=";
        }
    }

    static class DateEqualEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = -7248999526793624416L;
        public static final Evaluator INSTANCE = new DateEqualEvaluator();

        private DateEqualEvaluator() {
            super(190, 1);
        }

        public boolean evaluate(Object object, Object object2) {
            if (object == null) {
                return object2 == null;
            }
            if (object2 == null) {
                return false;
            }
            Date date = (Date)object;
            return date.compareTo(DateFactory.getRightDate(object2)) == 0;
        }

        public String toString() {
            return "Date ==";
        }
    }
}

