/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import javassist.ClassPool;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.Opcode;
import javassist.bytecode.stackmap.TypeData;
import javassist.bytecode.stackmap.TypeTag;

public abstract class Tracer
implements TypeTag {
    protected ClassPool classPool;
    protected ConstPool cpool;
    protected String returnType;
    protected int stackTop;
    protected TypeData[] stackTypes;
    protected TypeData[] localsTypes;
    static final int UNKNOWN = 0;
    static final int READ = 1;
    static final int UPDATED = 2;
    protected int[] localsUsage;

    public Tracer(ClassPool classes, ConstPool cp, int maxStack, int maxLocals, String retType) {
        this.classPool = classes;
        this.cpool = cp;
        this.returnType = retType;
        this.stackTop = 0;
        this.stackTypes = new TypeData[maxStack];
        this.localsTypes = new TypeData[maxLocals];
        this.localsUsage = new int[maxLocals];
    }

    protected final void readLocal(int reg) {
        if (this.localsUsage[reg] == 0) {
            this.localsUsage[reg] = 1;
        }
    }

    protected final void writeLocal(int reg) {
        if (this.localsUsage[reg] == 0) {
            this.localsUsage[reg] = 2;
        }
    }

    protected int doOpcode(int pos, byte[] code) throws BadBytecode {
        int op = code[pos] & 0xFF;
        if (op < 96) {
            if (op < 54) {
                return this.doOpcode0_53(pos, code, op);
            }
            return this.doOpcode54_95(pos, code, op);
        }
        if (op < 148) {
            return this.doOpcode96_147(pos, code, op);
        }
        return this.doOpcode148_201(pos, code, op);
    }

    protected void visitBranch(int pos, byte[] code, int offset) throws BadBytecode {
    }

    protected void visitGoto(int pos, byte[] code, int offset) throws BadBytecode {
    }

    protected void visitReturn(int pos, byte[] code) throws BadBytecode {
    }

    protected void visitThrow(int pos, byte[] code) throws BadBytecode {
    }

    protected void visitTableSwitch(int pos, byte[] code, int n, int offsetPos, int defaultOffset) throws BadBytecode {
    }

    protected void visitLookupSwitch(int pos, byte[] code, int n, int pairsPos, int defaultOffset) throws BadBytecode {
    }

    protected void visitJSR(int pos, byte[] code) throws BadBytecode {
        this.throwBadBytecode(pos, "jsr");
    }

    protected void visitRET(int pos, byte[] code) throws BadBytecode {
        this.throwBadBytecode(pos, "ret");
    }

    private void throwBadBytecode(int pos, String name) throws BadBytecode {
        throw new BadBytecode(name + " at " + pos);
    }

    private int doOpcode0_53(int pos, byte[] code, int op) throws BadBytecode {
        TypeData[] stackTypes = this.stackTypes;
        switch (op) {
            case 0: {
                break;
            }
            case 1: {
                stackTypes[this.stackTop++] = new TypeData.NullType();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                stackTypes[this.stackTop++] = TypeTag.INTEGER;
                break;
            }
            case 9: 
            case 10: {
                stackTypes[this.stackTop++] = TypeTag.LONG;
                stackTypes[this.stackTop++] = TypeTag.TOP;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                stackTypes[this.stackTop++] = TypeTag.FLOAT;
                break;
            }
            case 14: 
            case 15: {
                stackTypes[this.stackTop++] = TypeTag.DOUBLE;
                stackTypes[this.stackTop++] = TypeTag.TOP;
                break;
            }
            case 16: 
            case 17: {
                stackTypes[this.stackTop++] = TypeTag.INTEGER;
                return op == 17 ? 3 : 2;
            }
            case 18: {
                this.doLDC(code[pos + 1] & 0xFF);
                return 2;
            }
            case 19: 
            case 20: {
                this.doLDC(ByteArray.readU16bit(code, pos + 1));
                return 3;
            }
            case 21: {
                return this.doXLOAD(TypeTag.INTEGER, code, pos);
            }
            case 22: {
                return this.doXLOAD(TypeTag.LONG, code, pos);
            }
            case 23: {
                return this.doXLOAD(TypeTag.FLOAT, code, pos);
            }
            case 24: {
                return this.doXLOAD(TypeTag.DOUBLE, code, pos);
            }
            case 25: {
                return this.doALOAD(code[pos + 1] & 0xFF);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                stackTypes[this.stackTop++] = TypeTag.INTEGER;
                this.readLocal(op - 26);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                stackTypes[this.stackTop++] = TypeTag.LONG;
                stackTypes[this.stackTop++] = TypeTag.TOP;
                this.readLocal(op - 30);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                stackTypes[this.stackTop++] = TypeTag.FLOAT;
                this.readLocal(op - 34);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                stackTypes[this.stackTop++] = TypeTag.DOUBLE;
                stackTypes[this.stackTop++] = TypeTag.TOP;
                this.readLocal(op - 38);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                int reg = op - 42;
                stackTypes[this.stackTop++] = this.localsTypes[reg];
                this.readLocal(reg);
                break;
            }
            case 46: {
                stackTypes[--this.stackTop - 1] = TypeTag.INTEGER;
                break;
            }
            case 47: {
                stackTypes[this.stackTop - 2] = TypeTag.LONG;
                stackTypes[this.stackTop - 1] = TypeTag.TOP;
                break;
            }
            case 48: {
                stackTypes[--this.stackTop - 1] = TypeTag.FLOAT;
                break;
            }
            case 49: {
                stackTypes[this.stackTop - 2] = TypeTag.DOUBLE;
                stackTypes[this.stackTop - 1] = TypeTag.TOP;
                break;
            }
            case 50: {
                int s = --this.stackTop - 1;
                TypeData data = stackTypes[s];
                if (data == null || !data.isObjectType()) {
                    throw new BadBytecode("bad AALOAD");
                }
                stackTypes[s] = new TypeData.ArrayElement(data);
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                stackTypes[--this.stackTop - 1] = TypeTag.INTEGER;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private void doLDC(int index) {
        TypeData[] stackTypes = this.stackTypes;
        int tag = this.cpool.getTag(index);
        if (tag == 8) {
            stackTypes[this.stackTop++] = new TypeData.ClassName("java.lang.String");
        } else if (tag == 3) {
            stackTypes[this.stackTop++] = TypeTag.INTEGER;
        } else if (tag == 4) {
            stackTypes[this.stackTop++] = TypeTag.FLOAT;
        } else if (tag == 5) {
            stackTypes[this.stackTop++] = TypeTag.LONG;
            stackTypes[this.stackTop++] = TypeTag.TOP;
        } else if (tag == 6) {
            stackTypes[this.stackTop++] = TypeTag.DOUBLE;
            stackTypes[this.stackTop++] = TypeTag.TOP;
        } else if (tag == 7) {
            stackTypes[this.stackTop++] = new TypeData.ClassName("java.lang.Class");
        } else {
            throw new RuntimeException("bad LDC: " + tag);
        }
    }

    private int doXLOAD(TypeData type, byte[] code, int pos) {
        int localVar = code[pos + 1] & 0xFF;
        return this.doXLOAD(localVar, type);
    }

    private int doXLOAD(int localVar, TypeData type) {
        this.stackTypes[this.stackTop++] = type;
        if (type.is2WordType()) {
            this.stackTypes[this.stackTop++] = TypeTag.TOP;
        }
        this.readLocal(localVar);
        return 2;
    }

    private int doALOAD(int localVar) {
        this.stackTypes[this.stackTop++] = this.localsTypes[localVar];
        this.readLocal(localVar);
        return 2;
    }

    private int doOpcode54_95(int pos, byte[] code, int op) {
        TypeData[] localsTypes = this.localsTypes;
        TypeData[] stackTypes = this.stackTypes;
        switch (op) {
            case 54: {
                return this.doXSTORE(pos, code, TypeTag.INTEGER);
            }
            case 55: {
                return this.doXSTORE(pos, code, TypeTag.LONG);
            }
            case 56: {
                return this.doXSTORE(pos, code, TypeTag.FLOAT);
            }
            case 57: {
                return this.doXSTORE(pos, code, TypeTag.DOUBLE);
            }
            case 58: {
                return this.doASTORE(code[pos + 1] & 0xFF);
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                int var = op - 59;
                localsTypes[var] = TypeTag.INTEGER;
                this.writeLocal(var);
                --this.stackTop;
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                int var = op - 63;
                localsTypes[var] = TypeTag.LONG;
                localsTypes[var + 1] = TypeTag.TOP;
                this.writeLocal(var);
                this.stackTop -= 2;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                int var = op - 67;
                localsTypes[var] = TypeTag.FLOAT;
                this.writeLocal(var);
                --this.stackTop;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                int var = op - 71;
                localsTypes[var] = TypeTag.DOUBLE;
                localsTypes[var + 1] = TypeTag.TOP;
                this.writeLocal(var);
                this.stackTop -= 2;
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int var = op - 75;
                this.doASTORE(var);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.stackTop -= op == 80 || op == 82 ? 4 : 3;
                break;
            }
            case 87: {
                --this.stackTop;
                break;
            }
            case 88: {
                this.stackTop -= 2;
                break;
            }
            case 89: {
                int sp = this.stackTop;
                stackTypes[sp] = stackTypes[sp - 1];
                this.stackTop = sp + 1;
                break;
            }
            case 90: 
            case 91: {
                int len = op - 90 + 2;
                this.doDUP_XX(1, len);
                int sp = this.stackTop;
                stackTypes[sp - len] = stackTypes[sp];
                this.stackTop = sp + 1;
                break;
            }
            case 92: {
                this.doDUP_XX(2, 2);
                this.stackTop += 2;
                break;
            }
            case 93: 
            case 94: {
                int len = op - 93 + 3;
                this.doDUP_XX(2, len);
                int sp = this.stackTop;
                stackTypes[sp - len] = stackTypes[sp];
                stackTypes[sp - len + 1] = stackTypes[sp + 1];
                this.stackTop = sp + 2;
                break;
            }
            case 95: {
                int sp = this.stackTop - 1;
                TypeData t = stackTypes[sp];
                stackTypes[sp] = stackTypes[sp - 1];
                stackTypes[sp - 1] = t;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private int doXSTORE(int pos, byte[] code, TypeData type) {
        int index = code[pos + 1] & 0xFF;
        return this.doXSTORE(index, type);
    }

    private int doXSTORE(int index, TypeData type) {
        --this.stackTop;
        this.writeLocal(index);
        this.localsTypes[index] = type;
        if (type.is2WordType()) {
            --this.stackTop;
            this.localsTypes[index + 1] = TypeTag.TOP;
        }
        return 2;
    }

    private int doASTORE(int index) {
        --this.stackTop;
        this.writeLocal(index);
        this.localsTypes[index] = this.stackTypes[this.stackTop].copy();
        return 2;
    }

    private void doDUP_XX(int delta, int len) {
        int sp;
        TypeData[] types = this.stackTypes;
        int end = sp - len;
        for (sp = this.stackTop - 1; sp > end; --sp) {
            types[sp + delta] = types[sp];
        }
    }

    private int doOpcode96_147(int pos, byte[] code, int op) {
        if (op <= 131) {
            this.stackTop += Opcode.STACK_GROW[op];
            return 1;
        }
        switch (op) {
            case 132: {
                this.readLocal(code[pos + 1] & 0xFF);
                return 3;
            }
            case 133: {
                this.stackTypes[this.stackTop] = TypeTag.LONG;
                this.stackTypes[this.stackTop - 1] = TypeTag.TOP;
                ++this.stackTop;
                break;
            }
            case 134: {
                this.stackTypes[this.stackTop - 1] = TypeTag.FLOAT;
                break;
            }
            case 135: {
                this.stackTypes[this.stackTop] = TypeTag.DOUBLE;
                this.stackTypes[this.stackTop - 1] = TypeTag.TOP;
                ++this.stackTop;
                break;
            }
            case 136: {
                this.stackTypes[--this.stackTop - 1] = TypeTag.INTEGER;
                break;
            }
            case 137: {
                this.stackTypes[--this.stackTop - 1] = TypeTag.FLOAT;
                break;
            }
            case 138: {
                this.stackTypes[this.stackTop - 1] = TypeTag.DOUBLE;
                break;
            }
            case 139: {
                this.stackTypes[this.stackTop - 1] = TypeTag.INTEGER;
                break;
            }
            case 140: {
                this.stackTypes[this.stackTop - 1] = TypeTag.TOP;
                this.stackTypes[this.stackTop++] = TypeTag.LONG;
                break;
            }
            case 141: {
                this.stackTypes[this.stackTop - 1] = TypeTag.TOP;
                this.stackTypes[this.stackTop++] = TypeTag.DOUBLE;
                break;
            }
            case 142: {
                this.stackTypes[--this.stackTop - 1] = TypeTag.INTEGER;
                break;
            }
            case 143: {
                this.stackTypes[this.stackTop - 1] = TypeTag.LONG;
                break;
            }
            case 144: {
                this.stackTypes[--this.stackTop - 1] = TypeTag.FLOAT;
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private int doOpcode148_201(int pos, byte[] code, int op) throws BadBytecode {
        switch (op) {
            case 148: {
                this.stackTypes[this.stackTop - 4] = TypeTag.INTEGER;
                this.stackTop -= 3;
                break;
            }
            case 149: 
            case 150: {
                this.stackTypes[--this.stackTop - 1] = TypeTag.INTEGER;
                break;
            }
            case 151: 
            case 152: {
                this.stackTypes[this.stackTop - 4] = TypeTag.INTEGER;
                this.stackTop -= 3;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                --this.stackTop;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.stackTop -= 2;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 167: {
                this.visitGoto(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 168: {
                this.stackTypes[this.stackTop++] = TypeTag.TOP;
                this.visitJSR(pos, code);
                return 3;
            }
            case 169: {
                this.visitRET(pos, code);
                return 2;
            }
            case 170: {
                --this.stackTop;
                int pos2 = (pos & 0xFFFFFFFC) + 8;
                int low = ByteArray.read32bit(code, pos2);
                int high = ByteArray.read32bit(code, pos2 + 4);
                int n = high - low + 1;
                this.visitTableSwitch(pos, code, n, pos2 + 8, ByteArray.read32bit(code, pos2 - 4));
                return n * 4 + 16 - (pos & 3);
            }
            case 171: {
                --this.stackTop;
                int pos2 = (pos & 0xFFFFFFFC) + 8;
                int n = ByteArray.read32bit(code, pos2);
                this.visitLookupSwitch(pos, code, n, pos2 + 4, ByteArray.read32bit(code, pos2 - 4));
                return n * 8 + 12 - (pos & 3);
            }
            case 172: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 173: {
                this.stackTop -= 2;
                this.visitReturn(pos, code);
                break;
            }
            case 174: {
                --this.stackTop;
                this.visitReturn(pos, code);
                break;
            }
            case 175: {
                this.stackTop -= 2;
                this.visitReturn(pos, code);
                break;
            }
            case 176: {
                TypeData.setType(this.stackTypes[--this.stackTop], this.returnType, this.classPool);
                this.visitReturn(pos, code);
                break;
            }
            case 177: {
                this.visitReturn(pos, code);
                break;
            }
            case 178: {
                return this.doGetField(pos, code, false);
            }
            case 179: {
                return this.doPutField(pos, code, false);
            }
            case 180: {
                return this.doGetField(pos, code, true);
            }
            case 181: {
                return this.doPutField(pos, code, true);
            }
            case 182: 
            case 183: {
                return this.doInvokeMethod(pos, code, true);
            }
            case 184: {
                return this.doInvokeMethod(pos, code, false);
            }
            case 185: {
                return this.doInvokeIntfMethod(pos, code);
            }
            case 186: {
                throw new RuntimeException("bad opcode 186");
            }
            case 187: {
                int i = ByteArray.readU16bit(code, pos + 1);
                this.stackTypes[this.stackTop++] = new TypeData.UninitData(pos, this.cpool.getClassInfo(i));
                return 3;
            }
            case 188: {
                return this.doNEWARRAY(pos, code);
            }
            case 189: {
                int i = ByteArray.readU16bit(code, pos + 1);
                String type = this.cpool.getClassInfo(i).replace('.', '/');
                type = type.charAt(0) == '[' ? "[" + type : "[L" + type + ";";
                this.stackTypes[this.stackTop - 1] = new TypeData.ClassName(type);
                return 3;
            }
            case 190: {
                this.stackTypes[this.stackTop - 1] = TypeTag.INTEGER;
                break;
            }
            case 191: {
                TypeData.setType(this.stackTypes[--this.stackTop], "java.lang.Throwable", this.classPool);
                this.visitThrow(pos, code);
                break;
            }
            case 192: {
                int i = ByteArray.readU16bit(code, pos + 1);
                this.stackTypes[this.stackTop - 1] = new TypeData.ClassName(this.cpool.getClassInfo(i));
                return 3;
            }
            case 193: {
                this.stackTypes[this.stackTop - 1] = TypeTag.INTEGER;
                return 3;
            }
            case 194: 
            case 195: {
                --this.stackTop;
                break;
            }
            case 196: {
                return this.doWIDE(pos, code);
            }
            case 197: {
                return this.doMultiANewArray(pos, code);
            }
            case 198: 
            case 199: {
                --this.stackTop;
                this.visitBranch(pos, code, ByteArray.readS16bit(code, pos + 1));
                return 3;
            }
            case 200: {
                this.visitGoto(pos, code, ByteArray.read32bit(code, pos + 1));
                return 5;
            }
            case 201: {
                this.stackTypes[this.stackTop++] = TypeTag.TOP;
                this.visitJSR(pos, code);
                return 5;
            }
        }
        return 1;
    }

    private int doWIDE(int pos, byte[] code) throws BadBytecode {
        int op = code[pos + 1] & 0xFF;
        switch (op) {
            case 21: {
                this.doWIDE_XLOAD(pos, code, TypeTag.INTEGER);
                break;
            }
            case 22: {
                this.doWIDE_XLOAD(pos, code, TypeTag.LONG);
                break;
            }
            case 23: {
                this.doWIDE_XLOAD(pos, code, TypeTag.FLOAT);
                break;
            }
            case 24: {
                this.doWIDE_XLOAD(pos, code, TypeTag.DOUBLE);
                break;
            }
            case 25: {
                int index = ByteArray.readU16bit(code, pos + 2);
                this.doALOAD(index);
                break;
            }
            case 54: {
                return this.doWIDE_STORE(pos, code, TypeTag.INTEGER);
            }
            case 55: {
                return this.doWIDE_STORE(pos, code, TypeTag.LONG);
            }
            case 56: {
                return this.doWIDE_STORE(pos, code, TypeTag.FLOAT);
            }
            case 57: {
                return this.doWIDE_STORE(pos, code, TypeTag.DOUBLE);
            }
            case 58: {
                int index = ByteArray.readU16bit(code, pos + 2);
                return this.doASTORE(index);
            }
            case 132: {
                this.readLocal(ByteArray.readU16bit(code, pos + 2));
                return 6;
            }
            case 169: {
                this.visitRET(pos, code);
                break;
            }
            default: {
                throw new RuntimeException("bad WIDE instruction: " + op);
            }
        }
        return 4;
    }

    private int doWIDE_XLOAD(int pos, byte[] code, TypeData type) {
        int index = ByteArray.readU16bit(code, pos + 2);
        return this.doXLOAD(index, type);
    }

    private int doWIDE_STORE(int pos, byte[] code, TypeData type) {
        int index = ByteArray.readU16bit(code, pos + 2);
        return this.doXSTORE(index, type);
    }

    private int doPutField(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        int index = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getFieldrefType(index);
        this.stackTop -= Descriptor.dataSize(desc);
        char c = desc.charAt(0);
        if (c == 'L') {
            TypeData.setType(this.stackTypes[this.stackTop], Tracer.getFieldClassName(desc, 0), this.classPool);
        } else if (c == '[') {
            TypeData.setType(this.stackTypes[this.stackTop], desc, this.classPool);
        }
        this.setFieldTarget(notStatic, index);
        return 3;
    }

    private int doGetField(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        int index = ByteArray.readU16bit(code, pos + 1);
        this.setFieldTarget(notStatic, index);
        String desc = this.cpool.getFieldrefType(index);
        this.pushMemberType(desc);
        return 3;
    }

    private void setFieldTarget(boolean notStatic, int index) throws BadBytecode {
        if (notStatic) {
            String className = this.cpool.getFieldrefClassName(index);
            TypeData.setType(this.stackTypes[--this.stackTop], className, this.classPool);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int doNEWARRAY(int pos, byte[] code) {
        void var4_4;
        int s = this.stackTop - 1;
        switch (code[pos + 1] & 0xFF) {
            case 4: {
                String type = "[Z";
                break;
            }
            case 5: {
                String type = "[C";
                break;
            }
            case 6: {
                String type = "[F";
                break;
            }
            case 7: {
                String type = "[D";
                break;
            }
            case 8: {
                String type = "[B";
                break;
            }
            case 9: {
                String type = "[S";
                break;
            }
            case 10: {
                String type = "[I";
                break;
            }
            case 11: {
                String type = "[J";
                break;
            }
            default: {
                throw new RuntimeException("bad newarray");
            }
        }
        this.stackTypes[s] = new TypeData.ClassName((String)var4_4);
        return 2;
    }

    private int doMultiANewArray(int pos, byte[] code) {
        int i = ByteArray.readU16bit(code, pos + 1);
        int dim = code[pos + 3] & 0xFF;
        this.stackTop -= dim - 1;
        String type = this.cpool.getClassInfo(i).replace('.', '/');
        this.stackTypes[this.stackTop - 1] = new TypeData.ClassName(type);
        return 4;
    }

    private int doInvokeMethod(int pos, byte[] code, boolean notStatic) throws BadBytecode {
        int i = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getMethodrefType(i);
        this.checkParamTypes(desc, 1);
        if (notStatic) {
            String className = this.cpool.getMethodrefClassName(i);
            TypeData.setType(this.stackTypes[--this.stackTop], className, this.classPool);
        }
        this.pushMemberType(desc);
        return 3;
    }

    private int doInvokeIntfMethod(int pos, byte[] code) throws BadBytecode {
        int i = ByteArray.readU16bit(code, pos + 1);
        String desc = this.cpool.getInterfaceMethodrefType(i);
        this.checkParamTypes(desc, 1);
        String className = this.cpool.getInterfaceMethodrefClassName(i);
        TypeData.setType(this.stackTypes[--this.stackTop], className, this.classPool);
        this.pushMemberType(desc);
        return 5;
    }

    private void pushMemberType(String descriptor) {
        int top = 0;
        if (descriptor.charAt(0) == '(' && (top = descriptor.indexOf(41) + 1) < 1) {
            throw new IndexOutOfBoundsException("bad descriptor: " + descriptor);
        }
        TypeData[] types = this.stackTypes;
        int index = this.stackTop;
        switch (descriptor.charAt(top)) {
            case '[': {
                types[index] = new TypeData.ClassName(descriptor.substring(top));
                break;
            }
            case 'L': {
                types[index] = new TypeData.ClassName(Tracer.getFieldClassName(descriptor, top));
                break;
            }
            case 'J': {
                types[index] = TypeTag.LONG;
                types[index + 1] = TypeTag.TOP;
                this.stackTop += 2;
                return;
            }
            case 'F': {
                types[index] = TypeTag.FLOAT;
                break;
            }
            case 'D': {
                types[index] = TypeTag.DOUBLE;
                types[index + 1] = TypeTag.TOP;
                this.stackTop += 2;
                return;
            }
            case 'V': {
                return;
            }
            default: {
                types[index] = TypeTag.INTEGER;
            }
        }
        ++this.stackTop;
    }

    private static String getFieldClassName(String desc, int index) {
        return desc.substring(index + 1, desc.length() - 1).replace('/', '.');
    }

    private void checkParamTypes(String desc, int i) throws BadBytecode {
        char c = desc.charAt(i);
        if (c == ')') {
            return;
        }
        int k = i;
        boolean array = false;
        while (c == '[') {
            array = true;
            c = desc.charAt(++k);
        }
        if (c == 'L') {
            if ((k = desc.indexOf(59, k) + 1) <= 0) {
                throw new IndexOutOfBoundsException("bad descriptor");
            }
        } else {
            ++k;
        }
        this.checkParamTypes(desc, k);
        this.stackTop = !(array || c != 'J' && c != 'D') ? (this.stackTop -= 2) : --this.stackTop;
        if (array) {
            TypeData.setType(this.stackTypes[this.stackTop], desc.substring(i, k), this.classPool);
        } else if (c == 'L') {
            TypeData.setType(this.stackTypes[this.stackTop], desc.substring(i + 1, k - 1).replace('/', '.'), this.classPool);
        }
    }
}

