/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.util.ConnectionDialog;

public class Transfer
extends Applet
implements WindowListener,
ActionListener,
ItemListener {
    Connection cSource;
    Connection cTarget;
    DatabaseMetaData dSourceMeta;
    DatabaseMetaData dTargetMeta;
    Statement sSourceStatement;
    Statement sTargetStatement;
    Frame fMain;
    Image imgEmpty;
    Table tCurrent;
    int iMaxRows;
    Vector tTable;
    List lTable;
    TextField tSourceTable;
    TextField tDestTable;
    TextField tDestDrop;
    TextField tDestCreate;
    TextField tDestDelete;
    TextField tSourceSelect;
    TextField tDestInsert;
    Checkbox cTransfer;
    Checkbox cDrop;
    Checkbox cCreate;
    Checkbox cDelete;
    Checkbox cInsert;
    Button bStart;
    Hashtable hTypes;
    TextField tMessage;
    static boolean bMustExit;
    String sLast;

    public void init() {
        Transfer m = new Transfer();
        m.main();
    }

    public static void work() {
        Transfer m = new Transfer();
        m.main();
    }

    public static void main(String[] arg) {
        bMustExit = true;
        Transfer.work();
    }

    void main() {
        this.fMain = new Frame("Hypersonic Transfer Tool");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        ((Component)this.fMain).setSize(640, 480);
        this.fMain.add("Center", this);
        MenuBar bar = new MenuBar();
        String[] extras = new String[]{"Insert 10 rows only", "Insert 1000 rows only", "Insert all rows"};
        Menu menu = new Menu("Options");
        this.addMenuItems(menu, extras);
        bar.add(menu);
        this.fMain.setMenuBar(bar);
        this.initGUI();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.fMain.getSize();
        ((Component)this.fMain).setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        ((Component)this.fMain).setVisible(true);
        this.cSource = ConnectionDialog.createConnection(this.fMain, "Source Database");
        if (this.cSource == null) {
            return;
        }
        try {
            this.dSourceMeta = this.cSource.getMetaData();
            this.sSourceStatement = this.cSource.createStatement();
        }
        catch (Exception e) {
            this.trace(e.toString());
            e.printStackTrace();
        }
        this.cTarget = ConnectionDialog.createConnection(this.fMain, "Target Database");
        if (this.cTarget == null) {
            return;
        }
        try {
            this.dTargetMeta = this.cTarget.getMetaData();
            this.sTargetStatement = this.cTarget.createStatement();
        }
        catch (Exception e) {
            this.trace(e.toString());
            e.printStackTrace();
        }
        String[] usertables = new String[]{"TABLE"};
        this.lTable.removeAll();
        this.tTable = new Vector();
        try {
            this.hTypes = new Hashtable();
            this.trace("Building target type info");
            ResultSet result = this.dTargetMeta.getTypeInfo();
            while (result.next()) {
                this.hTypes.put(new Integer(result.getShort(2)), result.getString(1));
            }
            result.close();
            this.trace("Reading source tables");
            result = this.dSourceMeta.getTables(null, null, null, usertables);
            int index = 0;
            while (result.next()) {
                Table t = new Table();
                t.iTableIndex = index++;
                String name = result.getString(3);
                t.bTransfer = true;
                t.sSourceTable = name;
                t.sDestTable = name;
                t.sDestDrop = "DROP TABLE " + name;
                t.sSourceSelect = "SELECT * FROM " + name;
                t.sDestDelete = "DELETE FROM " + name;
                t.bCreate = true;
                t.bDelete = true;
                t.bDrop = true;
                t.bInsert = true;
                this.tTable.addElement(t);
                this.lTable.add(name);
            }
            result.close();
            int i = 0;
            while (i < this.tTable.size()) {
                Table t = (Table)this.tTable.elementAt(i);
                this.trace("Reading source columns for table " + t.sSourceTable);
                ResultSet col = this.dSourceMeta.getColumns(null, null, t.sSourceTable, null);
                String create = "CREATE TABLE " + t.sSourceTable + "(";
                String insert = "INSERT INTO " + t.sSourceTable + " VALUES(";
                Vector<Integer> v = new Vector<Integer>();
                while (col.next()) {
                    String name = col.getString(4);
                    int type = col.getShort(5);
                    String source = col.getString(6);
                    if (type == 11 && source.toUpperCase().equals("DATETIME")) {
                        this.trace("Converted DATETIME (type 11) to TIMESTAMP");
                        type = 93;
                    } else if (type == -9 && source.toUpperCase().equals("NVARCHAR")) {
                        this.trace("Converted NVARCHAR (type -9) to VARCHAR");
                        type = 12;
                    } else if (type == -8 && source.toUpperCase().equals("NCHAR")) {
                        this.trace("Converted NCHAR (type -8) to VARCHAR");
                        type = 12;
                    } else if (type == -10 && source.toUpperCase().equals("NTEXT")) {
                        this.trace("Converted NTEXT (type -10) to VARCHAR");
                        type = 12;
                    } else if (type == -1 && source.toUpperCase().equals("LONGTEXT")) {
                        this.trace("Converted LONGTEXT (type -1) to LONGVARCHAR");
                        type = -1;
                    }
                    Integer inttype = new Integer(type);
                    String datatype = (String)this.hTypes.get(inttype);
                    if (datatype == null) {
                        datatype = source;
                        this.trace("No mapping for type: " + inttype + " source type is " + datatype);
                    }
                    v.addElement(inttype);
                    create = create + name + " " + datatype + ",";
                    insert = insert + "?,";
                }
                col.close();
                create = create.substring(0, create.length() - 1) + ")";
                insert = insert.substring(0, insert.length() - 1) + ")";
                t.sDestCreate = create;
                t.sDestInsert = insert;
                t.iColumnType = new int[v.size()];
                int j = 0;
                while (j < v.size()) {
                    t.iColumnType[j] = (Integer)v.elementAt(j);
                    ++j;
                }
                ++i;
            }
            this.trace("Edit definitions and press [Start Transfer]");
        }
        catch (SQLException e) {
            this.trace("SQL Exception reading Metadata: " + e.getMessage());
            e.printStackTrace();
        }
        this.fMain.show();
    }

    void addMenuItems(Menu f, String[] m) {
        int i = 0;
        while (i < m.length) {
            MenuItem item = new MenuItem(m[i]);
            item.addActionListener(this);
            f.add(item);
            ++i;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable item = e.getItemSelectable();
        if (item == this.lTable) {
            String table = this.lTable.getSelectedItem();
            int i = 0;
            while (i < this.tTable.size()) {
                Table t = (Table)this.tTable.elementAt(i);
                if (t != null && t.sSourceTable.equals(table)) {
                    this.saveTable();
                    this.displayTable(t);
                    this.updateEnabled(true);
                }
                ++i;
            }
        } else {
            this.updateEnabled(true);
        }
    }

    void saveTable() {
        if (this.tCurrent == null) {
            return;
        }
        Table t = this.tCurrent;
        t.sSourceTable = this.tSourceTable.getText();
        t.sDestTable = this.tDestTable.getText();
        t.sDestDrop = this.tDestDrop.getText();
        t.sDestCreate = this.tDestCreate.getText();
        t.sDestDelete = this.tDestDelete.getText();
        t.sSourceSelect = this.tSourceSelect.getText();
        t.sDestInsert = this.tDestInsert.getText();
        t.bTransfer = this.cTransfer.getState();
        t.bDrop = this.cDrop.getState();
        t.bCreate = this.cCreate.getState();
        t.bDelete = this.cDelete.getState();
        t.bInsert = this.cInsert.getState();
    }

    void displayTable(Table t) {
        this.tCurrent = t;
        if (t == null) {
            return;
        }
        this.tSourceTable.setText(t.sSourceTable);
        this.tDestTable.setText(t.sDestTable);
        this.tDestDrop.setText(t.sDestDrop);
        this.tDestCreate.setText(t.sDestCreate);
        this.tDestDelete.setText(t.sDestDelete);
        this.tSourceSelect.setText(t.sSourceSelect);
        this.tDestInsert.setText(t.sDestInsert);
        this.cTransfer.setState(t.bTransfer);
        this.cDrop.setState(t.bDrop);
        this.cCreate.setState(t.bCreate);
        this.cDelete.setState(t.bDelete);
        this.cInsert.setState(t.bInsert);
    }

    void updateEnabled(boolean and) {
        boolean b = this.cTransfer.getState();
        this.tDestTable.setEnabled(and && b);
        this.tDestDrop.setEnabled(and && b && this.cDrop.getState());
        this.tDestCreate.setEnabled(and && b && this.cCreate.getState());
        this.tDestDelete.setEnabled(and && b && this.cDelete.getState());
        this.tSourceSelect.setEnabled(and && b);
        this.tDestInsert.setEnabled(and && b && this.cInsert.getState());
        this.cDrop.setEnabled(and && b);
        this.cCreate.setEnabled(and && b);
        this.cDelete.setEnabled(and && b);
        this.cInsert.setEnabled(and && b);
        this.bStart.setEnabled(and);
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s == null && ev.getSource() instanceof MenuItem) {
            s = ((MenuItem)ev.getSource()).getLabel();
        }
        if (s.equals("Start Transfer")) {
            this.transfer();
        } else if (s.equals("Insert 10 rows only")) {
            this.iMaxRows = 10;
        } else if (s.equals("Insert 1000 rows only")) {
            this.iMaxRows = 1000;
        } else if (s.equals("Insert all rows")) {
            this.iMaxRows = 0;
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent ev) {
        try {
            if (this.cSource != null) {
                this.cSource.close();
            }
            if (this.cTarget != null) {
                this.cTarget.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    void initGUI() {
        Font fFont = new Font("Dialog", 0, 12);
        this.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.setBackground(SystemColor.control);
        p.setLayout(new GridLayout(16, 1));
        this.tSourceTable = new TextField();
        this.tSourceTable.setEnabled(false);
        this.tDestTable = new TextField();
        this.tDestDrop = new TextField();
        this.tDestCreate = new TextField();
        this.tDestDelete = new TextField();
        this.tSourceSelect = new TextField();
        this.tDestInsert = new TextField();
        this.cTransfer = new Checkbox("Transfer to destination table", true);
        this.cTransfer.addItemListener(this);
        this.cDrop = new Checkbox("Drop destination table (ignore error)", true);
        this.cDrop.addItemListener(this);
        this.cCreate = new Checkbox("Create destination table", true);
        this.cCreate.addItemListener(this);
        this.cDelete = new Checkbox("Delete rows in destination table", true);
        this.cDelete.addItemListener(this);
        this.cInsert = new Checkbox("Insert into destination", true);
        this.cInsert.addItemListener(this);
        p.add(this.createLabel("Source table"));
        p.add(this.tSourceTable);
        p.add(this.cTransfer);
        p.add(this.tDestTable);
        p.add(this.cDrop);
        p.add(this.tDestDrop);
        p.add(this.cCreate);
        p.add(this.tDestCreate);
        p.add(this.cDelete);
        p.add(this.tDestDelete);
        p.add(this.createLabel("Select source records"));
        p.add(this.tSourceSelect);
        p.add(this.cInsert);
        p.add(this.tDestInsert);
        p.add(this.createLabel(""));
        this.bStart = new Button("Start Transfer");
        this.bStart.addActionListener(this);
        p.add(this.bStart);
        this.fMain.add("Center", this.createBorderPanel(p));
        this.lTable = new List(10);
        this.lTable.addItemListener(this);
        this.fMain.add("West", this.createBorderPanel(this.lTable));
        this.tMessage = new TextField();
        Panel pMessage = this.createBorderPanel(this.tMessage);
        this.fMain.add("South", pMessage);
    }

    Panel createBorderPanel(Component center) {
        Panel p = new Panel();
        p.setBackground(SystemColor.control);
        p.setLayout(new BorderLayout());
        p.add("Center", center);
        p.add("South", this.createLabel(""));
        p.add("East", this.createLabel(""));
        p.add("West", this.createLabel(""));
        p.setBackground(SystemColor.control);
        return p;
    }

    Label createLabel(String s) {
        Label l = new Label(s);
        l.setBackground(SystemColor.control);
        return l;
    }

    void trace(String s) {
        this.tMessage.setText(s);
        System.out.println(s);
    }

    void transfer() {
        this.saveTable();
        this.updateEnabled(false);
        this.trace("Start Transfer");
        try {
            int i = 0;
            while (i < this.tTable.size()) {
                this.transfer((Table)this.tTable.elementAt(i));
                ++i;
            }
            this.trace("Transfer finished successfully");
        }
        catch (SQLException e) {
            String last = this.tMessage.getText();
            this.trace("Transfer stopped - " + last + " / " + this.sLast + " / Error: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            String last = this.tMessage.getText();
            this.trace("Transfer stopped - " + last + " / " + this.sLast + " / Error: " + e.getMessage());
            e.printStackTrace();
        }
        this.updateEnabled(true);
    }

    void transfer(Table t) throws SQLException {
        this.lTable.select(t.iTableIndex);
        this.displayTable(t);
        if (!t.bTransfer) {
            this.trace("Table " + t.sSourceSelect + " not transfered");
            return;
        }
        this.trace("Table " + t.sSourceSelect + ": start transfer");
        if (t.bDelete) {
            try {
                this.trace("Executing " + t.sDestDrop);
                this.sTargetStatement.execute(t.sDestDrop);
            }
            catch (SQLException e) {
                this.trace("Ignoring error " + e.getMessage());
            }
        }
        if (t.bCreate) {
            this.trace("Executing " + t.sDestCreate);
            this.sTargetStatement.execute(t.sDestCreate);
        }
        if (t.bDelete) {
            this.trace("Executing " + t.sDestDelete);
            this.sTargetStatement.execute(t.sDestDelete);
        }
        if (t.bInsert) {
            this.trace("Executing " + t.sDestInsert);
            PreparedStatement p = this.cTarget.prepareStatement(t.sDestInsert);
            this.trace("Executing " + t.sSourceSelect);
            ResultSet r = this.sSourceStatement.executeQuery(t.sSourceSelect);
            int i = 0;
            ResultSetMetaData m = r.getMetaData();
            int[] type = new int[m.getColumnCount()];
            int j = 0;
            while (j < m.getColumnCount()) {
                type[j] = m.getColumnType(j + 1);
                ++j;
            }
            this.trace("Start transfering data...");
            while (r.next()) {
                this.transferRow(type, r, p);
                if (this.iMaxRows != 0 && i == this.iMaxRows) break;
                if (this.iMaxRows == 0 && ++i % 100 != 0) continue;
                this.trace("Transfered " + i + " rows");
            }
            this.trace("Finished");
        }
    }

    void transferRow(int[] type, ResultSet r, PreparedStatement p) throws SQLException {
        this.sLast = null;
        p.clearParameters();
        int len = type.length;
        int i = 0;
        while (i < len) {
            int t = type[i];
            this.sLast = "column=" + (i + 1) + " datatype=" + t;
            Object o = r.getObject(i + 1);
            if (o == null) {
                this.sLast = this.sLast + " value=" + o;
                p.setNull(i + 1, type[i]);
            } else {
                if (t == 5 && o instanceof Integer) {
                    this.sLast = this.sLast + " SMALLINT: Converted Integer to Short";
                    o = new Short((short)((Integer)o).intValue());
                } else if (t == -6 && o instanceof Integer) {
                    this.sLast = this.sLast + " TINYINT: Converted Integer to Byte";
                    o = new Byte((byte)((Integer)o).intValue());
                }
                this.sLast = this.sLast + " value=" + o;
                p.setObject(i + 1, o, type[i]);
            }
            ++i;
        }
        p.execute();
        this.sLast = null;
    }

    class Table {
        int iTableIndex;
        String sSourceTable;
        String sDestTable;
        String sDestDrop;
        String sDestCreate;
        String sDestDelete;
        String sSourceSelect;
        String sDestInsert;
        boolean bTransfer;
        boolean bDrop;
        boolean bCreate;
        boolean bDelete;
        boolean bInsert;
        int[] iColumnType;

        Table() {
        }
    }
}

