/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.velocity;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.servlet.VelocityServlet;
import webwork.action.ServletActionContext;
import webwork.config.Configuration;
import webwork.util.ServletValueStack;
import webwork.view.velocity.WebWorkUtil;

public class WebWorkVelocityServlet
extends VelocityServlet {
    static final String CONTEXT = "velocity_context";
    static final String WEBWORK_UTIL = "webwork";
    ThreadLocal request = new ThreadLocal();
    ThreadLocal response = new ThreadLocal();
    protected Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void service(ServletRequest aRequest, ServletResponse aResponse) throws ServletException, IOException {
        long start = 0L;
        if (this.log.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        super.service(aRequest, aResponse);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Time:" + (System.currentTimeMillis() - start)));
        }
    }

    protected Properties loadConfiguration(ServletConfig config) throws IOException, FileNotFoundException {
        String path;
        this.log.debug((Object)">>> loadConfiguration <<<<<");
        final Properties conf = new Properties(){

            public Object get(Object key) {
                return Configuration.get(key.toString());
            }

            public String getProperty(String key) {
                return Configuration.getString(key.toString());
            }

            public Enumeration keys() {
                Iterator list = Configuration.list();
                return new Enumeration(this, list){
                    private final /* synthetic */ Iterator val$list;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$list = val$list;
                    }

                    public Object nextElement() {
                        return this.val$list.next();
                    }

                    public boolean hasMoreElements() {
                        return this.val$list.hasNext();
                    }
                };
            }
        };
        Properties p = new Properties(conf){

            public Enumeration keys() {
                return conf.keys();
            }
        };
        String log = p.getProperty("runtime.log");
        if (log != null && (log = this.getServletContext().getRealPath(log)) != null) {
            p.setProperty("runtime.log", log);
        }
        if ((path = p.getProperty("file.resource.loader.path")) != null && (path.equals("/") || !path.startsWith("/")) && (path = this.getServletContext().getRealPath(path)) != null) {
            p.setProperty("file.resource.loader.path", path);
        }
        return p;
    }

    protected Context createContext(HttpServletRequest request, HttpServletResponse response) {
        WebWorkVelocityContext ctx = new WebWorkVelocityContext(ServletValueStack.getStack((ServletRequest)request));
        ctx.put("req", request);
        ctx.put("res", response);
        return ctx;
    }

    protected Template handleRequest(HttpServletRequest aRequest, HttpServletResponse aResponse, Context ctx) throws Exception {
        ServletActionContext.setContext(aRequest, aResponse, this.getServletContext(), null);
        ctx.put(WEBWORK_UTIL, (Object)new WebWorkUtil(ctx));
        String servletPath = (String)aRequest.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = aRequest.getServletPath();
        }
        return this.getTemplate(servletPath);
    }

    static class WebWorkVelocityContext
    extends VelocityContext {
        ServletValueStack stack;

        WebWorkVelocityContext(ServletValueStack aStack) {
            this.stack = aStack;
        }

        public boolean internalContainsKey(Object key) {
            boolean contains = super.internalContainsKey(key);
            return contains ? true : this.stack.test(key.toString());
        }

        public Object internalGet(String key) {
            return super.internalContainsKey((Object)key) ? super.internalGet(key) : this.stack.findValue(key);
        }
    }
}

