/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.joinpoint.plugins.config.Config;
import org.jboss.joinpoint.spi.ConstructorJoinpoint;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

public class Configurator
extends Config {
    public static Object instantiateAndConfigure(KernelConfig config, BeanInfo info, BeanMetaData metaData) throws Throwable {
        Object result = Configurator.instantiate(config, info, metaData);
        if (metaData != null) {
            Configurator.configure(result, info, metaData);
        }
        return result;
    }

    public static Object instantiate(KernelConfig config, BeanInfo info, BeanMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Instantiating info=" + info + " metaData=" + metaData));
        }
        ConstructorMetaData constructor = null;
        if (metaData != null) {
            constructor = metaData.getConstructor();
        }
        Joinpoint joinPoint = Configurator.getConstructorJoinPoint(config, info, constructor, metaData);
        return joinPoint.dispatch();
    }

    public static Joinpoint getConstructorJoinPoint(KernelConfig config, BeanInfo info, ConstructorMetaData metaData, BeanMetaData beanMetaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Get constructor joinpoint info=" + info + " constructor=" + metaData));
        }
        if (config == null) {
            throw new IllegalArgumentException("Null config");
        }
        if (metaData != null) {
            ClassLoader cl = Configurator.getClassLoader(beanMetaData);
            ValueMetaData vmd = metaData.getFactory();
            if (vmd != null) {
                Object factory = vmd.getValue(null, cl);
                List parameters = metaData.getParameters();
                BeanInfo factoryInfo = config.getBeanInfo(factory.getClass());
                MethodJoinpoint joinPoint = Configurator.findMethod(trace, factoryInfo, cl, metaData.getFactoryMethod(), parameters, false, true);
                joinPoint.setTarget(factory);
                MethodInfo minfo = joinPoint.getMethodInfo();
                if (minfo != null) {
                    TypeInfo[] pinfos = minfo.getParameterTypes();
                    Object[] params = Configurator.getParameters(trace, cl, pinfos, parameters);
                    joinPoint.setArguments(params);
                }
                return joinPoint;
            }
            String factoryClassName = metaData.getFactoryClass();
            if (factoryClassName != null) {
                List parameters = metaData.getParameters();
                BeanInfo factoryInfo = config.getBeanInfo(factoryClassName, cl);
                MethodJoinpoint joinPoint = Configurator.findMethod(trace, factoryInfo, cl, metaData.getFactoryMethod(), parameters, true, true);
                MethodInfo minfo = joinPoint.getMethodInfo();
                if (minfo != null) {
                    TypeInfo[] pinfos = minfo.getParameterTypes();
                    Object[] params = Configurator.getParameters(trace, cl, pinfos, parameters);
                    joinPoint.setArguments(params);
                }
                return joinPoint;
            }
            ConstructorJoinpoint joinPoint = Configurator.findConstructor(trace, info, metaData, beanMetaData);
            ConstructorInfo cinfo = joinPoint.getConstructorInfo();
            if (cinfo != null) {
                TypeInfo[] pinfos = cinfo.getParameterTypes();
                Object[] params = Configurator.getParameters(trace, cl, pinfos, metaData.getParameters());
                joinPoint.setArguments(params);
            }
            return joinPoint;
        }
        return Configurator.findConstructor(trace, info, metaData, beanMetaData);
    }

    public static ConstructorJoinpoint findConstructor(boolean trace, BeanInfo info, ConstructorMetaData metaData, BeanMetaData beanMetaData) throws Exception {
        ConstructorInfo cinfo = Configurator.resolveConstructor(trace, info, metaData);
        JoinpointFactory jpf = info.getJoinpointFactory();
        return jpf.getConstructorJoinpoint(cinfo);
    }

    public static ConstructorInfo resolveConstructor(boolean trace, BeanInfo info, ConstructorMetaData metaData) {
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        List params = Collections.EMPTY_LIST;
        if (metaData != null && metaData.getParameters() != null) {
            params = metaData.getParameters();
        }
        String[] paramTypes = new String[params.size()];
        if (!params.isEmpty()) {
            int x = 0;
            Iterator i = params.iterator();
            while (i.hasNext()) {
                ParameterMetaData pdata = (ParameterMetaData)i.next();
                paramTypes[x++] = pdata.getType();
            }
        }
        return Configurator.findConstructorInfo((ClassInfo)info.getClassInfo(), (String[])paramTypes);
    }

    public static void configure(Object object, BeanInfo info, BeanMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (object == null) {
            throw new IllegalArgumentException("Null object");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null bean metadata");
        }
        Set properties = metaData.getProperties();
        if (properties != null && !properties.isEmpty()) {
            ClassLoader cl = Configurator.getClassLoader(metaData);
            Iterator i = metaData.getProperties().iterator();
            while (i.hasNext()) {
                PropertyMetaData property = (PropertyMetaData)i.next();
                Configurator.configure(trace, object, info, cl, property);
            }
        }
    }

    public static void configure(Object object, BeanInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        Configurator.configure(trace, object, info, cl, metaData);
    }

    public static void configure(boolean trace, Object object, BeanInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        PropertyInfo ainfo = Configurator.resolveProperty(trace, info, metaData.getName());
        Configurator.configure(trace, object, ainfo, cl, metaData);
    }

    public static void configure(Object object, PropertyInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        Configurator.configure(trace, object, info, cl, metaData);
    }

    public static void configure(boolean trace, Object object, PropertyInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        if (trace) {
            log.trace((Object)("Configuring info=" + info + " metaData=" + metaData));
        }
        TargettedJoinpoint joinPoint = Configurator.getPropertySetterJoinPoint(trace, info, cl, metaData.getValue());
        joinPoint.setTarget(object);
        if (trace) {
            log.trace((Object)("Setting property " + joinPoint));
        }
        joinPoint.dispatch();
    }

    public static TargettedJoinpoint getPropertyGetterJoinPoint(BeanInfo info, String property) throws Throwable {
        boolean trace = log.isTraceEnabled();
        PropertyInfo ainfo = Configurator.resolveProperty(trace, info, property);
        return Configurator.getPropertyGetterJoinPoint(trace, ainfo);
    }

    public static TargettedJoinpoint getPropertyGetterJoinPoint(boolean trace, PropertyInfo info) throws Throwable {
        if (trace) {
            log.trace((Object)("Get property setter join point info=" + info));
        }
        if (info == null) {
            throw new IllegalArgumentException("Null property info");
        }
        JoinpointFactory jpf = info.getBeanInfo().getJoinpointFactory();
        MethodInfo minfo = info.getGetter();
        return Configurator.getMethodJoinpoint(null, (JoinpointFactory)jpf, (String)minfo.getName(), null, null);
    }

    public static Set getPropertySetterJoinPoints(BeanInfo info, BeanMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null bean metadata");
        }
        HashSet<TargettedJoinpoint> result = new HashSet<TargettedJoinpoint>();
        Set propertys = metaData.getProperties();
        if (propertys != null && !propertys.isEmpty()) {
            ClassLoader cl = Configurator.getClassLoader(metaData);
            Iterator i = metaData.getProperties().iterator();
            while (i.hasNext()) {
                PropertyMetaData property = (PropertyMetaData)i.next();
                TargettedJoinpoint joinPoint = Configurator.getPropertySetterJoinPoint(trace, info, cl, property);
                result.add(joinPoint);
            }
        }
        return result;
    }

    public static TargettedJoinpoint getPropertySetterJoinPoint(BeanInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        return Configurator.getPropertySetterJoinPoint(trace, info, cl, metaData);
    }

    public static TargettedJoinpoint getPropertySetterJoinPoint(boolean trace, BeanInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        PropertyInfo ainfo = Configurator.resolveProperty(trace, info, metaData.getName());
        return Configurator.getPropertySetterJoinPoint(trace, ainfo, cl, metaData.getValue());
    }

    public static TargettedJoinpoint getPropertySetterJoinPoint(PropertyInfo info, ClassLoader cl, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        return Configurator.getPropertySetterJoinPoint(trace, info, cl, metaData.getValue());
    }

    public static TargettedJoinpoint getPropertySetterJoinPoint(BeanInfo info, String property, ClassLoader cl, ValueMetaData vmd) throws Throwable {
        boolean trace = log.isTraceEnabled();
        PropertyInfo ainfo = Configurator.resolveProperty(trace, info, property);
        return Configurator.getPropertySetterJoinPoint(trace, ainfo, cl, vmd);
    }

    public static TargettedJoinpoint getPropertySetterJoinPoint(boolean trace, PropertyInfo info, ClassLoader cl, ValueMetaData metaData) throws Throwable {
        if (trace) {
            log.trace((Object)("Get property setter join point info=" + info + " metaData=" + metaData));
        }
        if (info == null) {
            throw new IllegalArgumentException("Null property info");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null value metadata");
        }
        TypeInfo type = info.getType();
        Object value = metaData.getValue(type, cl);
        JoinpointFactory jpf = info.getBeanInfo().getJoinpointFactory();
        MethodInfo minfo = info.getSetter();
        if (minfo == null) {
            throw new IllegalArgumentException("No setter configured for property: " + info);
        }
        String[] parameterTypes = Configurator.getParameterTypes(trace, minfo.getParameterTypes());
        return Configurator.getMethodJoinpoint(null, (JoinpointFactory)jpf, (String)minfo.getName(), (String[])parameterTypes, (Object[])new Object[]{value});
    }

    public static void unconfigure(Object object, BeanInfo info, BeanMetaData metaData) throws Throwable {
        if (object == null) {
            throw new IllegalArgumentException("Null object");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null bean metadata");
        }
        Set propertys = metaData.getProperties();
        if (propertys != null && !propertys.isEmpty()) {
            Iterator i = metaData.getProperties().iterator();
            while (i.hasNext()) {
                PropertyMetaData property = (PropertyMetaData)i.next();
                Configurator.unconfigure(object, info, property);
            }
        }
    }

    public static void unconfigure(Object object, BeanInfo info, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        PropertyInfo ainfo = Configurator.resolveProperty(trace, info, metaData.getName());
        Configurator.unconfigure(trace, object, ainfo, metaData);
    }

    public static void unconfigure(boolean trace, Object object, PropertyInfo info, PropertyMetaData metaData) throws Throwable {
        if (trace) {
            log.trace((Object)("Unconfiguring info=" + info + " metaData=" + metaData));
        }
        TargettedJoinpoint joinPoint = Configurator.getPropertyNullerJoinPoint(info, metaData);
        joinPoint.setTarget(object);
        if (trace) {
            log.trace((Object)("Unsetting property " + joinPoint));
        }
        joinPoint.dispatch();
    }

    public static Set getPropertyNullerJoinPoints(BeanInfo info, BeanMetaData metaData) throws Throwable {
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (metaData == null) {
            throw new IllegalArgumentException("Null bean metadata");
        }
        HashSet<TargettedJoinpoint> result = new HashSet<TargettedJoinpoint>();
        Set propertys = metaData.getProperties();
        if (propertys != null && !propertys.isEmpty()) {
            Iterator i = metaData.getProperties().iterator();
            while (i.hasNext()) {
                PropertyMetaData property = (PropertyMetaData)i.next();
                TargettedJoinpoint joinPoint = Configurator.getPropertyNullerJoinPoint(info, property);
                result.add(joinPoint);
            }
        }
        return result;
    }

    public static TargettedJoinpoint getPropertyNullerJoinPoint(BeanInfo info, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        PropertyInfo ainfo = Configurator.resolveProperty(trace, info, metaData.getName());
        return Configurator.getPropertyNullerJoinPoint(ainfo, metaData);
    }

    public static TargettedJoinpoint getPropertyNullerJoinPoint(PropertyInfo info, PropertyMetaData metaData) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Get property nuller join point info=" + info + " metaData=" + metaData));
        }
        if (info == null) {
            throw new IllegalArgumentException("Null property info");
        }
        JoinpointFactory jpf = info.getBeanInfo().getJoinpointFactory();
        MethodInfo minfo = info.getSetter();
        String[] parameterTypes = Configurator.getParameterTypes(trace, minfo.getParameterTypes());
        return Configurator.getMethodJoinpoint(null, (JoinpointFactory)jpf, (String)minfo.getName(), (String[])parameterTypes, (Object[])new Object[]{null});
    }

    public static PropertyInfo resolveProperty(boolean trace, BeanInfo info, String name) throws Throwable {
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        Set properties = info.getProperties();
        if (properties != null && properties.size() > 0) {
            Iterator i = properties.iterator();
            while (i.hasNext()) {
                PropertyInfo ainfo = (PropertyInfo)i.next();
                if (!name.equals(ainfo.getName())) continue;
                return ainfo;
            }
        }
        throw new JoinpointException("Property " + name + " not found for " + info);
    }

    public static MethodJoinpoint findMethod(BeanInfo info, ClassLoader cl, String name, List parameters, boolean isStatic, boolean isPublic) throws Throwable {
        boolean trace = log.isTraceEnabled();
        return Configurator.findMethod(trace, info, cl, name, parameters, isStatic, isPublic);
    }

    public static MethodJoinpoint findMethod(boolean trace, BeanInfo info, ClassLoader cl, String name, List parameters, boolean isStatic, boolean isPublic) throws Throwable {
        if (info == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        String[] paramTypes = Configurator.getParameterTypes(trace, parameters);
        MethodInfo minfo = Configurator.findMethodInfo((ClassInfo)info.getClassInfo(), (String)name, (String[])paramTypes);
        JoinpointFactory jpf = info.getJoinpointFactory();
        MethodJoinpoint joinPoint = jpf.getMethodJoinpoint(minfo);
        if (minfo != null) {
            TypeInfo[] pinfos = minfo.getParameterTypes();
            Object[] params = Configurator.getParameters(trace, cl, pinfos, parameters);
            joinPoint.setArguments(params);
        }
        return joinPoint;
    }

    public static String[] getParameterTypes(boolean trace, List parameters) throws Throwable {
        if (parameters == null) {
            return null;
        }
        String[] paramTypes = new String[parameters.size()];
        int x = 0;
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            ParameterMetaData pmd = (ParameterMetaData)i.next();
            paramTypes[x++] = pmd.getType();
        }
        return paramTypes;
    }

    public static String[] getParameterTypes(boolean trace, TypeInfo[] parameters) throws Throwable {
        if (parameters == null) {
            return null;
        }
        String[] paramTypes = new String[parameters.length];
        int x = 0;
        for (int i = 0; i < parameters.length; ++i) {
            paramTypes[x++] = parameters[i].getName();
        }
        return paramTypes;
    }

    public static Object[] getParameters(boolean trace, ClassLoader cl, TypeInfo[] pinfos, List parameters) throws Throwable {
        if (parameters == null) {
            return null;
        }
        Object[] params = new Object[parameters.size()];
        int x = 0;
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            ParameterMetaData pdata = (ParameterMetaData)i.next();
            ValueMetaData vmd = pdata.getValue();
            Object param = vmd.getValue(pinfos[x], cl);
            params[x++] = param;
        }
        return params;
    }

    public static ClassLoader getClassLoader(BeanMetaData metaData) throws Throwable {
        ClassLoaderMetaData clmd = null;
        if (metaData != null) {
            clmd = metaData.getClassLoader();
        }
        return Configurator.getClassLoader(clmd);
    }

    public static ClassLoader getClassLoader(ClassLoaderMetaData metaData) throws Throwable {
        ValueMetaData clVMD;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        ClassLoader cl = null;
        if (metaData != null && (clVMD = metaData.getClassLoader()) != null) {
            Object object = clVMD.getValue(null, tcl);
            if (object != null && !(object instanceof ClassLoader)) {
                throw new IllegalArgumentException("Configured object is not a classloader " + metaData);
            }
            cl = (ClassLoader)object;
        }
        if (cl == null) {
            cl = tcl;
        }
        return cl;
    }
}

