/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools;

import cirrus.hibernate.Datastore;
import cirrus.hibernate.Hibernate;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.connection.ConnectionProvider;
import cirrus.hibernate.connection.ConnectionProviderFactory;
import cirrus.hibernate.sql.Dialect;
import cirrus.hibernate.tools.updater.JdbcDatabaseInfo;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchemaUpdater {
    Log log = LogFactory.getLog(this.getClass());
    private ConnectionProvider cp;
    Datastore store;

    public SchemaUpdater(Datastore store) throws HibernateException, SQLException {
        this.store = store;
        this.cp = ConnectionProviderFactory.newConnectionProvider();
    }

    public SchemaUpdater(Datastore store, Properties connectionProperties) throws HibernateException {
        this.store = store;
        this.cp = ConnectionProviderFactory.newConnectionProvider(connectionProperties);
    }

    public static void main(String[] args) {
        block9: {
            try {
                Datastore ds = Hibernate.createDatastore();
                boolean script = true;
                String propFile = null;
                int i = 0;
                while (i < args.length) {
                    if (args[i].startsWith("--")) {
                        if (args[i].equals("--quiet")) {
                            script = false;
                        } else if (args[i].startsWith("--properties=")) {
                            propFile = args[i].substring(13);
                        }
                    } else {
                        ds.storeFile(args[i]);
                    }
                    ++i;
                }
                if (propFile != null) {
                    Properties props = new Properties();
                    props.load(new FileInputStream(propFile));
                    new SchemaUpdater(ds, props).execute(script);
                    break block9;
                }
                new SchemaUpdater(ds).execute(script);
            }
            catch (Exception e) {
                System.err.println("Error updating schema " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void execute(boolean script) throws SQLException, HibernateException {
        Dialect dialect = Dialect.getDialect();
        Connection connection = this.cp.getConnection();
        JdbcDatabaseInfo info = new JdbcDatabaseInfo(connection, dialect);
        Statement stmt = connection.createStatement();
        boolean jdbc2 = false;
        String[] createSQL = this.store.generateSchemaUpdateScript(dialect, info);
        int j = 0;
        while (j < createSQL.length) {
            String sql = createSQL[j];
            try {
                if (script) {
                    System.out.println(createSQL[j]);
                }
                if (jdbc2) {
                    stmt.addBatch(sql);
                } else {
                    stmt.executeUpdate(sql);
                }
            }
            catch (SQLException e) {
                this.log.error((Object)("Error while executing " + sql), (Throwable)e);
            }
            ++j;
        }
        if (jdbc2) {
            stmt.executeBatch();
        }
        stmt.close();
        connection.close();
    }
}

