/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.tools;

import cirrus.hibernate.helpers.StringHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ProxyGenerator {
    private static Map primitiveArrays = new HashMap();
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$C;

    public static void main(String[] args) throws IOException {
        String outdir = ".";
        String suffix = "";
        String prefix = "";
        String pkg = null;
        String unsuffix = "Impl";
        ArrayList classesList = new ArrayList();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--output")) {
                outdir = args[++i];
            } else if (args[i].equals("--suffix")) {
                suffix = args[++i];
            } else if (args[i].equals("--package")) {
                pkg = args[++i];
            } else if (args[i].equals("--unsuffix")) {
                unsuffix = args[++i];
            } else if (args[i].equals("--prefix")) {
                prefix = args[++i];
            } else {
                try {
                    classesList.add(Class.forName(args[i]));
                }
                catch (ClassNotFoundException cnfe) {
                    System.err.println("Class not found: " + args[i]);
                    System.exit(1);
                }
            }
            ++i;
        }
        Class[] classes = classesList.toArray(new Class[classesList.size()]);
        Comparator c = new Comparator(){

            public int compare(Object x, Object y) {
                return ((Class)x).getName().compareTo(((Class)y).getName());
            }
        };
        Arrays.sort(classes, c);
        int i2 = 0;
        while (i2 < classes.length) {
            String className = ProxyGenerator.toProxyName(classes[i2].getName(), prefix, suffix, unsuffix);
            String path = outdir + '/' + classes[i2].getPackage().getName().replace('.', '/') + '/' + className + ".java";
            System.out.println("Writing proxy for " + classes[i2].getName() + " to " + path);
            File file = new File(path);
            file.getParentFile().mkdirs();
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.print("package ");
            out.print(classes[i2].getPackage().getName());
            if (pkg != null) {
                out.print('.');
                out.print(pkg);
            }
            out.println(';');
            out.println();
            out.print("public interface ");
            out.print(className);
            if (Arrays.binarySearch(classes, classes[i2].getSuperclass(), c) >= 0) {
                out.print(" extends ");
                String superclassName = ProxyGenerator.toProxyName(classes[i2].getSuperclass().getName(), prefix, suffix, unsuffix);
                out.print(superclassName);
            }
            out.println(" {");
            Method[] methods = classes[i2].getDeclaredMethods();
            int j = 0;
            while (j < methods.length) {
                if (Modifier.isPublic(methods[j].getModifiers())) {
                    out.print("\tpublic ");
                    String typeName = methods[j].getReturnType().getName();
                    out.print(ProxyGenerator.toJava(typeName));
                    out.print(' ');
                    out.print(methods[j].getName());
                    out.print('(');
                    Class<?>[] parameters = methods[j].getParameterTypes();
                    int k = 0;
                    while (k < parameters.length) {
                        typeName = parameters[k].getName();
                        out.print(ProxyGenerator.toJava(typeName));
                        out.print(" arg");
                        out.print(k);
                        if (k < parameters.length - 1) {
                            out.print(", ");
                        }
                        ++k;
                    }
                    out.print(')');
                    Class<?>[] exceptions = methods[j].getExceptionTypes();
                    if (exceptions.length > 0) {
                        out.print(" throws ");
                    }
                    int k2 = 0;
                    while (k2 < exceptions.length) {
                        typeName = exceptions[k2].getName();
                        out.print(ProxyGenerator.toJava(typeName));
                        if (k2 < exceptions.length - 1) {
                            out.print(", ");
                        }
                        ++k2;
                    }
                    out.println(';');
                }
                ++j;
            }
            out.println("}");
            out.flush();
            out.close();
            ++i2;
        }
    }

    private static String toJava(String typeName) {
        String arrayJava = (String)primitiveArrays.get(typeName);
        if (arrayJava != null) {
            return arrayJava;
        }
        int arrayDepth = typeName.lastIndexOf("[") + 1;
        if (arrayDepth > 0) {
            typeName = typeName.substring(arrayDepth + 1, typeName.length() - 1);
        }
        if (typeName.startsWith("java.lang.")) {
            typeName = typeName.substring(10);
        }
        while (--arrayDepth >= 0) {
            typeName = typeName + "[]";
        }
        typeName.replace('$', '.');
        return typeName;
    }

    private static String toProxyName(String className, String prefix, String suffix, String unsuffix) {
        String proxyName = StringHelper.unqualify(className);
        if (proxyName.indexOf(unsuffix) > 0) {
            proxyName = proxyName.substring(0, proxyName.length() - unsuffix.length());
        }
        proxyName = prefix + proxyName + suffix;
        return proxyName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveArrays.put((array$I == null ? (array$I = ProxyGenerator.class$("[I")) : array$I).getName(), "int[]");
        primitiveArrays.put((array$J == null ? (array$J = ProxyGenerator.class$("[J")) : array$J).getName(), "long[]");
        primitiveArrays.put((array$S == null ? (array$S = ProxyGenerator.class$("[S")) : array$S).getName(), "short[]");
        primitiveArrays.put((array$B == null ? (array$B = ProxyGenerator.class$("[B")) : array$B).getName(), "byte[]");
        primitiveArrays.put((array$F == null ? (array$F = ProxyGenerator.class$("[F")) : array$F).getName(), "float[]");
        primitiveArrays.put((array$D == null ? (array$D = ProxyGenerator.class$("[D")) : array$D).getName(), "double[]");
        primitiveArrays.put((array$Z == null ? (array$Z = ProxyGenerator.class$("[Z")) : array$Z).getName(), "boolean[]");
        primitiveArrays.put((array$C == null ? (array$C = ProxyGenerator.class$("[C")) : array$C).getName(), "char[]");
    }
}

