/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.test;

import cirrus.hibernate.Databinder;
import cirrus.hibernate.Environment;
import cirrus.hibernate.Hibernate;
import cirrus.hibernate.LazyInitializationException;
import cirrus.hibernate.LockMode;
import cirrus.hibernate.ObjectDeletedException;
import cirrus.hibernate.Query;
import cirrus.hibernate.ScrollableResults;
import cirrus.hibernate.Session;
import cirrus.hibernate.Transaction;
import cirrus.hibernate.connection.DriverManagerConnectionProvider;
import cirrus.hibernate.sql.DB2Dialect;
import cirrus.hibernate.sql.HSQLDialect;
import cirrus.hibernate.sql.InterbaseDialect;
import cirrus.hibernate.sql.MckoiDialect;
import cirrus.hibernate.sql.MySQLDialect;
import cirrus.hibernate.sql.OracleDialect;
import cirrus.hibernate.sql.PointbaseDialect;
import cirrus.hibernate.sql.PostgreSQLDialect;
import cirrus.hibernate.sql.SAPDBDialect;
import cirrus.hibernate.sql.SybaseDialect;
import cirrus.hibernate.test.Bar;
import cirrus.hibernate.test.BarProxy;
import cirrus.hibernate.test.Baz;
import cirrus.hibernate.test.Fee;
import cirrus.hibernate.test.Fo;
import cirrus.hibernate.test.Foo;
import cirrus.hibernate.test.FooComponent;
import cirrus.hibernate.test.FooProxy;
import cirrus.hibernate.test.FooStatus;
import cirrus.hibernate.test.Fum;
import cirrus.hibernate.test.FumCompositeID;
import cirrus.hibernate.test.Fumm;
import cirrus.hibernate.test.Glarch;
import cirrus.hibernate.test.GlarchProxy;
import cirrus.hibernate.test.Holder;
import cirrus.hibernate.test.Immutable;
import cirrus.hibernate.test.Location;
import cirrus.hibernate.test.Many;
import cirrus.hibernate.test.MoreStuff;
import cirrus.hibernate.test.Named;
import cirrus.hibernate.test.One;
import cirrus.hibernate.test.Qux;
import cirrus.hibernate.test.Stuff;
import cirrus.hibernate.test.TestCase;
import cirrus.hibernate.test.Trivial;
import cirrus.hibernate.test.Vetoer;
import cirrus.hibernate.type.DateType;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.StringType;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.commons.lang.SerializationUtils;

public class FooBarTest
extends TestCase {
    protected short fumKeyShort = 1;
    static /* synthetic */ Class class$cirrus$hibernate$test$Foo;
    static /* synthetic */ Class class$cirrus$hibernate$test$Baz;
    static /* synthetic */ Class class$cirrus$hibernate$test$Qux;
    static /* synthetic */ Class class$cirrus$hibernate$test$Fee;
    static /* synthetic */ Class class$cirrus$hibernate$test$Holder;
    static /* synthetic */ Class class$cirrus$hibernate$test$Bar;
    static /* synthetic */ Class class$cirrus$hibernate$test$Glarch;
    static /* synthetic */ Class class$cirrus$hibernate$test$Fum;
    static /* synthetic */ Class class$cirrus$hibernate$test$Fumm;
    static /* synthetic */ Class class$cirrus$hibernate$test$One;
    static /* synthetic */ Class class$cirrus$hibernate$test$Many;
    static /* synthetic */ Class class$cirrus$hibernate$test$Immutable;
    static /* synthetic */ Class class$cirrus$hibernate$test$Vetoer;
    static /* synthetic */ Class class$cirrus$hibernate$test$Fo;
    static /* synthetic */ Class class$cirrus$hibernate$test$Location;
    static /* synthetic */ Class class$cirrus$hibernate$test$FooBarTest;

    public FooBarTest(String arg) {
        super(arg);
    }

    public void testAssociationId() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Bar bar = new Bar();
        String id = (String)((Object)s.save(bar));
        MoreStuff more = new MoreStuff();
        more.setName("More Stuff");
        more.setIntId(12);
        more.setStringId("id");
        Stuff stuf = new Stuff();
        stuf.setMoreStuff(more);
        more.setStuffs(new ArrayList());
        more.getStuffs().add(stuf);
        stuf.setFoo(bar);
        stuf.setId(1234L);
        stuf.setProperty(TimeZone.getDefault());
        s.save(more);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        Assert.assertTrue((s.find("from s in class Stuff where s.foo.id = ? and s.id.id = ? and s.moreStuff.id.intId = ? and s.moreStuff.id.stringId = ?", new Object[]{bar, new Long(1234L), new Integer(12), "id"}, new Type[]{Hibernate.association(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo), Hibernate.LONG, Hibernate.INTEGER, Hibernate.STRING}).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from s in class Stuff where s.foo.id = ? and s.id.id = ? and s.moreStuff.name = ?", new Object[]{bar, new Long(1234L), "More Stuff"}, new Type[]{Hibernate.association(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo), Hibernate.LONG, Hibernate.STRING}).size() == 1 ? 1 : 0) != 0);
        s.find("from s in class Stuff where s.foo.string is not null");
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        FooProxy foo = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)id));
        s.load(more, (Serializable)more);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        Stuff stuff = new Stuff();
        stuff.setFoo(foo);
        stuff.setId(1234L);
        stuff.setMoreStuff(more);
        s.load(stuff, (Serializable)stuff);
        Assert.assertTrue((boolean)stuff.getProperty().equals(TimeZone.getDefault()));
        Assert.assertTrue((boolean)stuff.getMoreStuff().getName().equals("More Stuff"));
        s.delete(stuff.getMoreStuff());
        s.delete("from foo in class Foo");
        t.commit();
        s.close();
    }

    public void testCompositeKeyPathExpressions() throws Exception {
        Session s = TestCase.sessions.openSession();
        s.find("select fum1.fo from fum1 in class Fum where fum1.fo.fum is not null");
        s.find("from fum1 in class Fum where fum1.fo.fum is not null order by fum1.fo.fum");
        if (!(TestCase.dialect instanceof MySQLDialect || TestCase.dialect instanceof HSQLDialect || TestCase.dialect instanceof MckoiDialect || TestCase.dialect instanceof PointbaseDialect)) {
            s.find("from fum1 in class Fum where exists fum1.friends.elements");
            s.find("from fum1 in class Fum where fum1.friends.size = 0");
        }
        s.find("select fum1.friends.elements from fum1 in class Fum");
        s.find("from fum1 in class Fum, fr in fum1.friends.elements");
        s.close();
    }

    public void testCollectionsInSelect() throws Exception {
        Object[] arr;
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        FooProxy[] foos = new Foo[]{null, new Foo()};
        s.save(foos[1]);
        Baz baz = new Baz();
        baz.setDefaults();
        baz.setFooArray(foos);
        s.save(baz);
        Baz baz2 = new Baz();
        baz2.setDefaults();
        s.save(baz2);
        Bar bar = new Bar();
        bar.setBaz(baz);
        s.save(bar);
        Assert.assertTrue((s.find("from bar in class Bar, foo in bar.baz.fooSet.elements").size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from bar in class Bar, foo in bar.baz.fooArray.elements").size() == 1 ? 1 : 0) != 0);
        s.delete(bar);
        if (TestCase.dialect instanceof DB2Dialect || TestCase.dialect instanceof PostgreSQLDialect) {
            s.iterate("select one from one in class cirrus.hibernate.test.One, many in one.manies.elements group by one order by count(many)");
            s.iterate("select one from one in class cirrus.hibernate.test.One, many in one.manies.elements group by one having count(many) < 5");
        }
        s.find("from one in class cirrus.hibernate.test.One, many in one.manies.elements where one.id = 1 and many.id = 1");
        s.iterate("select one.id, one.manies.elements from one in class cirrus.hibernate.test.One");
        s.iterate("select max( one.manies.elements ) from one in class cirrus.hibernate.test.One");
        s.find("select one, one.manies.elements from one in class cirrus.hibernate.test.One");
        s.iterate("select one, max(one.manies.elements) from one in class cirrus.hibernate.test.One group by one");
        Iterator iter = s.iterate("select baz.fooArray.elements from baz in class Baz where baz.id=?", baz.getCode(), Hibernate.STRING);
        Assert.assertTrue((iter.next() == null && iter.next() == foos[1] && !iter.hasNext() ? 1 : 0) != 0);
        List list = s.find("select baz.fooArray.elements from baz in class Baz where baz.id=?", baz.getCode(), Hibernate.STRING);
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        iter = s.iterate("select baz.fooArray.indices from baz in class Baz where baz.id=?", baz.getCode(), Hibernate.STRING);
        Assert.assertTrue((iter.next().equals(new Integer(0)) && iter.next().equals(new Integer(1)) && !iter.hasNext() ? 1 : 0) != 0);
        iter = s.iterate("select baz, max(baz.timeArray.elements) from baz in class Baz group by baz");
        while (iter.hasNext()) {
            arr = (Object[])iter.next();
            System.out.println(arr[0] + " " + arr[1]);
        }
        iter = s.iterate("select baz, baz.stringSet.size, count(distinct baz.stringSet.elements), max(baz.stringSet.elements) from baz in class Baz group by baz");
        while (iter.hasNext()) {
            arr = (Object[])iter.next();
            System.out.println(arr[0] + " " + arr[1] + " " + arr[2] + " " + arr[3]);
        }
        Assert.assertTrue((boolean)(s.iterate("select max(baz.timeArray.elements) from baz in class Baz where baz.id=?", baz.getCode(), Hibernate.STRING).next() instanceof Time));
        Assert.assertTrue((boolean)s.iterate("select max(baz.stringSet.elements) from baz in class Baz where baz.id=?", baz.getCode(), Hibernate.STRING).next().equals("foo"));
        Assert.assertTrue((boolean)s.iterate("select baz.stringSet.size from baz in class Baz where baz.id=?", baz.getCode(), Hibernate.STRING).next().equals(new Integer(3)));
        s.delete(baz);
        s.delete(baz2);
        s.delete(foos[1]);
        t.commit();
        s.close();
    }

    public void testNewFlushing() throws Exception {
        Session s = TestCase.sessions.openSession();
        Baz baz = new Baz();
        baz.setDefaults();
        s.save(baz);
        s.flush();
        baz.getStringArray()[0] = "a new value";
        Iterator iter = s.iterate("from baz in class Baz");
        Assert.assertTrue((iter.next() == baz ? 1 : 0) != 0);
        iter = s.iterate("select baz.stringArray.elements from baz in class Baz");
        boolean found = false;
        while (iter.hasNext()) {
            if (!iter.next().equals("a new value")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        baz.setStringArray(null);
        s.iterate("from baz in class Baz");
        iter = s.iterate("select baz.stringArray.elements from baz in class Baz");
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        baz.getStringList().add("1E1");
        iter = s.iterate("from foo in class Foo");
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        iter = s.iterate("select baz.stringList.elements from baz in class Baz");
        found = false;
        while (iter.hasNext()) {
            if (!iter.next().equals("1E1")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        baz.getStringList().remove("1E1");
        iter = s.iterate("select baz.stringArray.elements from baz in class Baz");
        iter = s.iterate("select baz.stringList.elements from baz in class Baz");
        found = false;
        while (iter.hasNext()) {
            if (!iter.next().equals("1E1")) continue;
            found = true;
        }
        Assert.assertTrue((!found ? 1 : 0) != 0);
        ArrayList<String> newList = new ArrayList<String>();
        newList.add("value");
        baz.setStringList(newList);
        iter = s.iterate("from foo in class Foo");
        baz.setStringList(null);
        iter = s.iterate("select baz.stringList.elements from baz in class Baz");
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        baz.setStringList(newList);
        iter = s.iterate("from foo in class Foo");
        iter = s.iterate("select baz.stringList.elements from baz in class Baz");
        Assert.assertTrue((boolean)iter.hasNext());
        s.delete(baz);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testPersistCollections() throws Exception {
        List list;
        Session s = TestCase.sessions.openSession();
        Assert.assertTrue((boolean)s.iterate("select count(*) from b in class Bar").next().equals(new Integer(0)));
        Baz baz = new Baz();
        s.save(baz);
        baz.setDefaults();
        HashSet<Bar> bars = new HashSet<Bar>();
        bars.add(new Bar());
        baz.setCascadingBars(bars);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)((Object[])s.find("select baz, baz from baz in class cirrus.hibernate.test.Baz").get(0))[1];
        Foo foo = new Foo();
        s.save(foo);
        Foo foo2 = new Foo();
        s.save(foo2);
        baz.setFooArray(new Foo[]{foo, foo, null, foo2});
        baz.getFooSet().add(foo);
        baz.getCustoms().add(new String[]{"new", "custom"});
        baz.getSetArray()[0].add("xxx");
        baz.setStringArray(null);
        baz.getSetList().set(3, null);
        baz.getStringList().set(0, "new value");
        baz.getSetList().set(1, baz.getStringSet());
        baz.setStringSet(new TreeSet());
        this.assertTrue(baz.getComponents()[0].getImportantDates().length == 3, "collection in component in collection");
        baz.getComponents()[0].setImportantDates(baz.getComponents()[1].getImportantDates());
        baz.getComponents()[1].setImportantDates(null);
        Time time = new Time(12345L);
        baz.getTimeArray()[2] = time;
        if (!(TestCase.dialect instanceof MySQLDialect || TestCase.dialect instanceof HSQLDialect || TestCase.dialect instanceof PointbaseDialect)) {
            list = s.find("select foo from foo in class cirrus.hibernate.test.Foo, baz in class cirrus.hibernate.test.Baz where foo in baz.fooArray.elements and 3 = some baz.intArray.elements and 4 > all baz.intArray.indices");
            this.assertTrue(list.size() == 2, "collection.elements find");
        }
        if (!(TestCase.dialect instanceof SAPDBDialect)) {
            list = s.find("select distinct foo from baz in class cirrus.hibernate.test.Baz, foo in baz.fooArray.elements");
            this.assertTrue(list.size() == 2, "collection.elements find");
        }
        this.assertTrue((list = s.find("select foo from baz in class cirrus.hibernate.test.Baz, foo in baz.fooSet.elements")).size() == 1, "association.elements find");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.find("select baz from baz in class cirrus.hibernate.test.Baz order by baz").get(0);
        this.assertTrue(baz.getComponents()[0].getImportantDates().length == 1, "collection in component in collection");
        this.assertTrue(baz.getComponents()[1].getImportantDates() == null, "collection in component in collection");
        this.assertTrue(baz.getCustoms().size() == 4 && baz.getCustoms().get(0) != null, "collection of custom types - added element");
        this.assertTrue(baz.getComponents()[1].getSubcomponent() != null, "component of component in collection");
        this.assertTrue(((FooProxy)baz.getFooSet().iterator().next()).getKey().equals(foo.getKey()), "set of objects");
        this.assertTrue(baz.getSetArray()[0].contains("xxx"), "changed element");
        this.assertTrue(baz.getStringArray() == null, "collection removed");
        this.assertTrue(baz.getSetList().get(3) == null, "subcollection removed");
        this.assertTrue(((Set)baz.getSetList().get(1)).size() == 3, "subcollection moved");
        this.assertTrue(baz.getStringList().get(0).equals("new value"), "changed element");
        this.assertTrue(baz.getStringSet().size() == 0, "replaced set");
        this.assertTrue(baz.getTimeArray()[2] != null, "array element change");
        baz.getStringSet().add("two");
        baz.getStringSet().add("one");
        baz.getBag().add("three");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.find("select baz from baz in class cirrus.hibernate.test.Baz order by baz").get(0);
        Assert.assertTrue((baz.getStringSet().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)baz.getStringSet().first().equals("one"));
        Assert.assertTrue((boolean)baz.getStringSet().last().equals("two"));
        Assert.assertTrue((baz.getBag().size() == 5 ? 1 : 0) != 0);
        baz.getStringSet().remove("two");
        baz.getBag().remove("duplicate");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        Bar bar = new Bar();
        Bar bar2 = new Bar();
        s.save(bar);
        s.save(bar2);
        baz.setTopFoos(new HashSet());
        baz.getTopFoos().add(bar);
        baz.getTopFoos().add(bar2);
        baz.setTopGlarchez(new TreeMap());
        GlarchProxy g = new Glarch();
        s.save(g);
        baz.getTopGlarchez().put(new Character('G'), g);
        HashMap<Serializable, Named> map = new HashMap<Serializable, Named>();
        map.put(bar, (Named)((Object)g));
        map.put(bar2, (Named)((Object)g));
        baz.setFooToGlarch(map);
        map = new HashMap();
        map.put(new FooComponent("name", 123, null, null), bar);
        baz.setFooComponentToFoo(map);
        map = new HashMap();
        map.put(bar, (Named)((Object)g));
        baz.setGlarchToFoo(map);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.find("select baz from baz in class cirrus.hibernate.test.Baz order by baz").get(0);
        Assert.assertTrue((baz.getTopFoos().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((baz.getTopGlarchez().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((baz.getTopFoos().iterator().next() != null ? 1 : 0) != 0);
        Assert.assertTrue((baz.getStringSet().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((baz.getBag().size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((baz.getFooToGlarch().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((baz.getFooComponentToFoo().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((baz.getGlarchToFoo().size() == 1 ? 1 : 0) != 0);
        Iterator iter = baz.getFooToGlarch().keySet().iterator();
        int i = 0;
        while (i < 2) {
            Assert.assertTrue((boolean)(iter.next() instanceof BarProxy));
            ++i;
        }
        FooComponent fooComp = (FooComponent)baz.getFooComponentToFoo().keySet().iterator().next();
        Assert.assertTrue((fooComp.getCount() == 123 && fooComp.getName().equals("name") && baz.getFooComponentToFoo().get(fooComp) instanceof BarProxy ? 1 : 0) != 0);
        Glarch g2 = new Glarch();
        s.save(g2);
        g = (GlarchProxy)baz.getTopGlarchez().get(new Character('G'));
        baz.getTopGlarchez().put(new Character('H'), g);
        baz.getTopGlarchez().put(new Character('G'), g2);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.find("select baz from baz in class cirrus.hibernate.test.Baz order by baz").get(0);
        Assert.assertTrue((baz.getTopGlarchez().size() == 2 ? 1 : 0) != 0);
        s.delete(baz);
        s.delete(baz.getTopGlarchez().get(new Character('G')));
        s.delete(baz.getTopGlarchez().get(new Character('H')));
        Assert.assertTrue((s.delete("from bar in class cirrus.hibernate.test.Bar") == 2 ? 1 : 0) != 0);
        FooProxy[] arr = baz.getFooArray();
        this.assertTrue(arr.length == 4 && arr[1].getKey().equals(foo.getKey()), "new array of objects");
        int i2 = 1;
        while (i2 < arr.length) {
            if (arr[i2] != null) {
                s.delete(arr[i2]);
            }
            ++i2;
        }
        s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, (Serializable)new Long(666L));
        s.flush();
        s.connection().commit();
        s.disconnect();
        SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)s));
        Assert.assertTrue((s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, (Serializable)new Long(666L)) != null ? 1 : 0) != 0);
        s.close();
    }

    public void testSaveFlush() throws Exception {
        Session s = TestCase.sessions.openSession();
        Fee fee = new Fee();
        s.save(fee, (Serializable)((Object)"key"));
        fee.setFi("blah");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        fee = (Fee)s.load(class$cirrus$hibernate$test$Fee == null ? (class$cirrus$hibernate$test$Fee = FooBarTest.class$("cirrus.hibernate.test.Fee")) : class$cirrus$hibernate$test$Fee, (Serializable)((Object)fee.getKey()));
        Assert.assertTrue((boolean)"blah".equals(fee.getFi()));
        Assert.assertTrue((boolean)"key".equals(fee.getKey()));
        s.delete(fee);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testCreateUpdate() throws Exception {
        Session s = TestCase.sessions.openSession();
        Foo foo = new Foo();
        s.save(foo);
        foo.setString("dirty");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Foo foo2 = new Foo();
        s.load(foo2, (Serializable)((Object)foo.getKey()));
        this.assertTrue(foo.equalsFoo(foo2), "create-update");
        s.delete(foo2);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        foo = new Foo();
        s.save(foo, (Serializable)((Object)"assignedid"));
        foo.setString("dirty");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.load(foo2, (Serializable)((Object)"assignedid"));
        this.assertTrue(foo.equalsFoo(foo2), "create-update");
        s.delete(foo2);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testUpdate() throws Exception {
        Session s = TestCase.sessions.openSession();
        Foo foo = new Foo();
        s.save(foo);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        FooProxy foo2 = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)foo.getKey()));
        foo2.setString("dirty");
        foo2.setBoolean(new Boolean(false));
        foo2.setBytes(new byte[]{1, 2, 3});
        foo2.setDate(null);
        foo2.setShort(new Short("69"));
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Foo foo3 = new Foo();
        s.load(foo3, (Serializable)((Object)foo.getKey()));
        this.assertTrue(foo2.equalsFoo(foo3), "update");
        s.delete(foo3);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testUpdateCollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        Holder baz = new Holder();
        baz.setName("123");
        Foo f1 = new Foo();
        Foo f2 = new Foo();
        Foo f3 = new Foo();
        One o = new One();
        baz.setOnes(new ArrayList());
        baz.getOnes().add(o);
        Foo[] foos = new Foo[]{f1, null, f2};
        baz.setFooArray(foos);
        baz.setFoos(new HashSet());
        baz.getFoos().add(f1);
        s.save(f1);
        s.save(f2);
        s.save(f3);
        s.save(o);
        s.save(baz);
        s.flush();
        s.connection().commit();
        s.close();
        baz.getOnes().set(0, null);
        baz.getOnes().add(o);
        baz.getFoos().add(f2);
        foos[0] = f3;
        foos[1] = f1;
        s = TestCase.sessions.openSession();
        s.saveOrUpdate(baz);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Holder h = (Holder)s.load(class$cirrus$hibernate$test$Holder == null ? (class$cirrus$hibernate$test$Holder = FooBarTest.class$("cirrus.hibernate.test.Holder")) : class$cirrus$hibernate$test$Holder, (Serializable)((Object)baz.getId()));
        Assert.assertTrue((h.getOnes().get(0) == null ? 1 : 0) != 0);
        Assert.assertTrue((h.getOnes().get(1) != null ? 1 : 0) != 0);
        Assert.assertTrue((h.getFooArray()[0] != null ? 1 : 0) != 0);
        Assert.assertTrue((h.getFooArray()[1] != null ? 1 : 0) != 0);
        Assert.assertTrue((h.getFooArray()[2] != null ? 1 : 0) != 0);
        Assert.assertTrue((h.getFoos().size() == 2 ? 1 : 0) != 0);
        s.close();
        baz.getFoos().remove(f1);
        baz.getFoos().remove(f2);
        baz.getFooArray()[0] = null;
        baz.getFooArray()[0] = null;
        baz.getFooArray()[0] = null;
        s = TestCase.sessions.openSession();
        s.saveOrUpdate(baz);
        s.delete("from f in class cirrus.hibernate.test.Foo");
        baz.getOnes().remove(o);
        s.delete("from o in class cirrus.hibernate.test.One");
        s.delete(h);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testLoad() throws Exception {
        Session s = TestCase.sessions.openSession();
        Qux q = new Qux();
        s.save(q);
        BarProxy b = new Bar();
        s.save(b);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        q = (Qux)s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, (Serializable)q.getKey());
        b = (BarProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)b.getKey()));
        BarProxy b2 = (BarProxy)s.load(class$cirrus$hibernate$test$Bar == null ? (class$cirrus$hibernate$test$Bar = FooBarTest.class$("cirrus.hibernate.test.Bar")) : class$cirrus$hibernate$test$Bar, (Serializable)((Object)new String(b.getKey())));
        Qux q2 = (Qux)s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, (Serializable)q.getKey());
        this.assertTrue(q == q2, "loaded same object");
        this.assertTrue(b == b2, "loaded same object");
        s.delete(q2);
        s.delete(b2);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testCreate() throws Exception {
        Session s = TestCase.sessions.openSession();
        Foo foo = new Foo();
        s.save(foo);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Foo foo2 = new Foo();
        s.load(foo2, (Serializable)((Object)foo.getKey()));
        this.assertTrue(foo.equalsFoo(foo2), "create");
        s.delete(foo2);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testCallback() throws Exception {
        Session s = TestCase.sessions.openSession();
        Qux q = new Qux("0");
        s.save(q);
        q.setChild(new Qux("1"));
        s.save(q.getChild());
        Qux q2 = new Qux("2");
        q2.setChild(q.getChild());
        Qux q3 = new Qux("3");
        q.getChild().setChild(q3);
        s.save(q3);
        Qux q4 = new Qux("4");
        q4.setChild(q3);
        s.save(q4);
        s.save(q2);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        List l = s.find("from q in class cirrus.hibernate.test.Qux");
        this.assertTrue(l.size() == 5, "");
        s.delete(l.get(0));
        s.delete(l.get(1));
        s.delete(l.get(2));
        s.delete(l.get(3));
        s.delete(l.get(4));
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testPolymorphism() throws Exception {
        Session s = TestCase.sessions.openSession();
        Bar bar = new Bar();
        s.save(bar);
        bar.setBarString("bar bar");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        FooProxy foo = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)bar.getKey()));
        this.assertTrue(foo instanceof BarProxy, "polymorphic");
        this.assertTrue(((BarProxy)foo).getBarString().equals(bar.getBarString()), "subclass property");
        s.delete(foo);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testCollectionOfSelf() throws Exception {
        Session s = TestCase.sessions.openSession();
        Bar bar = new Bar();
        s.save(bar);
        bar.setAbstracts(new HashSet());
        bar.getAbstracts().add(bar);
        Bar bar2 = new Bar();
        bar.getAbstracts().add(bar2);
        bar.setFoo(bar);
        s.save(bar2);
        s.flush();
        s.connection().commit();
        s.close();
        bar.setAbstracts(null);
        s = TestCase.sessions.openSession();
        s.load(bar, (Serializable)((Object)bar.getKey()));
        this.assertTrue(bar.getAbstracts().size() == 2 && bar.getAbstracts().contains(bar), "collection contains self");
        this.assertTrue(bar.getFoo() == bar, "association to self");
        Iterator iter = bar.getAbstracts().iterator();
        while (iter.hasNext()) {
            s.delete(iter.next());
        }
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testFind() throws Exception {
        Session s = TestCase.sessions.openSession();
        if (!(TestCase.dialect instanceof MySQLDialect || TestCase.dialect instanceof HSQLDialect || TestCase.dialect instanceof MckoiDialect || TestCase.dialect instanceof SAPDBDialect || TestCase.dialect instanceof PointbaseDialect)) {
            s.iterate("from bz in class Baz where bz.setArray[0].size=0");
            s.iterate("from bz in class Baz where not 'foo' in bz.setArray[0].elements");
            s.iterate("from bz in class Baz where 3 in bz.stringArrayMap['foo'].indices");
        }
        s.iterate("from bz in class Baz where bz.stringArrayMap['foo'][0] = 'foo'");
        Bar bar = new Bar();
        s.save(bar);
        bar.setBarString("bar bar");
        bar.setString("xxx");
        Foo foo = new Foo();
        s.save(foo);
        foo.setString("foo bar");
        s.save(new Foo());
        s.save(new Bar());
        List list1 = s.find("select foo from foo in class cirrus.hibernate.test.Foo where foo.string='foo bar'");
        this.assertTrue(list1.size() == 1, "find size");
        this.assertTrue(list1.get(0) == foo, "find ==");
        List list2 = s.find("from foo in class cirrus.hibernate.test.Foo order by foo.string, foo.date");
        this.assertTrue(list2.size() == 4, "find size");
        list1 = s.find("from foo in class cirrus.hibernate.test.Foo where foo.class='B'");
        this.assertTrue(list1.size() == 2, "class special property");
        list1 = s.find("from foo in class cirrus.hibernate.test.Foo where foo.class=cirrus.hibernate.test.Bar");
        this.assertTrue(list1.size() == 2, "class special property");
        list1 = s.find("from foo in class cirrus.hibernate.test.Foo where foo.class=Bar");
        list2 = s.find("select bar from bar in class cirrus.hibernate.test.Bar, foo in class cirrus.hibernate.test.Foo where bar.string = foo.string and not bar=foo");
        this.assertTrue(list1.size() == 2, "class special property");
        this.assertTrue(list2.size() == 1, "select from a subclass");
        Trivial t = new Trivial();
        s.save(t);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        list1 = s.find("from foo in class cirrus.hibernate.test.Foo where foo.string='foo bar'");
        this.assertTrue(list1.size() == 1, "find size");
        this.assertTrue(((Foo)list1.get(0)).equalsFoo(foo), "find equals");
        list2 = s.find("select foo from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue(list2.size() == 5, "find size");
        List list3 = s.find("from bar in class cirrus.hibernate.test.Bar where bar.barString='bar bar'");
        this.assertTrue(list3.size() == 1, "find size");
        this.assertTrue(list2.contains(list1.get(0)) && list2.contains(list2.get(0)), "find same instance");
        Assert.assertTrue((s.find("from t in class cirrus.hibernate.test.Trivial").size() == 1 ? 1 : 0) != 0);
        s.delete("from t in class cirrus.hibernate.test.Trivial");
        list2 = s.find("from foo in class cirrus.hibernate.test.Foo where foo.date = ?", new Date(123L), Hibernate.DATE);
        this.assertTrue(list2.size() == 4, "find by date");
        Iterator iter = list2.iterator();
        while (iter.hasNext()) {
            s.delete(iter.next());
        }
        list2 = s.find("from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue(list2.size() == 0, "find deleted");
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testQuery() throws Exception {
        Object[] row;
        List list;
        Session s = TestCase.sessions.openSession();
        Foo foo = new Foo();
        s.save(foo);
        Foo foo2 = new Foo();
        s.save(foo2);
        foo.setFoo(foo2);
        if (TestCase.dialect instanceof DB2Dialect) {
            s.find("from foo in class Foo where lower( foo.foo.string ) = 'foo'");
            s.find("from foo in class Foo where lower( (foo.foo.string || 'foo') || 'bar' ) = 'foo'");
            s.find("from foo in class Foo where repeat( (foo.foo.string || 'foo') || 'bar', 2 ) = 'foo'");
            s.find("from foo in class Bar where foo.foo.integer is not null and repeat( (foo.foo.string || 'foo') || 'bar', (5+5)/2 ) = 'foo'");
            s.find("from foo in class Bar where foo.foo.integer is not null or repeat( (foo.foo.string || 'foo') || 'bar', (5+5)/2 ) = 'foo'");
        }
        this.assertTrue((list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.string='osama bin laden' and foo.boolean = true order by foo.string asc, foo.component.count desc")).size() == 0, "empty query");
        Iterator iter = s.iterate("from foo in class cirrus.hibernate.test.Foo where foo.string='osama bin laden' order by foo.string asc, foo.component.count desc");
        this.assertTrue(!iter.hasNext(), "empty iterator");
        list = s.find("select foo.foo from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue(list.size() == 1, "query");
        this.assertTrue(list.get(0) == foo.getFoo(), "returned object");
        foo.getFoo().setFoo(foo);
        foo.setString("fizard");
        if (!(TestCase.dialect instanceof MySQLDialect || TestCase.dialect instanceof HSQLDialect || TestCase.dialect instanceof MckoiDialect || TestCase.dialect instanceof SAPDBDialect || TestCase.dialect instanceof PointbaseDialect)) {
            if (!(TestCase.dialect instanceof InterbaseDialect)) {
                list = s.find("from foo in class cirrus.hibernate.test.Foo where ? = some foo.component.importantDates.elements", new java.util.Date(), Hibernate.DATE);
                this.assertTrue(list.size() == 2, "component query");
            }
            this.assertTrue((list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.component.importantDates.size = 4")).size() == 2, "component query");
            list = s.find("from foo in class cirrus.hibernate.test.Foo where 0 = foo.component.importantDates.size");
            this.assertTrue(list.size() == 0, "component query");
            list = s.find("from foo in class cirrus.hibernate.test.Foo where exists foo.component.importantDates.elements");
            this.assertTrue(list.size() == 2, "component query");
            s.find("from foo in class Foo where not exists (from bar in class Bar where bar.id = foo.id)");
        }
        this.assertTrue((list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.component.count is null order by foo.component.count")).size() == 0, "component query");
        list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.component.name='foo'");
        this.assertTrue(list.size() == 2, "component query");
        list = s.find("select foo.foo from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue(list.size() == 2, "query");
        list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.id=?", foo.getKey(), Hibernate.STRING);
        this.assertTrue(list.size() == 1, "id query");
        list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.key=?", foo.getKey(), Hibernate.STRING);
        this.assertTrue(list.size() == 1, "named id query");
        this.assertTrue(list.get(0) == foo, "id query");
        list = s.find("select foo.foo from foo in class cirrus.hibernate.test.Foo where foo.string='fizard'");
        this.assertTrue(list.size() == 1, "query");
        this.assertTrue(list.get(0) == foo.getFoo(), "returned object");
        list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.component.subcomponent.name='bar'");
        this.assertTrue(list.size() == 2, "components of components");
        list = s.find("select foo.foo from foo in class cirrus.hibernate.test.Foo where foo.foo.id=?", foo.getFoo().getKey(), Hibernate.STRING);
        this.assertTrue(list.size() == 1, "by id query");
        this.assertTrue(list.get(0) == foo.getFoo(), "by id returned object");
        s.find("from foo in class cirrus.hibernate.test.Foo where foo.foo = ?", foo.getFoo(), Hibernate.association(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo));
        Assert.assertTrue((!s.iterate("from bar in class Bar where bar.string='a string' or bar.string='a string'").hasNext() ? 1 : 0) != 0);
        iter = s.iterate("select foo.component.name, foo.component.importantDates.elements from foo in class cirrus.hibernate.test.Foo where foo.foo.id=?", foo.getFoo().getKey(), Hibernate.STRING);
        int i = 0;
        while (iter.hasNext()) {
            ++i;
            Object[] row2 = (Object[])iter.next();
            Assert.assertTrue((row2[0] instanceof String && (row2[1] == null || row2[1] instanceof java.util.Date) ? 1 : 0) != 0);
        }
        Assert.assertTrue((i == 4 ? 1 : 0) != 0);
        iter = s.iterate("select max(foo.component.importantDates.elements) from foo in class cirrus.hibernate.test.Foo group by foo.id");
        Assert.assertTrue((boolean)(iter.next() instanceof java.util.Date));
        list = s.find("select foo.foo.foo.foo from foo in class cirrus.hibernate.test.Foo, foo2 in class cirrus.hibernate.test.Foo where foo = foo2.foo and not not ( not foo.string='fizard' ) and foo2.string between 'a' and (foo.foo.string)" + (TestCase.dialect instanceof HSQLDialect || TestCase.dialect instanceof InterbaseDialect ? " and ( foo2.string in ( 'fiz', 'blah') or 1=1 )" : " and ( foo2.string in ( 'fiz', 'blah', foo.foo.string, foo.string, foo2.string ) )"));
        this.assertTrue(list.size() == 1, "complex query");
        this.assertTrue(list.get(0) == foo, "returned object");
        foo.setString("from BoogieDown  -tinsel town  =!@#$^&*())");
        list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.string='from BoogieDown  -tinsel town  =!@#$^&*())'");
        this.assertTrue(list.size() == 1, "single quotes");
        list = s.find("from foo in class cirrus.hibernate.test.Foo where foo.component.glarch.next is null");
        this.assertTrue(list.size() == 2, "query association in component");
        Bar bar = new Bar();
        Baz baz = new Baz();
        baz.setDefaults();
        bar.setBaz(baz);
        s.save(bar);
        s.save(baz);
        list = s.find(" from bar in class cirrus.hibernate.test.Bar where bar.baz.count=667 and bar.baz.count!=123 and not bar.baz.name='1-E-1'");
        this.assertTrue(list.size() == 1, "query many-to-one");
        list = s.find(" from i in class cirrus.hibernate.test.Bar where i.baz.name='Bazza'");
        this.assertTrue(list.size() == 1, "query many-to-one");
        Iterator rs = s.iterate("select count(distinct foo.foo) from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue((Integer)rs.next() == 2, "count");
        Assert.assertTrue((!rs.hasNext() ? 1 : 0) != 0);
        rs = s.iterate("select count(foo.foo.boolean) from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue((Integer)rs.next() == 2, "count");
        Assert.assertTrue((!rs.hasNext() ? 1 : 0) != 0);
        rs = s.iterate("select count(*), foo.int from foo in class cirrus.hibernate.test.Foo group by foo.int");
        this.assertTrue(((Object[])rs.next())[0].equals(new Integer(3)), "count(*) group by");
        Assert.assertTrue((!rs.hasNext() ? 1 : 0) != 0);
        rs = s.iterate("select sum(foo.foo.int) from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue((Integer)rs.next() == 4, "sum");
        Assert.assertTrue((!rs.hasNext() ? 1 : 0) != 0);
        rs = s.iterate("select count(foo) from foo in class cirrus.hibernate.test.Foo where foo.id=?", foo.getKey(), Hibernate.STRING);
        this.assertTrue((Integer)rs.next() == 1, "id query count");
        Assert.assertTrue((!rs.hasNext() ? 1 : 0) != 0);
        list = s.find("from foo in class Foo where foo.boolean = ?", new Boolean(true), Hibernate.BOOLEAN);
        list = s.find("select foo.long, foo.component.name, foo, foo.foo from foo in class Foo");
        rs = list.iterator();
        int count = 0;
        while (rs.hasNext()) {
            ++count;
            row = (Object[])rs.next();
            Assert.assertTrue((boolean)(row[0] instanceof Long));
            Assert.assertTrue((boolean)(row[1] instanceof String));
            Assert.assertTrue((boolean)(row[2] instanceof Foo));
            Assert.assertTrue((boolean)(row[3] instanceof Foo));
        }
        Assert.assertTrue((count != 0 ? 1 : 0) != 0);
        list = s.find("select avg(foo.float), max(foo.component.name), count(distinct foo.id) from foo in class Foo");
        rs = list.iterator();
        count = 0;
        while (rs.hasNext()) {
            ++count;
            row = (Object[])rs.next();
            Assert.assertTrue((boolean)(row[0] instanceof Float));
            Assert.assertTrue((boolean)(row[1] instanceof String));
            Assert.assertTrue((boolean)(row[2] instanceof Integer));
        }
        Assert.assertTrue((count != 0 ? 1 : 0) != 0);
        list = s.find("select foo.long, foo.component, foo, foo.foo from foo in class Foo");
        rs = list.iterator();
        count = 0;
        while (rs.hasNext()) {
            ++count;
            row = (Object[])rs.next();
            Assert.assertTrue((boolean)(row[0] instanceof Long));
            Assert.assertTrue((boolean)(row[1] instanceof FooComponent));
            Assert.assertTrue((boolean)(row[2] instanceof Foo));
            Assert.assertTrue((boolean)(row[3] instanceof Foo));
        }
        Assert.assertTrue((count != 0 ? 1 : 0) != 0);
        s.save(new Holder("ice T"));
        s.save(new Holder("ice cube"));
        Assert.assertTrue((s.find("from o in class java.lang.Object").size() == 15 ? 1 : 0) != 0);
        System.out.println(s.find("from n in class Named"));
        Assert.assertTrue((s.find("from n in class Named").size() == 7 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from n in class Named where n.name is not null").size() == 4 ? 1 : 0) != 0);
        iter = s.iterate("from n in class Named");
        while (iter.hasNext()) {
            Assert.assertTrue((boolean)(iter.next() instanceof Named));
        }
        s.save(new Holder("bar"));
        iter = s.iterate("from n0 in class Named, n1 in class Named where n0.name = n1.name");
        int cnt = 0;
        while (iter.hasNext()) {
            Object[] row3 = (Object[])iter.next();
            if (row3[0] == row3[1]) continue;
            ++cnt;
        }
        Assert.assertTrue((cnt == 2 ? 1 : 0) != 0);
        Assert.assertTrue((s.find("from n0 in class Named, n1 in class Named where n0.name = n1.name").size() == 7 ? 1 : 0) != 0);
        Query qu = s.createQuery("from n in class Named where n.name = :name");
        qu.getReturnTypes();
        qu.getNamedParameters();
        iter = s.iterate("from o in class java.lang.Object");
        int c = 0;
        while (iter.hasNext()) {
            iter.next();
            ++c;
        }
        Assert.assertTrue((c == 16 ? 1 : 0) != 0);
        s.iterate("select baz.code, min(baz.count) from baz in class Baz group by baz.code");
        s.iterate("Select baz from baz in class Baz where baz.stringDateMap['foo'] is not null or baz.stringDateMap['bar'] = ?", new java.util.Date(), Hibernate.DATE);
        s.find("from foo in class Foo where foo.integer not between 1 and 5 and foo.string not in ('cde', 'abc') and foo.string is not null and foo.integer<=3");
        FooProxy other = foo.getFoo();
        s.delete(bar);
        s.delete(baz);
        s.delete(other);
        s.delete(foo);
        s.delete("from h in class Holder");
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testSubcollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        Baz baz = new Baz();
        s.save(baz);
        baz.setDefaults();
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        Set[] setArray = baz.getSetArray();
        baz.setSetArray(null);
        baz.setAnotherSetArray(setArray);
        baz.setAnotherSetList(baz.getSetList());
        baz.setSetList(null);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        this.assertTrue(baz.getAnotherSetArray().length == 2 && baz.getAnotherSetArray()[0] != null, "subcollection moved property");
        this.assertTrue(baz.getSetArray() == null, "subcollection moved property");
        this.assertTrue(baz.getAnotherSetList().size() == 4 && baz.getAnotherSetList().get(2) != null, "subcollection moved role");
        this.assertTrue(baz.getSetList() == null, "subcollection moved role");
        s.delete(baz);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testReachability() throws Exception {
        Session s = TestCase.sessions.openSession();
        Baz baz1 = new Baz();
        s.save(baz1);
        Baz baz2 = new Baz();
        s.save(baz2);
        baz1.setIntArray(new int[]{1, 2, 3, 4});
        baz1.setFooSet(new HashSet());
        Foo foo = new Foo();
        s.save(foo);
        baz1.getFooSet().add(foo);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz2 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz2.getCode()));
        baz1 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz1.getCode()));
        baz2.setFooSet(baz1.getFooSet());
        baz1.setFooSet(null);
        baz2.setIntArray(baz1.getIntArray());
        baz1.setIntArray(null);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz2 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz2.getCode()));
        baz1 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz1.getCode()));
        this.assertTrue(baz2.getIntArray().length == 4, "unkeyed reachability");
        this.assertTrue(baz2.getFooSet().size() == 1, "unkeyed reachability");
        this.assertTrue(baz1.getIntArray().length == 0, "unkeyed reachability");
        this.assertTrue(baz1.getFooSet().size() == 0, "unkeyed reachability");
        s.delete((FooProxy)baz2.getFooSet().iterator().next());
        s.delete(baz1);
        s.delete(baz2);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz1 = new Baz();
        s.save(baz1);
        baz2 = new Baz();
        s.save(baz2);
        TreeSet<String> set1 = new TreeSet<String>();
        TreeSet<String> set2 = new TreeSet<String>();
        LinkedList<TreeSet<String>> list = new LinkedList<TreeSet<String>>();
        list.add(set1);
        list.add(set2);
        list.add(null);
        set1.add("foo");
        set1.add("bar");
        set1.add("baz");
        set2.add("illflow");
        set2.add("4");
        set2.add("life");
        baz1.setSetList(list);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz2 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz2.getCode()));
        baz1 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz1.getCode()));
        baz2.setSetList(baz1.getSetList());
        baz1.setSetList(null);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz2 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz2.getCode()));
        this.assertTrue(baz2.getSetList().get(0) != null, "subcollection reachability");
        this.assertTrue(((Set)baz2.getSetList().get(0)).size() == 3, "subcollection reachability");
        baz2.getSetList().set(0, null);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz2 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz2.getCode()));
        baz1 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz1.getCode()));
        this.assertTrue(baz1.getSetList() == null, "subcollection reachability");
        this.assertTrue(baz2.getSetList().size() == 3, "subcollection reachability");
        this.assertTrue(baz2.getSetList().get(0) == null, "subcollection reachability");
        this.assertTrue(baz2.getSetList().get(2) == null, "subcollection reachability");
        this.assertTrue(((Set)baz2.getSetList().get(1)).size() == 3, "subcollection reachability");
        s.delete(baz1);
        s.delete(baz2);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz1 = new Baz();
        s.save(baz1);
        baz2 = new Baz();
        s.save(baz2);
        Foo foo1 = new Foo();
        Foo foo2 = new Foo();
        s.save(foo1);
        s.save(foo2);
        baz1.setFooArray(new Foo[]{foo1, null, foo2});
        baz1.setStringDateMap(new TreeMap());
        baz1.getStringDateMap().put("today", new java.util.Date(System.currentTimeMillis()));
        baz1.getStringDateMap().put("tomorrow", new java.util.Date(System.currentTimeMillis() + 86400000L));
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz2 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz2.getCode()));
        baz1 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz1.getCode()));
        baz2.setFooArray(baz1.getFooArray());
        baz1.setFooArray(null);
        baz2.setStringDateMap(baz1.getStringDateMap());
        baz1.setStringDateMap(null);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz2 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz2.getCode()));
        baz1 = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz1.getCode()));
        this.assertTrue(baz2.getStringDateMap().size() == 2, "reachability");
        this.assertTrue(baz2.getFooArray().length == 3, "reachability");
        this.assertTrue(baz1.getStringDateMap() == null, "reachability");
        this.assertTrue(baz1.getFooArray() == null, "reachability");
        this.assertTrue(baz2.getFooArray()[1] == null, "null element");
        this.assertTrue(baz2.getStringDateMap().get("today") != null, "non-null element");
        this.assertTrue(baz2.getStringDateMap().get("tomorrow") != null, "non-null element");
        this.assertTrue(baz2.getStringDateMap().get("foo") == null, "null element");
        s.delete(baz2.getFooArray()[0]);
        s.delete(baz2.getFooArray()[2]);
        s.delete(baz1);
        s.delete(baz2);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testPersistentLifecycle() throws Exception {
        Session s = TestCase.sessions.openSession();
        Qux q = new Qux();
        s.save(q);
        q.setStuff("foo bar baz qux");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        q = (Qux)s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, (Serializable)q.getKey());
        this.assertTrue(q.getCreated(), "lifecycle create");
        this.assertTrue(q.getLoaded(), "lifecycle load");
        this.assertTrue(q.getFoo() != null, "lifecycle subobject");
        s.delete(q);
        this.assertTrue(q.getDeleted(), "lifecycle delete");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        this.assertTrue(s.find("from foo in class cirrus.hibernate.test.Foo").size() == 0, "subdeletion");
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testIterators() throws Exception {
        Session s = TestCase.sessions.openSession();
        int i = 0;
        while (i < 10) {
            Qux q = new Qux();
            Serializable qid = s.save(q);
            this.assertTrue(q != null && qid != null, "not null");
            ++i;
        }
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Iterator iter = s.iterate("from q in class cirrus.hibernate.test.Qux where q.stuff is null");
        int count = 0;
        while (iter.hasNext()) {
            Qux q = (Qux)iter.next();
            q.setStuff("foo");
            if (count == 0 || count == 5) {
                iter.remove();
            }
            ++count;
        }
        this.assertTrue(count == 10, "iterate");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        this.assertTrue(s.delete("from q in class cirrus.hibernate.test.Qux where q.stuff=?", "foo", Hibernate.STRING) == 8, "delete by query");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        iter = s.iterate("from q in class cirrus.hibernate.test.Qux");
        this.assertTrue(!iter.hasNext(), "empty iterator");
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testVersioning() throws Exception {
        Session s = TestCase.sessions.openSession();
        GlarchProxy g = new Glarch();
        s.save(g);
        GlarchProxy g2 = new Glarch();
        s.save(g2);
        Serializable gid = s.getIdentifier(g);
        Serializable g2id = s.getIdentifier(g2);
        g.setName("glarch");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, gid);
        s.lock(g, LockMode.UPGRADE);
        g2 = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, g2id);
        this.assertTrue(g.getVersion() == 1, "version");
        this.assertTrue(g2.getVersion() == 0, "version");
        g.setName("foo");
        this.assertTrue(s.find("from g in class cirrus.hibernate.test.Glarch where g.version=2").size() == 1, "find by version");
        g.setName("bar");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, gid);
        g2 = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, g2id);
        this.assertTrue(g.getVersion() == 3, "version");
        this.assertTrue(g2.getVersion() == 0, "version");
        g.setNext(null);
        g2.setNext(g);
        s.delete(g2);
        s.delete(g);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testVersionedCollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        GlarchProxy g = new Glarch();
        s.save(g);
        g.setProxyArray(new GlarchProxy[]{g});
        String gid = (String)((Object)s.getIdentifier(g));
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        g.setStrings(list);
        HashSet<Glarch> set = new HashSet<Glarch>();
        set.add((Glarch)g);
        g.setProxySet(set);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        Assert.assertTrue((g.getStrings().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((g.getProxyArray().length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((g.getProxySet().size() == 1 ? 1 : 0) != 0);
        this.assertTrue(g.getVersion() == 1, "versioned collection before");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        Assert.assertTrue((boolean)g.getStrings().get(0).equals("foo"));
        Assert.assertTrue((g.getProxyArray()[0] == g ? 1 : 0) != 0);
        Assert.assertTrue((g.getProxySet().iterator().next() == g ? 1 : 0) != 0);
        this.assertTrue(g.getVersion() == 1, "versioned collection before");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        this.assertTrue(g.getVersion() == 1, "versioned collection before");
        g.getStrings().add("bar");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        this.assertTrue(g.getVersion() == 2, "versioned collection after");
        this.assertTrue(g.getStrings().size() == 2, "versioned collection after");
        s.delete(g);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testVersionedSubcollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        Assert.assertTrue((!s.iterate("from fee in class Fee").hasNext() ? 1 : 0) != 0);
        GlarchProxy g = new Glarch();
        s.save(g);
        String gid = (String)((Object)s.getIdentifier(g));
        HashMap map = new HashMap();
        HashSet<String> subSet = new HashSet<String>();
        map.put("xxx", subSet);
        subSet.add("foo");
        subSet.add("bar");
        g.setStringSets(map);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        this.assertTrue(g.getVersion() == 1, "versioned collection before");
        this.assertTrue(((Set)g.getStringSets().get("xxx")).size() == 2, "versioned collection before");
        ((Set)g.getStringSets().get("xxx")).add("baz");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        this.assertTrue(g.getVersion() == 2, "versioned collection after");
        this.assertTrue(((Set)g.getStringSets().get("xxx")).size() == 3, "versioned collection after");
        s.delete(g);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = new Glarch();
        ArrayList<FooComponent> list = new ArrayList<FooComponent>();
        java.util.Date[] dates = new java.util.Date[]{null, null, new java.util.Date(), new java.util.Date(0L)};
        list.add(null);
        list.add(new FooComponent("foo", 69, dates, new FooComponent("bar", 96, null, null, new Fee())));
        g.setFooComponents(list);
        String EIGHT_CHARS = "abcdefgh";
        s.save(g, (Serializable)((Object)(EIGHT_CHARS + EIGHT_CHARS + EIGHT_CHARS + EIGHT_CHARS)));
        gid = (String)((Object)s.getIdentifier(g));
        Assert.assertTrue((boolean)s.iterate("from fee in class Fee").hasNext());
        g.getFooComponents().add(new FooComponent("bar", 96, null, null));
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        this.assertTrue(g.getVersion() == 2, "versioned collection before");
        ((FooComponent)g.getFooComponents().get((int)1)).getImportantDates()[0] = new java.util.Date(123567890L);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        this.assertTrue(g.getVersion() == 3, "versioned collection after");
        ((FooComponent)g.getFooComponents().get(1)).getSubcomponent().setName("new name");
        this.assertTrue(((FooComponent)g.getFooComponents().get(1)).getImportantDates()[0] != null, "versioned collection after");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, (Serializable)((Object)gid));
        this.assertTrue(((FooComponent)g.getFooComponents().get(1)).getSubcomponent().getName().equals("new name"), "versioned collection after");
        this.assertTrue(g.getVersion() == 4, "versioned collection after");
        s.delete(g);
        Assert.assertTrue((!s.iterate("from fee in class Fee").hasNext() ? 1 : 0) != 0);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testRecursiveLoad() throws Exception {
        Session s = TestCase.sessions.openSession();
        Glarch last = new Glarch();
        s.save(last);
        last.setOrder((short)0);
        int i = 0;
        while (i < 5) {
            Glarch next = new Glarch();
            s.save(next);
            last.setNext(next);
            last = next;
            last.setOrder((short)(i + 1));
            ++i;
        }
        Iterator iter = s.iterate("from g in class cirrus.hibernate.test.Glarch");
        while (iter.hasNext()) {
            iter.next();
        }
        List list = s.find("from g in class cirrus.hibernate.test.Glarch");
        this.assertTrue(list.size() == 6, "recursive find");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        list = s.find("from g in class cirrus.hibernate.test.Glarch");
        this.assertTrue(list.size() == 6, "recursive iter");
        list = s.find("from g in class cirrus.hibernate.test.Glarch where g.next is not null");
        this.assertTrue(list.size() == 5, "recursive iter");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        iter = s.iterate("from g in class cirrus.hibernate.test.Glarch order by g.order asc");
        while (iter.hasNext()) {
            GlarchProxy g = (GlarchProxy)iter.next();
            this.assertTrue(g != null, "not null");
            iter.remove();
        }
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        FooProxy flast = new Bar();
        s.save(flast);
        flast.setString("foo0");
        int i2 = 0;
        while (i2 < 5) {
            Bar foo = new Bar();
            s.save(foo);
            flast.setFoo(foo);
            flast = flast.getFoo();
            flast.setString("foo" + (i2 + 1));
            ++i2;
        }
        iter = s.iterate("from foo in class cirrus.hibernate.test.Foo");
        while (iter.hasNext()) {
            iter.next();
        }
        list = s.find("from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue(list.size() == 6, "recursive find");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        list = s.find("from foo in class cirrus.hibernate.test.Foo");
        this.assertTrue(list.size() == 6, "recursive iter");
        iter = list.iterator();
        while (iter.hasNext()) {
            this.assertTrue(iter.next() instanceof BarProxy, "polymorphic recursive load");
        }
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        iter = s.iterate("from foo in class cirrus.hibernate.test.Foo order by foo.string asc");
        while (iter.hasNext()) {
            BarProxy bar = (BarProxy)iter.next();
            this.assertTrue(bar != null, "not null");
            iter.remove();
        }
        s.flush();
        s.connection().commit();
        s.close();
    }

    private FumCompositeID fumKey(String str) {
        return this.fumKey(str, false);
    }

    private FumCompositeID fumKey(String str, boolean aCompositeQueryTest) {
        FumCompositeID id = new FumCompositeID();
        if (TestCase.dialect instanceof MckoiDialect) {
            GregorianCalendar now = new GregorianCalendar();
            GregorianCalendar cal = new GregorianCalendar(now.get(1), now.get(2), now.get(5));
            id.setDate(cal.getTime());
        } else {
            id.setDate(new java.util.Date());
        }
        id.setString(new String(str));
        if (aCompositeQueryTest) {
            short s = this.fumKeyShort;
            this.fumKeyShort = (short)(s + 1);
            id.setShort(s);
        } else {
            id.setShort((short)12);
        }
        return id;
    }

    public void testCompositeID() throws Exception {
        Session s = TestCase.sessions.openSession();
        Fum fum = new Fum(this.fumKey("fum"));
        fum.setFum("fee fi fo");
        s.save(fum);
        this.assertTrue(fum == s.load(class$cirrus$hibernate$test$Fum == null ? (class$cirrus$hibernate$test$Fum = FooBarTest.class$("cirrus.hibernate.test.Fum")) : class$cirrus$hibernate$test$Fum, (Serializable)this.fumKey("fum")), "load by composite key");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        fum = (Fum)s.load(class$cirrus$hibernate$test$Fum == null ? (class$cirrus$hibernate$test$Fum = FooBarTest.class$("cirrus.hibernate.test.Fum")) : class$cirrus$hibernate$test$Fum, this.fumKey("fum"), LockMode.UPGRADE);
        this.assertTrue(fum != null, "load by composite key");
        Fum fum2 = new Fum(this.fumKey("fi"));
        fum2.setFum("fee fo fi");
        fum.setFo(fum2);
        s.save(fum2);
        this.assertTrue(s.find("from fum in class cirrus.hibernate.test.Fum where not fum.fum='FRIEND'").size() == 2, "find composite keyed objects");
        this.assertTrue(s.find("select fum from fum in class cirrus.hibernate.test.Fum where fum.fum='fee fi fo'").get(0) == fum, "find composite keyed object");
        fum.setFo(null);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Iterator iter = s.iterate("from fum in class cirrus.hibernate.test.Fum where not fum.fum='FRIEND'");
        int i = 0;
        while (iter.hasNext()) {
            fum = (Fum)iter.next();
            s.delete(fum);
            ++i;
        }
        this.assertTrue(i == 2, "iterate on composite key");
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testCompositeIDOneToOne() throws Exception {
        Session s = TestCase.sessions.openSession();
        Fum fum = new Fum(this.fumKey("fum"));
        fum.setFum("fee fi fo");
        Fumm fumm = new Fumm();
        fumm.setFum(fum);
        s.save(fumm);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        fumm = (Fumm)s.load(class$cirrus$hibernate$test$Fumm == null ? (class$cirrus$hibernate$test$Fumm = FooBarTest.class$("cirrus.hibernate.test.Fumm")) : class$cirrus$hibernate$test$Fumm, (Serializable)this.fumKey("fum"));
        s.delete(fumm);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testCompositeIDQuery() throws Exception {
        Session s = TestCase.sessions.openSession();
        Fum fee = new Fum(this.fumKey("fee", true));
        fee.setFum("fee");
        s.save(fee);
        Fum fi = new Fum(this.fumKey("fi", true));
        fi.setFum("fi");
        short fiShort = fi.getId().getShort();
        s.save(fi);
        Fum fo = new Fum(this.fumKey("fo", true));
        fo.setFum("fo");
        s.save(fo);
        Fum fum = new Fum(this.fumKey("fum", true));
        fum.setFum("fum");
        s.save(fum);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        List vList = s.find("from fum in class cirrus.hibernate.test.Fum where fum.id.string='fo'");
        this.assertTrue(vList.size() == 1, "find by composite key query (find fo object)");
        fum = (Fum)vList.get(0);
        this.assertTrue(fum.getId().getString().equals("fo"), "find by composite key query (check fo object)");
        vList = s.find("from fum in class cirrus.hibernate.test.Fum where fum.id.short = ?", new Short(fiShort), Hibernate.SHORT);
        this.assertTrue(vList.size() == 1, "find by composite key query (find fi object)");
        fi = (Fum)vList.get(0);
        this.assertTrue(fi.getId().getString().equals("fi"), "find by composite key query (check fi object)");
        this.assertTrue(s.find("from fum in class cirrus.hibernate.test.Fum where fum.id.date <= ? and not fum.fum='FRIEND'", new java.util.Date(), Hibernate.DATE).size() == 4, "find by composite key query with arguments");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Assert.assertTrue((boolean)s.iterate("select fum.id.short, fum.id.date, fum.id.string from fum in class cirrus.hibernate.test.Fum").hasNext());
        Assert.assertTrue((boolean)s.iterate("select fum.id from fum in class cirrus.hibernate.test.Fum").hasNext());
        Query qu = s.createQuery("select fum.fum, fum , fum.fum, fum.id.date from fum in class cirrus.hibernate.test.Fum");
        Type[] types = qu.getReturnTypes();
        Assert.assertTrue((types.length == 4 ? 1 : 0) != 0);
        int k = 0;
        while (k < types.length) {
            Assert.assertTrue((types[k] != null ? 1 : 0) != 0);
            ++k;
        }
        Assert.assertTrue((boolean)(types[0] instanceof StringType));
        Assert.assertTrue((boolean)(types[1] instanceof EntityType));
        Assert.assertTrue((boolean)(types[2] instanceof StringType));
        Assert.assertTrue((boolean)(types[3] instanceof DateType));
        Iterator iter = qu.iterate();
        int j = 0;
        while (iter.hasNext()) {
            ++j;
            Assert.assertTrue((boolean)(((Object[])iter.next())[1] instanceof Fum));
        }
        this.assertTrue(j == 8, "iterate on composite key");
        iter = s.iterate("from fum in class cirrus.hibernate.test.Fum where not fum.fum='FRIEND'");
        int i = 0;
        while (iter.hasNext()) {
            fum = (Fum)iter.next();
            s.delete(fum);
            ++i;
        }
        this.assertTrue(i == 4, "iterate on composite key");
        s.flush();
        s.iterate("from fu in class Fum, fo in class Fum where fu.fo.id.string = fo.id.string and fo.fum is not null");
        s.connection().commit();
        s.close();
    }

    public void testScrollableIterator() throws Exception {
        if (TestCase.dialect instanceof DB2Dialect || TestCase.dialect instanceof OracleDialect || TestCase.dialect instanceof SybaseDialect) {
            Session s = TestCase.sessions.openSession();
            s.save(new Foo());
            s.save(new Foo());
            s.save(new Foo());
            s.save(new Bar());
            Query query = s.createQuery("select f, f.integer from f in class Foo");
            Assert.assertTrue((query.getReturnTypes().length == 2 ? 1 : 0) != 0);
            ScrollableResults iter = query.scroll();
            Assert.assertTrue((boolean)iter.next());
            Assert.assertTrue((boolean)iter.scroll(1));
            Object f2 = iter.get()[0];
            Assert.assertTrue((f2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter.scroll(-1));
            Object f1 = iter.get(0);
            iter.next();
            Assert.assertTrue((f1 != null && iter.get(0) == f2 ? 1 : 0) != 0);
            iter.getInteger(1);
            Assert.assertTrue((!iter.scroll(100) ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter.first());
            Assert.assertTrue((boolean)iter.scroll(3));
            Object f4 = iter.get(0);
            Assert.assertTrue((f4 != null ? 1 : 0) != 0);
            Assert.assertTrue((!iter.next() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter.first());
            Assert.assertTrue((iter.get(0) == f1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter.last());
            Assert.assertTrue((iter.get(0) == f4 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iter.previous());
            Assert.assertTrue((s.delete("from f in class Foo") == 4 ? 1 : 0) != 0);
            s.flush();
            s.connection().commit();
            s.close();
        }
    }

    public void testCompositeIDCollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        Fum fum1 = new Fum(this.fumKey("fum1"));
        Fum fum2 = new Fum(this.fumKey("fum2"));
        fum1.setFum("fee fo fi");
        fum2.setFum("fee fo fi");
        s.save(fum1);
        s.save(fum2);
        Qux q = new Qux();
        s.save(q);
        HashSet<Fum> set = new HashSet<Fum>();
        ArrayList<Fum> list = new ArrayList<Fum>();
        set.add(fum1);
        set.add(fum2);
        list.add(fum1);
        q.setFums(set);
        q.setMoreFums(list);
        fum1.setQuxArray(new Qux[]{q});
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        q = (Qux)s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, (Serializable)q.getKey());
        this.assertTrue(q.getFums().size() == 2, "collection of fums");
        this.assertTrue(q.getMoreFums().size() == 1, "collection of fums");
        this.assertTrue(((Fum)q.getMoreFums().get(0)).getQuxArray()[0] == q, "unkeyed composite id collection");
        Iterator iter = q.getFums().iterator();
        iter.hasNext();
        s.delete((Fum)iter.next());
        iter.hasNext();
        s.delete((Fum)iter.next());
        s.delete(q);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testMultiColumnQueries() throws Exception {
        Session s = TestCase.sessions.openSession();
        Foo foo = new Foo();
        s.save(foo);
        Foo foo1 = new Foo();
        s.save(foo1);
        foo.setFoo(foo1);
        List l = s.find("select parent, child from parent in class cirrus.hibernate.test.Foo, child in class cirrus.hibernate.test.Foo where parent.foo = child");
        this.assertTrue(l.size() == 1, "multi-column find");
        Iterator rs = s.iterate("select count(distinct child.id), count(distinct parent.id) from parent in class cirrus.hibernate.test.Foo, child in class cirrus.hibernate.test.Foo where parent.foo = child");
        Object[] row = (Object[])rs.next();
        this.assertTrue((Integer)row[0] == 1, "multi-column count");
        this.assertTrue((Integer)row[1] == 1, "multi-column count");
        Assert.assertTrue((!rs.hasNext() ? 1 : 0) != 0);
        rs = s.iterate("select child.id, parent.id, child.long from parent in class cirrus.hibernate.test.Foo, child in class cirrus.hibernate.test.Foo where parent.foo = child");
        row = (Object[])rs.next();
        this.assertTrue(row[0].equals(foo.getFoo().getKey()), "multi-column id");
        this.assertTrue(row[1].equals(foo.getKey()), "multi-column id");
        this.assertTrue(row[2].equals(foo.getFoo().getLong()), "multi-column property");
        Assert.assertTrue((!rs.hasNext() ? 1 : 0) != 0);
        rs = s.iterate("select child.id, parent.id, child.long, child, parent.foo from parent in class cirrus.hibernate.test.Foo, child in class cirrus.hibernate.test.Foo where parent.foo = child");
        row = (Object[])rs.next();
        Assert.assertTrue((foo.getFoo().getKey().equals(row[0]) && foo.getKey().equals(row[1]) && foo.getFoo().getLong().equals(row[2]) && row[3] == foo.getFoo() && row[3] == row[4] ? 1 : 0) != 0);
        Assert.assertTrue((!rs.hasNext() ? 1 : 0) != 0);
        row = (Object[])l.get(0);
        this.assertTrue(row[0] == foo && row[1] == foo.getFoo(), "multi-column find");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Iterator iter = s.iterate("select parent, child from parent in class cirrus.hibernate.test.Foo, child in class cirrus.hibernate.test.Foo where parent.foo = child and parent.string='a string'");
        int deletions = 0;
        while (iter.hasNext()) {
            Object[] pnc = (Object[])iter.next();
            s.delete(pnc[0]);
            s.delete(pnc[1]);
            ++deletions;
        }
        this.assertTrue(deletions == 1, "multi-column iterate");
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testDeleteTransient() throws Exception {
        Fee fee = new Fee();
        Session s = TestCase.sessions.openSession();
        Transaction tx = s.beginTransaction();
        s.save(fee);
        tx.commit();
        s.close();
        s = TestCase.sessions.openSession();
        tx = s.beginTransaction();
        s.delete(fee);
        tx.commit();
        s.close();
        s = TestCase.sessions.openSession();
        tx = s.beginTransaction();
        Assert.assertTrue((s.find("from fee in class Fee").size() == 0 ? 1 : 0) != 0);
        tx.commit();
        s.close();
    }

    public void testUpdateFromTransient() throws Exception {
        Session s = TestCase.sessions.openSession();
        Fee fee1 = new Fee();
        s.save(fee1);
        Fee fee2 = new Fee();
        fee1.setFee(fee2);
        fee2.setFee(fee1);
        fee2.setFees(new HashSet());
        Fee fee3 = new Fee();
        fee3.setFee(fee1);
        fee3.setAnotherFee(fee2);
        fee2.setAnotherFee(fee3);
        s.save(fee3);
        s.save(fee2);
        s.flush();
        s.connection().commit();
        s.close();
        fee1.setFi("changed");
        s = TestCase.sessions.openSession();
        s.saveOrUpdate(fee1);
        s.flush();
        s.connection().commit();
        s.close();
        Qux q = new Qux("quxxy");
        q.setTheKey(0L);
        fee1.setQux(q);
        s = TestCase.sessions.openSession();
        s.saveOrUpdate(fee1);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        fee1 = (Fee)s.load(class$cirrus$hibernate$test$Fee == null ? (class$cirrus$hibernate$test$Fee = FooBarTest.class$("cirrus.hibernate.test.Fee")) : class$cirrus$hibernate$test$Fee, (Serializable)((Object)fee1.getKey()));
        this.assertTrue(fee1.getFi().equals("changed"), "updated from transient");
        this.assertTrue(fee1.getQux() != null, "unsaved value");
        s.delete(fee1.getQux());
        fee1.setQux(null);
        s.flush();
        s.connection().commit();
        s.close();
        fee2.setFi("CHANGED");
        fee2.getFees().add("an element");
        fee1.setFi("changed again");
        s = TestCase.sessions.openSession();
        s.saveOrUpdate(fee2);
        s.update(fee1, (Serializable)((Object)fee1.getKey()));
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Fee fee = new Fee();
        s.load(fee, (Serializable)((Object)fee2.getKey()));
        fee1 = (Fee)s.load(class$cirrus$hibernate$test$Fee == null ? (class$cirrus$hibernate$test$Fee = FooBarTest.class$("cirrus.hibernate.test.Fee")) : class$cirrus$hibernate$test$Fee, (Serializable)((Object)fee1.getKey()));
        this.assertTrue(fee1.getFi().equals("changed again"), "updated from transient");
        this.assertTrue(fee.getFi().equals("CHANGED"), "updated from transient");
        this.assertTrue(fee.getFees().contains("an element"), "updated collection");
        s.flush();
        s.connection().commit();
        s.close();
        fee.getFees().clear();
        fee.getFees().add("new element");
        fee1.setFee(null);
        s = TestCase.sessions.openSession();
        s.saveOrUpdate(fee);
        s.saveOrUpdate(fee1);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.load(fee, (Serializable)((Object)fee.getKey()));
        this.assertTrue(fee.getAnotherFee() != null, "update");
        this.assertTrue(fee.getFee() != null, "update");
        this.assertTrue(fee.getAnotherFee().getFee() == fee.getFee(), "update");
        this.assertTrue(fee.getFees().contains("new element"), "updated collection");
        this.assertTrue(!fee.getFees().contains("an element"), "updated collection");
        s.flush();
        s.connection().commit();
        s.close();
        fee.setQux(new Qux("quxy"));
        s = TestCase.sessions.openSession();
        s.saveOrUpdate(fee);
        s.flush();
        s.connection().commit();
        s.close();
        fee.getQux().setStuff("xxx");
        s = TestCase.sessions.openSession();
        s.saveOrUpdate(fee);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.load(fee, (Serializable)((Object)fee.getKey()));
        this.assertTrue(fee.getQux() != null, "cascade update");
        this.assertTrue(fee.getQux().getStuff().equals("xxx"), "cascade update");
        this.assertTrue(fee.getAnotherFee() != null, "update");
        this.assertTrue(fee.getFee() != null, "update");
        this.assertTrue(fee.getAnotherFee().getFee() == fee.getFee(), "update");
        fee.getAnotherFee().setAnotherFee(null);
        s.delete(fee);
        s.delete("from fee in class cirrus.hibernate.test.Fee");
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testDatabinder() throws Exception {
        Session s = TestCase.sessions.openSession();
        BarProxy bar = new Bar();
        s.save(bar);
        FooProxy foo = new Foo();
        s.save(foo);
        FooProxy foo2 = new Foo();
        s.save(foo2);
        foo2.setFoo(foo);
        Baz baz = new Baz();
        s.save(baz);
        baz.setDefaults();
        baz.setFooArray(new FooProxy[]{foo, foo2, bar, null});
        bar.setFoo(foo);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        bar = (BarProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)bar.getKey()));
        foo = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)foo.getKey()));
        foo2 = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)foo2.getKey()));
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        Databinder binder = TestCase.sessions.openDatabinder();
        binder.bind(foo2).bind(baz).bind(foo).bind(bar);
        System.out.println(binder.toGenericXML());
        System.out.println(binder.toXML());
        this.assertTrue(binder.toDOM() != null, "dom");
        this.assertTrue(binder.toGenericDOM() != null, "generic dom");
        s.delete(foo);
        s.delete(baz);
        s.delete(bar);
        s.delete(foo2);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testArraysOfTimes() throws Exception {
        Session s = TestCase.sessions.openSession();
        Baz baz = new Baz();
        s.save(baz);
        baz.setDefaults();
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz.getTimeArray()[2] = new java.util.Date(123L);
        baz.getTimeArray()[3] = new Time(1234L);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        s.delete(baz);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testComponents() throws Exception {
        Session s = TestCase.sessions.openSession();
        Foo foo = new Foo();
        foo.setComponent(new FooComponent("foo", 69, null, new FooComponent("bar", 96, null, null)));
        s.save(foo);
        foo.getComponent().setName("IFA");
        s.flush();
        s.connection().commit();
        s.close();
        foo.setComponent(null);
        s = TestCase.sessions.openSession();
        s.load(foo, (Serializable)((Object)foo.getKey()));
        this.assertTrue(foo.getComponent().getName().equals("IFA") && foo.getComponent().getSubcomponent().getName().equals("bar"), "save components");
        this.assertTrue(foo.getComponent().getGlarch() != null, "cascade save via component");
        foo.getComponent().getSubcomponent().setName("baz");
        s.flush();
        s.connection().commit();
        s.close();
        foo.setComponent(null);
        s = TestCase.sessions.openSession();
        s.load(foo, (Serializable)((Object)foo.getKey()));
        this.assertTrue(foo.getComponent().getName().equals("IFA") && foo.getComponent().getSubcomponent().getName().equals("baz"), "update components");
        s.delete(foo);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testEnum() throws Exception {
        Session s = TestCase.sessions.openSession();
        FooProxy foo = new Foo();
        Serializable id = s.save(foo);
        foo.setStatus(FooStatus.ON);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        foo = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, id);
        Assert.assertTrue((foo.getStatus() == FooStatus.ON ? 1 : 0) != 0);
        foo.setStatus(FooStatus.OFF);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        foo = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, id);
        Assert.assertTrue((foo.getStatus() == FooStatus.OFF ? 1 : 0) != 0);
        s.delete(foo);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testNoForeignKeyViolations() throws Exception {
        Session s = TestCase.sessions.openSession();
        Glarch g1 = new Glarch();
        Glarch g2 = new Glarch();
        g1.setNext(g2);
        g2.setNext(g1);
        s.save(g1);
        s.save(g2);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        List l = s.find("from g in class cirrus.hibernate.test.Glarch where g.next is not null");
        s.delete(l.get(0));
        s.delete(l.get(1));
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testLazyCollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        Qux q = new Qux();
        s.save(q);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        q = (Qux)s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, (Serializable)q.getKey());
        s.flush();
        s.connection().commit();
        s.close();
        System.out.println("Two exceptions are supposed to occur:");
        boolean ok = false;
        try {
            q.getMoreFums().isEmpty();
        }
        catch (LazyInitializationException e) {
            ok = true;
        }
        this.assertTrue(ok, "lazy collection with one-to-many");
        ok = false;
        try {
            q.getFums().isEmpty();
        }
        catch (LazyInitializationException e) {
            ok = true;
        }
        this.assertTrue(ok, "lazy collection with many-to-many");
        s = TestCase.sessions.openSession();
        q = (Qux)s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, (Serializable)q.getKey());
        s.delete(q);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testDeleteOwner() throws Exception {
        Session s = TestCase.sessions.openSession();
        Qux q = new Qux();
        s.save(q);
        Fum f1 = new Fum(this.fumKey("f1"));
        Fum f2 = new Fum(this.fumKey("f2"));
        HashSet<Fum> set = new HashSet<Fum>();
        set.add(f1);
        set.add(f2);
        List list = new LinkedList<Fum>();
        list.add(f1);
        list.add(f2);
        f1.setFum("f1");
        f2.setFum("f2");
        q.setFums(set);
        q.setMoreFums(list);
        s.save(f1);
        s.save(f2);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        q = (Qux)s.load(class$cirrus$hibernate$test$Qux == null ? (class$cirrus$hibernate$test$Qux = FooBarTest.class$("cirrus.hibernate.test.Qux")) : class$cirrus$hibernate$test$Qux, q.getKey(), LockMode.UPGRADE);
        s.lock(q, LockMode.UPGRADE);
        s.delete(q);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        list = s.find("from fum in class cirrus.hibernate.test.Fum where not fum.fum='FRIEND'");
        this.assertTrue(list.size() == 2, "deleted owner");
        s.lock(list.get(0), LockMode.UPGRADE);
        s.lock(list.get(1), LockMode.UPGRADE);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            s.delete(iter.next());
        }
        s.flush();
        s.connection().commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testNewSessionLifecycle() throws Exception {
        Foo f;
        Serializable fid;
        Session s;
        block13: {
            s = TestCase.sessions.openSession();
            fid = null;
            try {
                try {
                    f = new Foo();
                    s.save(f);
                    fid = s.getIdentifier(f);
                    s.flush();
                    s.connection().commit();
                }
                catch (Exception e) {
                    s.connection().rollback();
                    throw e;
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                s.close();
                throw throwable;
            }
            s.close();
            s = TestCase.sessions.openSession();
            try {
                try {
                    f = new Foo();
                    s.delete(f);
                    s.flush();
                    s.connection().commit();
                }
                catch (Exception e) {
                    s.connection().rollback();
                    Object var7_11 = null;
                    s.close();
                    break block13;
                }
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                s.close();
                throw throwable;
            }
            s.close();
        }
        s = TestCase.sessions.openSession();
        try {
            try {
                f = (Foo)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, fid, LockMode.UPGRADE);
                s.delete(f);
                s.flush();
                s.connection().commit();
            }
            catch (Exception e) {
                s.connection().rollback();
                throw e;
            }
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            Assert.assertTrue((s.close() == null ? 1 : 0) != 0);
            throw throwable;
        }
        Assert.assertTrue((s.close() == null ? 1 : 0) != 0);
    }

    public void testDisconnect() throws Exception {
        Session s = TestCase.sessions.openSession();
        Foo foo = new Foo();
        Foo foo2 = new Foo();
        s.save(foo);
        s.save(foo2);
        foo2.setFoo(foo);
        s.flush();
        s.connection().commit();
        s.disconnect();
        s.reconnect();
        s.delete(foo);
        foo2.setFoo(null);
        s.flush();
        s.connection().commit();
        s.disconnect();
        s.reconnect();
        s.delete(foo2);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testOrderBy() throws Exception {
        One one;
        Session s = TestCase.sessions.openSession();
        Transaction tx = s.beginTransaction();
        Foo foo = new Foo();
        s.save(foo);
        List list = s.find("select foo from foo in class cirrus.hibernate.test.Foo, fee in class cirrus.hibernate.test.Fee where foo.dependent = fee order by foo.string desc, foo.component.count asc, fee.id");
        this.assertTrue(list.size() == 1, "order by");
        Foo foo2 = new Foo();
        s.save(foo2);
        foo.setFoo(foo2);
        list = s.find("select foo.foo, foo.dependent from foo in class cirrus.hibernate.test.Foo order by foo.foo.string desc, foo.component.count asc, foo.dependent.id");
        this.assertTrue(list.size() == 1, "order by");
        list = s.find("select foo from foo in class cirrus.hibernate.test.Foo order by foo.dependent.id, foo.dependent.fi");
        this.assertTrue(list.size() == 2, "order by");
        s.delete(foo);
        s.delete(foo2);
        tx.commit();
        s.close();
        s = TestCase.sessions.openSession();
        Many manyB = new Many();
        s.save(manyB);
        One oneB = new One();
        s.save(oneB);
        oneB.setValue("b");
        manyB.setOne(oneB);
        Many manyA = new Many();
        s.save(manyA);
        One oneA = new One();
        s.save(oneA);
        oneA.setValue("a");
        manyA.setOne(oneA);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        Iterator it = s.iterate("SELECT one FROM one IN CLASS " + (class$cirrus$hibernate$test$One == null ? (class$cirrus$hibernate$test$One = FooBarTest.class$("cirrus.hibernate.test.One")) : class$cirrus$hibernate$test$One).getName() + " ORDER BY one.value ASC");
        int count = 0;
        while (it.hasNext()) {
            one = (One)it.next();
            switch (count) {
                case 0: {
                    this.assertTrue("a".equals(one.getValue()), "ordering failed");
                    break;
                }
                case 1: {
                    this.assertTrue("b".equals(one.getValue()), "ordering failed");
                    break;
                }
                default: {
                    this.assertTrue(false, "more than two elements");
                }
            }
            ++count;
        }
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        it = s.iterate("SELECT many.one FROM many IN CLASS " + (class$cirrus$hibernate$test$Many == null ? (class$cirrus$hibernate$test$Many = FooBarTest.class$("cirrus.hibernate.test.Many")) : class$cirrus$hibernate$test$Many).getName() + " ORDER BY many.one.value ASC, many.one.id");
        count = 0;
        while (it.hasNext()) {
            one = (One)it.next();
            switch (count) {
                case 0: {
                    this.assertTrue("a".equals(one.getValue()), "'a' isn't first element");
                    break;
                }
                case 1: {
                    this.assertTrue("b".equals(one.getValue()), "'b' isn't second element");
                    break;
                }
                default: {
                    this.assertTrue(false, "more than two elements");
                }
            }
            ++count;
        }
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        oneA = (One)s.load(class$cirrus$hibernate$test$One == null ? (class$cirrus$hibernate$test$One = FooBarTest.class$("cirrus.hibernate.test.One")) : class$cirrus$hibernate$test$One, (Serializable)new Long(oneA.getKey()));
        manyA = (Many)s.load(class$cirrus$hibernate$test$Many == null ? (class$cirrus$hibernate$test$Many = FooBarTest.class$("cirrus.hibernate.test.Many")) : class$cirrus$hibernate$test$Many, (Serializable)new Long(manyA.getKey()));
        oneB = (One)s.load(class$cirrus$hibernate$test$One == null ? (class$cirrus$hibernate$test$One = FooBarTest.class$("cirrus.hibernate.test.One")) : class$cirrus$hibernate$test$One, (Serializable)new Long(oneB.getKey()));
        manyB = (Many)s.load(class$cirrus$hibernate$test$Many == null ? (class$cirrus$hibernate$test$Many = FooBarTest.class$("cirrus.hibernate.test.Many")) : class$cirrus$hibernate$test$Many, (Serializable)new Long(manyB.getKey()));
        s.delete(manyA);
        s.delete(oneA);
        s.delete(manyB);
        s.delete(oneB);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testManyToOne() throws Exception {
        Session s = TestCase.sessions.openSession();
        One one = new One();
        s.save(one);
        one.setValue("yada");
        Many many = new Many();
        many.setOne(one);
        s.save(many);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        many = (Many)s.load(class$cirrus$hibernate$test$Many == null ? (class$cirrus$hibernate$test$Many = FooBarTest.class$("cirrus.hibernate.test.Many")) : class$cirrus$hibernate$test$Many, (Serializable)new Long(many.getKey()));
        this.assertTrue(many.getOne() != null, "many-to-one assoc");
        s.delete(many.getOne());
        s.delete(many);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testSaveDelete() throws Exception {
        Session s = TestCase.sessions.openSession();
        Foo f = new Foo();
        s.save(f);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.delete(s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)f.getKey())));
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testProxyArray() throws Exception {
        Session s = TestCase.sessions.openSession();
        GlarchProxy g = new Glarch();
        Glarch g1 = new Glarch();
        Glarch g2 = new Glarch();
        g.setProxyArray(new GlarchProxy[]{g1, g2});
        Glarch g3 = new Glarch();
        s.save(g3);
        g2.setProxyArray(new GlarchProxy[]{null, g3, g});
        HashSet<Glarch> set = new HashSet<Glarch>();
        set.add(g1);
        set.add(g2);
        g.setProxySet(set);
        s.save(g);
        s.save(g1);
        s.save(g2);
        Serializable id = s.getIdentifier(g);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        g = (GlarchProxy)s.load(class$cirrus$hibernate$test$Glarch == null ? (class$cirrus$hibernate$test$Glarch = FooBarTest.class$("cirrus.hibernate.test.Glarch")) : class$cirrus$hibernate$test$Glarch, id);
        this.assertTrue(g.getProxyArray().length == 2, "array of proxies");
        this.assertTrue(g.getProxyArray()[0] != null, "array of proxies");
        this.assertTrue(g.getProxyArray()[1].getProxyArray()[0] == null, "deferred load test");
        this.assertTrue(g.getProxyArray()[1].getProxyArray()[2] == g, "deferred load test");
        this.assertTrue(g.getProxySet().size() == 2, "set of proxies");
        Iterator iter = s.iterate("from g in class cirrus.hibernate.test.Glarch");
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
        s.flush();
        s.connection().commit();
        s.disconnect();
        SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)s));
        s.close();
    }

    public void testCache() throws Exception {
        Session s = TestCase.sessions.openSession();
        Immutable im = new Immutable();
        s.save(im);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.load(im, (Serializable)((Object)im.getId()));
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.load(im, (Serializable)((Object)im.getId()));
        this.assertTrue(s.find("from im in class cirrus.hibernate.test.Immutable where im = ?", im, Hibernate.association(class$cirrus$hibernate$test$Immutable == null ? (class$cirrus$hibernate$test$Immutable = FooBarTest.class$("cirrus.hibernate.test.Immutable")) : class$cirrus$hibernate$test$Immutable)).get(0) == im && im == s.load(class$cirrus$hibernate$test$Immutable == null ? (class$cirrus$hibernate$test$Immutable = FooBarTest.class$("cirrus.hibernate.test.Immutable")) : class$cirrus$hibernate$test$Immutable, (Serializable)((Object)im.getId())), "cached object identity");
        s.connection().createStatement().executeUpdate("delete from immut");
        s.connection().commit();
        s.close();
    }

    public void testFindLoad() throws Exception {
        Session s = TestCase.sessions.openSession();
        FooProxy foo = new Foo();
        s.save(foo);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        foo = (FooProxy)s.find("from foo in class cirrus.hibernate.test.Foo").get(0);
        FooProxy foo2 = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)foo.getKey()));
        this.assertTrue(foo == foo2, "find returns same object as load");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        foo2 = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)foo.getKey()));
        foo = (FooProxy)s.find("from foo in class cirrus.hibernate.test.Foo").get(0);
        this.assertTrue(foo == foo2, "find returns same object as load");
        s.delete("from foo in class cirrus.hibernate.test.Foo");
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testAutoFlush() throws Exception {
        Session s = TestCase.sessions.openSession();
        FooProxy foo = new Foo();
        s.save(foo);
        this.assertTrue(s.find("from foo in class cirrus.hibernate.test.Foo").size() == 1, "autoflush create");
        foo.setChar(new Character('X'));
        this.assertTrue(s.find("from foo in class cirrus.hibernate.test.Foo where foo.char='X'").size() == 1, "autoflush update");
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        foo = (FooProxy)s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, (Serializable)((Object)foo.getKey()));
        if (!(TestCase.dialect instanceof MySQLDialect || TestCase.dialect instanceof HSQLDialect || TestCase.dialect instanceof PointbaseDialect)) {
            foo.setBytes("osama".getBytes());
            this.assertTrue(s.find("from foo in class cirrus.hibernate.test.Foo where 111 in foo.bytes.elements").size() == 1, "autoflush collection update");
            foo.getBytes()[0] = 69;
            this.assertTrue(s.find("from foo in class cirrus.hibernate.test.Foo where 69 in foo.bytes.elements").size() == 1, "autoflush collection update");
        }
        s.delete(foo);
        this.assertTrue(s.find("from foo in class cirrus.hibernate.test.Foo").size() == 0, "autoflush delete");
        s.connection().commit();
        s.close();
    }

    public void testListIdentifiers() throws Exception {
        Session s = TestCase.sessions.openSession();
        Fum fum = new Fum(this.fumKey("fum"));
        fum.setFum("fo fee fi");
        s.save(fum);
        fum = new Fum(this.fumKey("fi"));
        fum.setFum("fee fi fo");
        s.save(fum);
        List list = s.findIdentifiers("from fum in class cirrus.hibernate.test.Fum where not fum.fum='FRIEND'");
        this.assertTrue(list.size() == 2, "list identifiers");
        Iterator iter = s.iterate("select fum.id from fum in class cirrus.hibernate.test.Fum where not fum.fum='FRIEND'");
        int i = 0;
        while (iter.hasNext()) {
            this.assertTrue(iter.next() instanceof FumCompositeID, "iterate identifiers");
            ++i;
        }
        Assert.assertTrue((i == 2 ? 1 : 0) != 0);
        s.delete(s.load(class$cirrus$hibernate$test$Fum == null ? (class$cirrus$hibernate$test$Fum = FooBarTest.class$("cirrus.hibernate.test.Fum")) : class$cirrus$hibernate$test$Fum, (Serializable)list.get(0)));
        s.delete(s.load(class$cirrus$hibernate$test$Fum == null ? (class$cirrus$hibernate$test$Fum = FooBarTest.class$("cirrus.hibernate.test.Fum")) : class$cirrus$hibernate$test$Fum, (Serializable)list.get(1)));
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testVeto() throws Exception {
        Session s = TestCase.sessions.openSession();
        Vetoer v = new Vetoer();
        s.save(v);
        Serializable id = s.save(v);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        s.update(v, id);
        s.update(v, id);
        s.delete(v);
        s.delete(v);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testSerializableType() throws Exception {
        Session s = TestCase.sessions.openSession();
        Vetoer v = new Vetoer();
        v.setStrings(new String[]{"foo", "bar", "baz"});
        s.save(v);
        Serializable id = s.save(v);
        v.getStrings()[1] = "osama";
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        v = (Vetoer)s.load(class$cirrus$hibernate$test$Vetoer == null ? (class$cirrus$hibernate$test$Vetoer = FooBarTest.class$("cirrus.hibernate.test.Vetoer")) : class$cirrus$hibernate$test$Vetoer, id);
        this.assertTrue(v.getStrings()[1].equals("osama"), "serializable type");
        s.delete(v);
        s.delete(v);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testAutoFlushCollections() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction tx = s.beginTransaction();
        Baz baz = new Baz();
        baz.setDefaults();
        s.save(baz);
        tx.commit();
        s.close();
        s = TestCase.sessions.openSession();
        tx = s.beginTransaction();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        baz.getStringArray()[0] = "bark";
        Iterator i = s.iterate("select baz.stringArray.elements from baz in class cirrus.hibernate.test.Baz");
        boolean found = false;
        while (i.hasNext()) {
            if (!"bark".equals(i.next())) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        baz.setStringArray(null);
        i = s.iterate("select distinct baz.stringArray.elements from baz in class cirrus.hibernate.test.Baz");
        Assert.assertTrue((!i.hasNext() ? 1 : 0) != 0);
        baz.setStringArray(new String[]{"foo", "bar"});
        i = s.iterate("select baz.stringArray.elements from baz in class cirrus.hibernate.test.Baz");
        Assert.assertTrue((boolean)i.hasNext());
        Foo foo = new Foo();
        s.save(foo);
        s.flush();
        baz.setFooArray(new Foo[]{foo});
        i = s.iterate("select foo from baz in class cirrus.hibernate.test.Baz, foo in baz.fooArray.elements");
        found = false;
        while (i.hasNext()) {
            if (foo != i.next()) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
        baz.getFooArray()[0] = null;
        i = s.iterate("select foo from baz in class cirrus.hibernate.test.Baz, foo in baz.fooArray.elements");
        Assert.assertTrue((!i.hasNext() ? 1 : 0) != 0);
        baz.getFooArray()[0] = foo;
        i = s.iterate("select baz.fooArray.elements from baz in class cirrus.hibernate.test.Baz");
        Assert.assertTrue((boolean)i.hasNext());
        if (!(TestCase.dialect instanceof MySQLDialect || TestCase.dialect instanceof HSQLDialect || TestCase.dialect instanceof InterbaseDialect || TestCase.dialect instanceof PointbaseDialect || TestCase.dialect instanceof SAPDBDialect)) {
            baz.getFooArray()[0] = null;
            i = s.iterate("from baz in class cirrus.hibernate.test.Baz where ? in baz.fooArray.elements", foo, Hibernate.association(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo));
            Assert.assertTrue((!i.hasNext() ? 1 : 0) != 0);
            baz.getFooArray()[0] = foo;
            i = s.iterate("select foo from foo in class cirrus.hibernate.test.Foo where foo in (select elt from baz in class cirrus.hibernate.test.Baz, elt in baz.fooArray.elements)");
            Assert.assertTrue((boolean)i.hasNext());
        }
        s.delete(foo);
        s.delete(baz);
        tx.commit();
        s.close();
    }

    public void testCompositeIDs() throws Exception {
        Session s = TestCase.sessions.openSession();
        Fo fo = new Fo();
        Properties props = new Properties();
        props.setProperty("foo", "bar");
        props.setProperty("bar", "foo");
        fo.setSerial(props);
        fo.setBuf("abcdefghij1`23%$*^*$*\n\t".getBytes());
        s.save(fo, this.fumKey("an instance of fo"));
        s.flush();
        props.setProperty("x", "y");
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        fo = (Fo)s.load(class$cirrus$hibernate$test$Fo == null ? (class$cirrus$hibernate$test$Fo = FooBarTest.class$("cirrus.hibernate.test.Fo")) : class$cirrus$hibernate$test$Fo, (Serializable)this.fumKey("an instance of fo"));
        props = (Properties)fo.getSerial();
        Assert.assertTrue((boolean)props.getProperty("foo").equals("bar"));
        Assert.assertTrue((boolean)props.getProperty("x").equals("y"));
        Assert.assertTrue((fo.getBuf()[0] == 97 ? 1 : 0) != 0);
        fo.getBuf()[1] = 126;
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        fo = (Fo)s.load(class$cirrus$hibernate$test$Fo == null ? (class$cirrus$hibernate$test$Fo = FooBarTest.class$("cirrus.hibernate.test.Fo")) : class$cirrus$hibernate$test$Fo, (Serializable)this.fumKey("an instance of fo"));
        Assert.assertTrue((fo.getBuf()[1] == 126 ? 1 : 0) != 0);
        Assert.assertTrue((s.iterate("from fo in class cirrus.hibernate.test.Fo where fo.id.string like 'an instance of fo'").next() == fo ? 1 : 0) != 0);
        s.delete(fo);
        s.flush();
        try {
            s.save(new Fo());
            Assert.assertTrue((boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        s.connection().commit();
        s.close();
    }

    public void testUserProvidedConnection() throws Exception {
        DriverManagerConnectionProvider dcp = new DriverManagerConnectionProvider();
        dcp.configure(Environment.getProperties());
        Session s = TestCase.sessions.openSession(dcp.getConnection());
        Transaction tx = s.beginTransaction();
        s.find("from foo in class cirrus.hibernate.test.Fo");
        tx.commit();
        Connection c = s.disconnect();
        Assert.assertTrue((c != null ? 1 : 0) != 0);
        s.reconnect(c);
        tx = s.beginTransaction();
        s.find("from foo in class cirrus.hibernate.test.Fo");
        tx.commit();
        Assert.assertTrue((s.close() != null ? 1 : 0) != 0);
        c.close();
    }

    public void testCachedCollection() throws Exception {
        Session s = TestCase.sessions.openSession();
        Baz baz = new Baz();
        baz.setDefaults();
        s.save(baz);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        ((FooComponent)baz.getTopComponents().get(0)).setCount(99);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        Assert.assertTrue((((FooComponent)baz.getTopComponents().get(0)).getCount() == 99 ? 1 : 0) != 0);
        s.delete(baz);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testComplicatedQuery() throws Exception {
        Foo foo;
        Session s = TestCase.sessions.openSession();
        Serializable id = s.save(foo = new Foo());
        Assert.assertTrue((id != null ? 1 : 0) != 0);
        Qux q = new Qux("q");
        foo.getDependent().setQux(q);
        s.save(q);
        q.getFoo().setString("foo2");
        Assert.assertTrue((boolean)s.iterate("from foo in class Foo where foo.dependent.qux.foo.string = 'foo2'").hasNext());
        s.delete(foo);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testLoadAfterDelete() throws Exception {
        Session s = TestCase.sessions.openSession();
        Foo foo = new Foo();
        Serializable id = s.save(foo);
        s.flush();
        s.delete(foo);
        boolean err = false;
        try {
            s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, id);
        }
        catch (ObjectDeletedException ode) {
            err = true;
        }
        Assert.assertTrue((boolean)err);
        s.flush();
        err = false;
        try {
            s.load(class$cirrus$hibernate$test$Foo == null ? (class$cirrus$hibernate$test$Foo = FooBarTest.class$("cirrus.hibernate.test.Foo")) : class$cirrus$hibernate$test$Foo, id);
        }
        catch (ObjectDeletedException ode) {
            err = true;
        }
        Assert.assertTrue((boolean)err);
        Fo fo = new Fo();
        id = this.fumKey("abc");
        s.save(fo, id);
        s.flush();
        s.delete(fo);
        err = false;
        try {
            s.load(class$cirrus$hibernate$test$Fo == null ? (class$cirrus$hibernate$test$Fo = FooBarTest.class$("cirrus.hibernate.test.Fo")) : class$cirrus$hibernate$test$Fo, id);
        }
        catch (ObjectDeletedException ode) {
            err = true;
        }
        Assert.assertTrue((boolean)err);
        s.flush();
        err = false;
        try {
            s.load(class$cirrus$hibernate$test$Fo == null ? (class$cirrus$hibernate$test$Fo = FooBarTest.class$("cirrus.hibernate.test.Fo")) : class$cirrus$hibernate$test$Fo, id);
        }
        catch (ObjectDeletedException ode) {
            err = true;
        }
        Assert.assertTrue((boolean)err);
        s.connection().commit();
        s.close();
    }

    public void testEmbeddedCompositeID() throws Exception {
        Session s = TestCase.sessions.openSession();
        Location l = new Location();
        l.setCountryCode("AU");
        l.setDescription("foo bar");
        l.setLocale(Locale.getDefault());
        l.setStreetName("Brunswick Rd");
        l.setStreetNumber(300);
        l.setCity("Melbourne");
        s.save(l);
        s.flush();
        s.connection().commit();
        s.close();
        s = TestCase.sessions.openSession();
        l = (Location)s.find("from l in class Location where l.countryCode = 'AU' and l.description='foo bar'").get(0);
        Assert.assertTrue((boolean)l.getCountryCode().equals("AU"));
        Assert.assertTrue((boolean)l.getCity().equals("Melbourne"));
        Assert.assertTrue((boolean)l.getLocale().equals(Locale.getDefault()));
        s.close();
        s = TestCase.sessions.openSession();
        l = new Location();
        l.setCountryCode("AU");
        l.setDescription("foo bar");
        l.setLocale(Locale.ENGLISH);
        l.setStreetName("Brunswick Rd");
        l.setStreetNumber(300);
        l.setCity("Melbourne");
        Assert.assertTrue((l == s.load(class$cirrus$hibernate$test$Location == null ? (class$cirrus$hibernate$test$Location = FooBarTest.class$("cirrus.hibernate.test.Location")) : class$cirrus$hibernate$test$Location, (Serializable)l) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)l.getLocale().equals(Locale.getDefault()));
        s.delete(l);
        s.flush();
        s.connection().commit();
        s.close();
    }

    public void testAutosaveChildren() throws Exception {
        Session s = TestCase.sessions.openSession();
        Transaction t = s.beginTransaction();
        Baz baz = new Baz();
        HashSet bars = new HashSet();
        baz.setCascadingBars(bars);
        s.save(baz);
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        baz.getCascadingBars().add(new Bar());
        baz.getCascadingBars().add(new Bar());
        t.commit();
        s.close();
        s = TestCase.sessions.openSession();
        t = s.beginTransaction();
        baz = (Baz)s.load(class$cirrus$hibernate$test$Baz == null ? (class$cirrus$hibernate$test$Baz = FooBarTest.class$("cirrus.hibernate.test.Baz")) : class$cirrus$hibernate$test$Baz, (Serializable)((Object)baz.getCode()));
        Assert.assertTrue((baz.getCascadingBars().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((baz.getCascadingBars().iterator().next() != null ? 1 : 0) != 0);
        s.delete(baz);
        t.commit();
        s.close();
    }

    public static Test suite() throws Exception {
        try {
            TestCase.exportSchema(new String[]{"FooBar.hbm.xml", "Baz.hbm.xml", "Qux.hbm.xml", "Glarch.hbm.xml", "Fum.hbm.xml", "Fumm.hbm.xml", "Fo.hbm.xml", "One.hbm.xml", "Many.hbm.xml", "Immutable.hbm.xml", "Fee.hbm.xml", "Vetoer.hbm.xml", "Holder.hbm.xml", "Location.hbm.xml", "Stuff.hbm.xml", "Container.hbm.xml", "Simple.hbm.xml"});
            return new TestSuite(class$cirrus$hibernate$test$FooBarTest == null ? (class$cirrus$hibernate$test$FooBarTest = FooBarTest.class$("cirrus.hibernate.test.FooBarTest")) : class$cirrus$hibernate$test$FooBarTest);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

