/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.query;

import cirrus.hibernate.Hibernate;
import cirrus.hibernate.QueryException;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.persister.Queryable;
import cirrus.hibernate.query.Parser;
import cirrus.hibernate.query.QueryTranslator;
import cirrus.hibernate.type.EntityType;
import cirrus.hibernate.type.PersistentCollectionType;
import cirrus.hibernate.type.Type;
import java.util.LinkedList;

public class PathExpressionParser
implements Parser {
    public static final String ENTITY_ID = "id";
    public static final String ENTITY_CLASS = "class";
    public static final String COLLECTION_SIZE = "size";
    public static final String COLLECTION_ELEMENTS = "elements";
    public static final String COLLECTION_INDICES = "indices";
    public static final String COLLECTION_MAX_INDEX = "maxIndex";
    public static final String COLLECTION_MIN_INDEX = "minIndex";
    public static final String COLLECTION_MAX_ELEMENT = "maxElement";
    public static final String COLLECTION_MIN_ELEMENT = "minElement";
    private int dotcount;
    protected String currentName;
    protected String currentProperty;
    protected StringBuffer join;
    protected String[] columns;
    protected String[] collectionElementColumns;
    private String collectionName;
    private String collectionRole;
    private String collectionTable;
    protected Type collectionElementType;
    private String componentPath;
    protected Type type;
    private String path;
    private boolean skippedId;
    private boolean continuation;
    private boolean expectingCollectionIndex;
    private LinkedList collectionElements = new LinkedList();

    private void addJoin(String name, String[] rhsCols, QueryTranslator q) throws QueryException {
        String[] lhsCols = this.currentColumns(q);
        int i = 0;
        while (i < rhsCols.length) {
            this.join.append(" and ").append(lhsCols[i]).append('=').append(name).append('.').append(rhsCols[i]);
            ++i;
        }
    }

    public String continueFromManyToMany(Class clazz, String[] joinColumns, QueryTranslator q) throws QueryException {
        this.start(q);
        this.continuation = true;
        this.currentName = q.createNameFor(clazz);
        q.addType(this.currentName, clazz.getName());
        int i = 0;
        while (i < joinColumns.length) {
            this.join.append(" and ").append(joinColumns[i]).append('=').append(this.currentName).append('.').append(q.getPersister(clazz).getIdentifierColumnNames()[i]);
            ++i;
        }
        return this.currentName;
    }

    public String continueFromSubcollection(String role, String[] joinColumns, QueryTranslator q) throws QueryException {
        this.start(q);
        this.continuation = true;
        this.collectionName = q.createNameForCollection(role);
        this.collectionRole = role;
        this.currentName = null;
        this.currentProperty = null;
        CollectionPersister p = q.getCollectionPersister(role);
        this.collectionTable = p.getQualifiedTableName();
        int i = 0;
        while (i < joinColumns.length) {
            this.join.append(" and ").append(joinColumns[i]).append('=').append(this.collectionName).append('.').append(p.getKeyColumnNames()[i]);
            ++i;
        }
        return this.collectionName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void token(String token, QueryTranslator q) throws QueryException {
        this.path = this.path + token;
        String alias = q.getPathAlias(this.path);
        if (alias != null) {
            this.reset();
            this.currentName = alias;
            this.join.append(q.getPathJoin(this.path));
            return;
        } else if (".".equals(token)) {
            ++this.dotcount;
            return;
        } else if (this.dotcount == 0) {
            if (this.continuation) return;
            if (!q.isName(token)) {
                throw new QueryException("undefined alias: " + token);
            }
            this.currentName = token;
            return;
        } else if (this.dotcount == 1) {
            if (this.currentName != null) {
                this.currentProperty = token;
                return;
            } else {
                if (this.collectionName == null) throw new QueryException("unexpected");
                CollectionPersister p = q.getCollectionPersister(this.collectionRole);
                this.doCollectionProperty(token, p, this.collectionName);
                this.continuation = false;
            }
            return;
        } else {
            Type propertyType = this.getPropertyType(q);
            if (propertyType == null) {
                throw new QueryException("unresolved property: " + this.currentProperty);
            }
            if (propertyType.isComponentType()) {
                this.componentPath = this.componentPath == null ? token : this.componentPath + '.' + token;
                return;
            } else if (propertyType.isEntityType()) {
                Class memberClass = ((EntityType)propertyType).getPersistentClass();
                Queryable memberPersister = q.getPersister(memberClass);
                if (ENTITY_ID.equals(token) || memberPersister.hasIdentifierProperty() && memberPersister.getIdentifierPropertyName().equals(token)) {
                    this.skippedId = true;
                } else {
                    String name = q.createNameFor(memberClass);
                    q.addType(name, memberClass.getName());
                    String[] keyColNames = memberPersister.getIdentifierColumnNames();
                    this.addJoin(name, keyColNames, q);
                    this.currentName = name;
                    this.currentProperty = token;
                    q.addPathAliasAndJoin(this.path.substring(0, this.path.lastIndexOf(46)), name, this.join.toString());
                }
                this.componentPath = null;
                return;
            } else if (propertyType.isPersistentCollectionType()) {
                this.collectionRole = ((PersistentCollectionType)propertyType).getRole();
                CollectionPersister p = q.getCollectionPersister(this.collectionRole);
                String[] colNames = p.getKeyColumnNames();
                String name = q.createNameForCollection(this.collectionRole);
                this.addJoin(name, colNames, q);
                this.doCollectionProperty(token, p, name);
                this.collectionName = name;
                this.collectionTable = p.getQualifiedTableName();
                this.currentName = null;
                this.currentProperty = null;
                this.componentPath = null;
                return;
            } else {
                if (token == null) return;
                throw new QueryException("dereferenced: " + this.currentProperty);
            }
        }
    }

    private String getPropertyPath() {
        if (this.currentProperty == null) {
            return ENTITY_ID;
        }
        return this.currentProperty + (this.skippedId ? ".id" : "") + (this.componentPath == null ? "" : '.' + this.componentPath);
    }

    private void setType(QueryTranslator q) throws QueryException {
        if (this.currentProperty == null) {
            Queryable p = q.getPersisterForName(this.currentName);
            this.type = Hibernate.association(p.getMappedClass());
        } else {
            this.type = this.getPropertyType(q);
        }
    }

    private Type getPropertyType(QueryTranslator q) throws QueryException {
        return q.getPersisterForName(this.currentName).getPropertyType(this.getPropertyPath());
    }

    protected String[] currentColumns(QueryTranslator q) throws QueryException {
        return q.getPersisterForName(this.currentName).toColumns(this.currentName, this.getPropertyPath());
    }

    private void reset() {
        this.join = new StringBuffer(50);
        this.dotcount = 0;
        this.currentName = null;
        this.currentProperty = null;
        this.collectionName = null;
        this.collectionRole = null;
        this.collectionTable = null;
        this.collectionElementColumns = null;
        this.collectionElementType = null;
        this.componentPath = null;
        this.type = null;
        this.collectionName = null;
        this.columns = null;
        this.expectingCollectionIndex = false;
        this.skippedId = false;
        this.continuation = false;
    }

    public void start(QueryTranslator q) {
        if (!this.continuation) {
            this.reset();
            this.path = "";
        }
    }

    public void end(QueryTranslator q) throws QueryException {
        if (this.isCollectionValued()) {
            this.columns = this.collectionElementColumns;
            this.type = this.collectionElementType;
        } else {
            Type propertyType;
            if (!this.continuation && (propertyType = this.getPropertyType(q)) != null && propertyType.isPersistentCollectionType()) {
                this.collectionRole = ((PersistentCollectionType)propertyType).getRole();
                this.collectionName = q.createNameForCollection(this.collectionRole);
            }
            if (this.collectionRole != null) {
                String[] indexCols;
                CollectionPersister memberPersister = q.getCollectionPersister(this.collectionRole);
                if (!memberPersister.hasIndex()) {
                    throw new QueryException("unindexed collection before []");
                }
                String[] keyCols = memberPersister.getKeyColumnNames();
                if (!this.continuation) {
                    this.addJoin(this.collectionName, keyCols, q);
                }
                if ((indexCols = memberPersister.getIndexColumnNames()).length != 1) {
                    throw new QueryException("composite-index appears in []");
                }
                this.join.append(" and ").append(this.collectionName).append('.').append(indexCols[0]).append("=");
                String[] eltCols = memberPersister.getElementColumnNames();
                CollectionElement elem = new CollectionElement();
                elem.elementColumns = StringHelper.prefix(eltCols, this.collectionName + '.');
                elem.type = memberPersister.getElementType();
                elem.isOneToMany = memberPersister.isOneToMany();
                elem.alias = this.collectionName;
                elem.join = this.join.toString();
                this.collectionElements.addLast(elem);
                this.setExpectingCollectionIndex();
                q.addCollection(this.collectionName, this.collectionRole);
            } else {
                this.columns = this.currentColumns(q);
                this.setType(q);
            }
        }
        this.continuation = false;
    }

    public CollectionElement lastCollectionElement() {
        return (CollectionElement)this.collectionElements.removeLast();
    }

    public void setLastCollectionElementIndexValue(String value) {
        ((CollectionElement)this.collectionElements.getLast()).indexValue.append(value);
    }

    public boolean isExpectingCollectionIndex() {
        return this.expectingCollectionIndex;
    }

    protected void setExpectingCollectionIndex() throws QueryException {
        this.expectingCollectionIndex = true;
    }

    public String getWhereJoin() {
        return this.join.toString();
    }

    public String getWhereColumn() throws QueryException {
        if (this.columns.length != 1) {
            throw new QueryException("path expression ends in a composite value");
        }
        return this.columns[0];
    }

    public String[] getWhereColumns() {
        return this.columns;
    }

    public Type getWhereColumnType() {
        return this.type;
    }

    public String getCollectionSubquery(String extraJoin) throws QueryException {
        if (extraJoin != null) {
            this.join.append(extraJoin);
        }
        return "SELECT " + StringHelper.join(", ", this.collectionElementColumns) + " FROM " + this.collectionTable + ' ' + this.collectionName + " WHERE " + this.join.substring(5).toString();
    }

    public boolean isCollectionValued() {
        return this.collectionElementColumns != null;
    }

    public void addFromCollection(QueryTranslator q, String elementName) throws QueryException {
        if (!this.collectionElementType.isEntityType()) {
            throw new QueryException("collection of values in from clause: " + elementName);
        }
        EntityType elemType = (EntityType)this.collectionElementType;
        q.addFromType(elementName, elemType.getPersistentClass().getName());
        CollectionPersister persister = q.getCollectionPersister(this.collectionRole);
        if (persister.isOneToMany()) {
            q.addJoin(StringHelper.replace(this.join.toString(), this.collectionName, elementName));
        } else {
            q.addCollection(this.collectionName, this.collectionRole);
            String[] keyColumnNames = q.getPersisterForName(elementName).getIdentifierColumnNames();
            int i = 0;
            while (i < keyColumnNames.length) {
                this.join.append(" and ").append(this.collectionElementColumns[i]).append('=').append(elementName).append('.').append(keyColumnNames[i]);
                ++i;
            }
            q.addJoin(this.join.toString());
        }
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getCollectionRole() {
        return this.collectionRole;
    }

    public String getCollectionTable() {
        return this.collectionTable;
    }

    private void doCollectionProperty(String token, CollectionPersister memberPersister, String name) throws QueryException {
        if (token.equals(COLLECTION_ELEMENTS)) {
            String[] cols = memberPersister.getElementColumnNames();
            this.collectionElementColumns = StringHelper.prefix(cols, name + '.');
            this.collectionElementType = memberPersister.getElementType();
        } else if (token.equals(COLLECTION_INDICES)) {
            if (!memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .indices");
            }
            String[] cols = memberPersister.getIndexColumnNames();
            this.collectionElementColumns = StringHelper.prefix(cols, name + '.');
            this.collectionElementType = memberPersister.getIndexType();
        } else if (token.equals(COLLECTION_SIZE)) {
            this.collectionElementColumns = new String[]{"count(*)"};
            this.collectionElementType = Hibernate.INTEGER;
        } else if (token.equals(COLLECTION_MAX_INDEX)) {
            if (!memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .maxIndex");
            }
            String[] cols = memberPersister.getIndexColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection index in maxIndex");
            }
            this.collectionElementColumns = new String[]{"max(" + cols[0] + ")"};
            this.collectionElementType = memberPersister.getIndexType();
        } else if (token.equals(COLLECTION_MIN_INDEX)) {
            if (!memberPersister.hasIndex()) {
                throw new QueryException("unindexed collection before .minIndex");
            }
            String[] cols = memberPersister.getIndexColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection index in minIndex");
            }
            this.collectionElementColumns = new String[]{"min(" + cols[0] + ")"};
            this.collectionElementType = memberPersister.getIndexType();
        } else if (token.equals(COLLECTION_MAX_ELEMENT)) {
            String[] cols = memberPersister.getElementColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection element in maxElement");
            }
            this.collectionElementColumns = new String[]{"max(" + cols[0] + ")"};
            this.collectionElementType = memberPersister.getElementType();
        } else if (token.equals(COLLECTION_MIN_ELEMENT)) {
            String[] cols = memberPersister.getElementColumnNames();
            if (cols.length != 1) {
                throw new QueryException("composite collection element in minElement");
            }
            this.collectionElementColumns = new String[]{"min(" + cols[0] + ")"};
            this.collectionElementType = memberPersister.getElementType();
        } else {
            throw new QueryException("expecting 'elements' or 'indices' after " + this.currentProperty + '.');
        }
    }

    static final class CollectionElement {
        Type type;
        boolean isOneToMany;
        String alias;
        String[] elementColumns;
        String join;
        StringBuffer indexValue = new StringBuffer();

        CollectionElement() {
        }
    }
}

