/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.persister;

import cirrus.hibernate.Environment;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.InstantiationException;
import cirrus.hibernate.MappingException;
import cirrus.hibernate.QueryException;
import cirrus.hibernate.StaleObjectStateException;
import cirrus.hibernate.cache.CacheConcurrencyStrategy;
import cirrus.hibernate.engine.Cascades;
import cirrus.hibernate.engine.SessionFactoryImplementor;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.id.IdentifierGenerator;
import cirrus.hibernate.id.NativeGenerator;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.Component;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.Property;
import cirrus.hibernate.map.Subclass;
import cirrus.hibernate.map.Value;
import cirrus.hibernate.metadata.ClassMetadata;
import cirrus.hibernate.persister.Queryable;
import cirrus.hibernate.sql.Dialect;
import cirrus.hibernate.type.AbstractComponentType;
import cirrus.hibernate.type.IdentifierType;
import cirrus.hibernate.type.Type;
import cirrus.hibernate.type.TypeFactory;
import cirrus.hibernate.type.VersionType;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractEntityPersister
implements Queryable,
ClassMetadata {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$persister$AbstractEntityPersister == null ? (class$cirrus$hibernate$persister$AbstractEntityPersister = AbstractEntityPersister.class$("cirrus.hibernate.persister.AbstractEntityPersister")) : class$cirrus$hibernate$persister$AbstractEntityPersister));
    protected static final Class[] NO_CLASSES = new Class[0];
    private final Class mappedClass;
    protected final transient Dialect dialect;
    private final transient Constructor constructor;
    private final transient IdentifierGenerator idgen;
    private final transient boolean polymorphic;
    private final transient boolean explicitPolymorphism;
    private final transient boolean inherited;
    private final transient boolean hasSubclasses;
    private final transient boolean versioned;
    private final transient boolean abstractClass;
    private final transient boolean implementsLifecycle;
    private final transient boolean implementsValidatable;
    private final transient boolean hasCollections;
    private final transient boolean hasCascades;
    private final transient boolean mutable;
    private final transient boolean useIdentityColumn;
    private final transient Class superclass;
    private final transient String identitySelectString;
    private final transient Class[] proxyInterfaces;
    private final transient Class concreteProxyClass;
    private final transient boolean hasProxy;
    private final transient boolean hasEmbeddedIdentifier;
    private final transient String[] identifierColumnNames;
    private final transient Cascades.IdentifierValue unsavedIdentifierValue;
    private final transient HashMap idTypesByPropertyPath = new HashMap();
    private final transient HashMap idColumnNamesByPropertyPath = new HashMap();
    protected final transient HashMap columnNamesByPropertyPath = new HashMap();
    protected final transient HashMap typesByPropertyPath = new HashMap();
    private final transient String identifierPropertyName;
    private final transient Type identifierType;
    private final transient ReflectHelper.Setter identifierSetter;
    private final transient ReflectHelper.Getter identifierGetter;
    private final transient Method proxyGetIdentifierMethod;
    private final transient String[] propertyNames;
    private final transient Type[] propertyTypes;
    private final transient String versionPropertyName;
    private final transient String versionColumnName;
    private final transient VersionType versionType;
    private final transient ReflectHelper.Getter versionGetter;
    private final transient int versionProperty;
    private final transient ReflectHelper.Getter[] getters;
    private final transient ReflectHelper.Setter[] setters;
    protected final transient int hydrateSpan;
    private final transient String className;
    private final transient Cascades.CascadeStyle[] cascadeStyles;
    private final transient CacheConcurrencyStrategy cache;
    static /* synthetic */ Class class$cirrus$hibernate$persister$AbstractEntityPersister;
    static /* synthetic */ Class class$cirrus$hibernate$Lifecycle;
    static /* synthetic */ Class class$cirrus$hibernate$Validatable;
    static /* synthetic */ Class class$cirrus$hibernate$proxy$HibernateProxy;

    public final Class getMappedClass() {
        return this.mappedClass;
    }

    public final String getClassName() {
        return this.className;
    }

    public String selectIdentifierString(String name, String suffix) {
        String[] cols = this.getIdentifierColumnNames();
        StringBuffer buf = new StringBuffer(15);
        int i = 0;
        while (i < cols.length) {
            buf.append(name).append('.').append(cols[i]).append(" as ").append(AbstractEntityPersister.aliasColumn(cols[i], suffix));
            if (i != cols.length - 1) {
                buf.append(", ");
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] toColumns(String name, String path) throws QueryException {
        String[] cols;
        if (path.equals("class")) {
            cols = new String[]{this.getDiscriminatorColumnName()};
            return StringHelper.prefix(cols, name + '.');
        } else {
            String idprop = this.getIdentifierPropertyName();
            if ("id".equals(path) || idprop != null && path.equals(idprop)) {
                cols = this.getIdentifierColumnNames();
                return StringHelper.prefix(cols, name + '.');
            } else {
                if (!path.startsWith("id.") && (idprop == null || !path.startsWith(idprop + '.'))) return null;
                int loc = path.indexOf(".");
                String componentPath = path.substring(loc + 1);
                if (!this.getIdentifierType().isComponentType()) throw new QueryException("unresolved id property: " + path);
                cols = this.getIdentifierPropertyColumnNames(componentPath);
            }
        }
        return StringHelper.prefix(cols, name + '.');
    }

    public Type getPropertyType(String path) {
        if (path.equals("class")) {
            return this.getDiscriminatorType();
        }
        String idprop = this.getIdentifierPropertyName();
        if ("id".equals(path) || idprop != null && path.equals(idprop)) {
            return this.getIdentifierType();
        }
        if (path.startsWith("id.") || idprop != null && path.startsWith(idprop + '.')) {
            return this.getIdentifierPropertyType(path.substring("id".length() + 1));
        }
        return (Type)this.typesByPropertyPath.get(path);
    }

    public Cascades.CascadeStyle[] getPropertyCascadeStyles() {
        return this.cascadeStyles;
    }

    public void setPropertyValues(Object object, Object[] values) throws HibernateException {
        int j = 0;
        while (j < this.hydrateSpan) {
            this.getSetters()[j].set(object, values[j]);
            ++j;
        }
    }

    public Object[] getPropertyValues(Object object) throws HibernateException {
        Object[] result = new Object[this.hydrateSpan];
        int j = 0;
        while (j < this.hydrateSpan) {
            result[j] = this.getGetters()[j].get(object);
            ++j;
        }
        return result;
    }

    public Object getPropertyValue(Object object, int i) throws HibernateException {
        return this.getGetters()[i].get(object);
    }

    public void setPropertyValue(Object object, int i, Object value) throws HibernateException {
        this.getSetters()[i].set(object, value);
    }

    public int[] findDirty(Object[] x, Object[] y, Object owner, SessionImplementor session) throws HibernateException {
        int[] props = TypeFactory.findDirty(this.propertyTypes, x, y, owner, session.getFactory());
        if (props == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            int i = 0;
            while (i < props.length) {
                log.trace((Object)(this.className + '.' + this.propertyNames[props[i]] + " is dirty"));
                ++i;
            }
        }
        return props;
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        Object id;
        if (this.hasEmbeddedIdentifier) {
            id = object;
        } else {
            if (this.identifierGetter == null) {
                throw new HibernateException("The class has no identifier property: " + this.className);
            }
            id = this.identifierGetter.get(object);
        }
        try {
            return (Serializable)id;
        }
        catch (ClassCastException cce) {
            throw new ClassCastException("Identifier classes must be serializable: " + cce.getMessage());
        }
    }

    public Object getVersion(Object object) throws HibernateException {
        if (!this.versioned) {
            return null;
        }
        return this.versionGetter.get(object);
    }

    public void setIdentifier(Object object, Serializable id) throws HibernateException {
        if (this.identifierSetter != null) {
            this.identifierSetter.set(object, id);
        }
    }

    public Object instantiate(Serializable id) throws HibernateException {
        if (this.hasEmbeddedIdentifier) {
            return id;
        }
        if (this.abstractClass) {
            throw new HibernateException("Cannot instantiate abstract class or interface: " + this.className);
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity ", this.mappedClass, e);
        }
    }

    protected ReflectHelper.Setter[] getSetters() {
        return this.setters;
    }

    protected ReflectHelper.Getter[] getGetters() {
        return this.getters;
    }

    public Type[] getPropertyTypes() {
        return this.propertyTypes;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public String[] getIdentifierColumnNames() {
        return this.identifierColumnNames;
    }

    public boolean isPolymorphic() {
        return this.polymorphic;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean hasCompositeKey() {
        return this.identifierColumnNames.length > 1;
    }

    public boolean hasCascades() {
        return this.hasCascades;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.cache;
    }

    public boolean hasIdentifierProperty() {
        return this.identifierGetter != null;
    }

    public Method getProxyGetIdentifierMethod() {
        return this.proxyGetIdentifierMethod;
    }

    public VersionType getVersionType() {
        return this.versionType;
    }

    public int getVersionProperty() {
        return this.versionProperty;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isIdentifierAssignedByInsert() {
        return this.useIdentityColumn;
    }

    public boolean isUnsaved(Serializable id) {
        return this.unsavedIdentifierValue.isUnsaved(id);
    }

    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    public String getIdentifierPropertyName() {
        return this.identifierPropertyName;
    }

    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    public final String[] getIdentifierPropertyColumnNames(String path) {
        return (String[])this.idColumnNamesByPropertyPath.get(path);
    }

    public final Type getIdentifierPropertyType(String path) {
        return (Type)this.idTypesByPropertyPath.get(path);
    }

    public final String[] getPropertyColumnNames(String path) {
        return (String[])this.columnNamesByPropertyPath.get(path);
    }

    public boolean implementsLifecycle() {
        return this.implementsLifecycle;
    }

    public boolean implementsValidatable() {
        return this.implementsValidatable;
    }

    public boolean hasCollections() {
        return this.hasCollections;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean hasCache() {
        return this.cache != null;
    }

    public boolean hasSubclasses() {
        return this.hasSubclasses;
    }

    public Class[] getProxyInterfaces() {
        return this.proxyInterfaces;
    }

    public boolean hasProxy() {
        return this.hasProxy;
    }

    protected final String sqlIdentitySelect() {
        return this.identitySelectString;
    }

    public IdentifierGenerator getIdentifierGenerator() throws HibernateException {
        if (this.idgen == null) {
            throw new HibernateException("No ID Generator is configured for class " + this.className + " (Try using insert() with an assigned ID)");
        }
        return this.idgen;
    }

    protected void check(int rows, Serializable id) throws HibernateException {
        if (rows < 1) {
            throw new StaleObjectStateException(this.getMappedClass(), id);
        }
        if (rows > 1) {
            throw new HibernateException("Duplicate identifier in table for " + this.getClassName() + ": " + id);
        }
    }

    protected AbstractEntityPersister(PersistentClass model, SessionFactoryImplementor factory) throws MappingException {
        this.dialect = factory.getDialect();
        this.className = model.getPersistentClass().getName();
        this.mappedClass = model.getPersistentClass();
        this.mutable = model.isMutable();
        this.polymorphic = model.isPolymorphic();
        this.explicitPolymorphism = model.isExplicitPolymorphism();
        this.inherited = model.isInherited();
        this.superclass = this.inherited ? model.getSuperclass().getPersistentClass() : null;
        this.hasSubclasses = model.hasSubclasses();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
        this.abstractClass = ReflectHelper.isAbstractClass(this.mappedClass);
        this.hasEmbeddedIdentifier = model.hasEmbeddedIdentifier();
        this.identifierPropertyName = model.hasIdentifierProperty() ? model.getIdentifierProperty().getName() : null;
        this.idgen = model.getIdentifier().getIdentifierGenerator();
        Value idValue = model.getIdentifier();
        this.identifierType = idValue.getType();
        if (this.identifierPropertyName != null) {
            this.identifierSetter = ReflectHelper.getSetter(this.mappedClass, this.identifierPropertyName);
            this.identifierGetter = ReflectHelper.getGetter(this.mappedClass, this.identifierPropertyName);
            Method proxyGetter = this.identifierGetter.getMethod();
            try {
                proxyGetter = ReflectHelper.getGetter(model.getProxyInterface(), this.identifierPropertyName).getMethod();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.proxyGetIdentifierMethod = proxyGetter;
        } else {
            this.identifierGetter = null;
            this.identifierSetter = null;
            this.proxyGetIdentifierMethod = null;
        }
        int m = 0;
        Iterator iter = model.getPropertyClosureIterator();
        while (iter.hasNext()) {
            ++m;
            iter.next();
        }
        this.hydrateSpan = m;
        int idColumnSpan = model.getIdentifier().getColumnSpan();
        this.identifierColumnNames = new String[idColumnSpan];
        iter = idValue.getColumnIterator();
        int i = 0;
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            this.identifierColumnNames[i] = col.getName();
            ++i;
        }
        if (idValue.isComposite()) {
            iter = ((Component)idValue).getPropertyIterator();
            while (iter.hasNext()) {
                Property prop = (Property)iter.next();
                this.idTypesByPropertyPath.put(prop.getName(), prop.getType());
                String[] cols = new String[prop.getColumnSpan()];
                Iterator colIter = prop.getColumnIterator();
                int j = 0;
                while (colIter.hasNext()) {
                    Column col = (Column)colIter.next();
                    cols[j++] = col.getName();
                }
                this.idColumnNamesByPropertyPath.put(prop.getName(), cols);
                if (!model.hasEmbeddedIdentifier()) continue;
                this.columnNamesByPropertyPath.put(prop.getName(), cols);
                this.typesByPropertyPath.put(prop.getName(), prop.getType());
            }
        }
        IdentifierGenerator idgen = model.getIdentifier().getIdentifierGenerator();
        this.useIdentityColumn = this.dialect.supportsIdentityColumns() && idgen instanceof NativeGenerator;
        this.identitySelectString = this.useIdentityColumn ? this.dialect.getIdentitySelectString() : null;
        String cts = model.getIdentifier().getNullValue();
        if (cts == null || "any".equals(cts)) {
            this.unsavedIdentifierValue = Cascades.SAVE_ANY;
        } else if ("none".equals(cts)) {
            this.unsavedIdentifierValue = Cascades.SAVE_NONE;
        } else if ("null".equals(cts)) {
            this.unsavedIdentifierValue = Cascades.SAVE_NULL;
        } else {
            try {
                this.unsavedIdentifierValue = new Cascades.IdentifierValue(((IdentifierType)model.getIdentifier().getType()).stringToObject(cts));
            }
            catch (ClassCastException cce) {
                throw new MappingException("Bad identifier type: " + model.getIdentifier().getType().getClass().getName());
            }
            catch (Exception e) {
                throw new MappingException("Could not parse unsaved-value: " + cts);
            }
        }
        this.versionColumnName = model.isVersioned() ? ((Column)model.getVersion().getColumnIterator().next()).getName() : null;
        if (model.isVersioned()) {
            this.versionPropertyName = model.getVersion().getName();
            this.versioned = true;
            this.versionGetter = ReflectHelper.getGetter(this.mappedClass, this.versionPropertyName);
            this.versionType = (VersionType)model.getVersion().getType();
        } else {
            this.versionPropertyName = null;
            this.versioned = false;
            this.versionType = null;
            this.versionGetter = null;
        }
        this.propertyTypes = new Type[this.hydrateSpan];
        this.propertyNames = new String[this.hydrateSpan];
        this.getters = new ReflectHelper.Getter[this.hydrateSpan];
        this.setters = new ReflectHelper.Setter[this.hydrateSpan];
        this.cascadeStyles = new Cascades.CascadeStyle[this.hydrateSpan];
        iter = model.getPropertyClosureIterator();
        i = 0;
        int tempVersionProperty = -66;
        boolean foundCascade = false;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop == model.getVersion()) {
                tempVersionProperty = i;
            }
            this.propertyNames[i] = prop.getName();
            this.getters[i] = ReflectHelper.getGetter(this.mappedClass, this.propertyNames[i]);
            this.setters[i] = ReflectHelper.getSetter(this.mappedClass, this.propertyNames[i]);
            this.propertyTypes[i] = prop.getType();
            this.cascadeStyles[i] = prop.cascade();
            if (this.cascadeStyles[i] != Cascades.STYLE_NONE) {
                foundCascade = true;
            }
            ++i;
        }
        this.hasCascades = foundCascade;
        this.versionProperty = tempVersionProperty;
        this.implementsLifecycle = (class$cirrus$hibernate$Lifecycle == null ? (class$cirrus$hibernate$Lifecycle = AbstractEntityPersister.class$("cirrus.hibernate.Lifecycle")) : class$cirrus$hibernate$Lifecycle).isAssignableFrom(this.mappedClass);
        this.implementsValidatable = (class$cirrus$hibernate$Validatable == null ? (class$cirrus$hibernate$Validatable = AbstractEntityPersister.class$("cirrus.hibernate.Validatable")) : class$cirrus$hibernate$Validatable).isAssignableFrom(this.mappedClass);
        this.cache = model.getCache();
        this.hasCollections = this.initHasCollections();
        Class pi = model.getProxyInterface();
        this.hasProxy = pi != null && Environment.jvmSupportsProxies();
        HashSet<Class> pis = new HashSet<Class>();
        pis.add(class$cirrus$hibernate$proxy$HibernateProxy == null ? (class$cirrus$hibernate$proxy$HibernateProxy = AbstractEntityPersister.class$("cirrus.hibernate.proxy.HibernateProxy")) : class$cirrus$hibernate$proxy$HibernateProxy);
        if (!this.mappedClass.equals(pi)) {
            pis.add(pi);
        }
        this.concreteProxyClass = pi;
        if (this.hasProxy) {
            iter = model.getSubclassIterator();
            while (iter.hasNext()) {
                Subclass sc = (Subclass)iter.next();
                pi = sc.getProxyInterface();
                if (pi == null) {
                    throw new MappingException("All subclasses must also have proxies: " + this.mappedClass.getName());
                }
                if (sc.getPersistentClass().equals(pi)) continue;
                pis.add(pi);
            }
        }
        this.proxyInterfaces = pis.toArray(NO_CLASSES);
    }

    private boolean initHasCollections() {
        return this.initHasCollections(this.propertyTypes);
    }

    private boolean initHasCollections(Type[] types) {
        int i = 0;
        while (i < types.length) {
            if (types[i].isPersistentCollectionType()) {
                return true;
            }
            if (types[i].isComponentType() && this.initHasCollections(((AbstractComponentType)types[i]).getSubtypes())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ClassMetadata getClassMetadata() {
        return this;
    }

    public Class getConcreteProxyClass() {
        return this.concreteProxyClass;
    }

    protected static String aliasColumn(String name, String suffix) {
        boolean nameEscaped;
        char quote = name.charAt(0);
        boolean bl = nameEscaped = "`\"".indexOf(quote) > -1;
        if (nameEscaped) {
            name = name.substring(1, name.length() - 1);
        }
        StringBuffer aliasBuilder = new StringBuffer(name.length());
        if (nameEscaped) {
            aliasBuilder.append(quote);
        }
        aliasBuilder.append(name);
        aliasBuilder.append(suffix);
        if (nameEscaped) {
            aliasBuilder.append(quote);
        }
        return aliasBuilder.toString();
    }

    public Class getMappedSuperclass() {
        return this.superclass;
    }

    public boolean isExplicitPolymorphism() {
        return this.explicitPolymorphism;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

