/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.engine.Mapping;
import cirrus.hibernate.id.Assigned;
import cirrus.hibernate.id.IdentifierGenerator;
import cirrus.hibernate.id.NativeGenerator;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.ForeignKey;
import cirrus.hibernate.map.Index;
import cirrus.hibernate.map.PrimaryKey;
import cirrus.hibernate.map.RelationalModel;
import cirrus.hibernate.map.UniqueKey;
import cirrus.hibernate.sql.Dialect;
import cirrus.hibernate.sql.HSQLDialect;
import cirrus.hibernate.tools.updater.JdbcColumnInfo;
import cirrus.hibernate.tools.updater.JdbcTableInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.SequencedHashMap;

public class Table
implements RelationalModel {
    private String name;
    private String schema;
    private Map columns = new SequencedHashMap();
    private IdentifierGenerator identifierGenerator = Assigned.INSTANCE;
    private PrimaryKey primaryKey;
    private Map indexes = new HashMap();
    private Map foreignKeys = new HashMap();
    private Map uniqueKeys = new HashMap();
    private final int uniqueInteger = tableCounter++;
    private static int tableCounter = 0;

    public String getQualifiedName() {
        return this.schema == null ? this.name : this.schema + '.' + this.name;
    }

    public String getQualifiedName(String defaultQualifier) {
        return this.schema == null ? (defaultQualifier == null ? this.name : defaultQualifier + '.' + this.name) : this.getQualifiedName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Column getColumn(int n) {
        Iterator iter = this.columns.values().iterator();
        int i = 0;
        while (i < n - 1) {
            iter.next();
            ++i;
        }
        return (Column)iter.next();
    }

    public void addColumn(Column column) {
        if (this.columns.get(column.getName()) == null) {
            this.columns.put(column.getName(), column);
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator columnIterator() {
        return this.columns.values().iterator();
    }

    public Iterator indexIterator() {
        return this.indexes.values().iterator();
    }

    public Iterator foreignKeyIterator() {
        return this.foreignKeys.values().iterator();
    }

    public Iterator uniqueKeyIterator() {
        return this.uniqueKeys.values().iterator();
    }

    public String sqlAlterString(Dialect dialect, Mapping p, JdbcTableInfo tableInfo) throws HibernateException {
        Iterator iter = this.columnIterator();
        StringBuffer buf = new StringBuffer(50);
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            JdbcColumnInfo columnInfo = tableInfo.getColumnInfo(col.getName());
            if (columnInfo != null) continue;
            if (buf.length() != 0) {
                buf.append(", ");
            }
            buf.append(col.getName()).append(' ').append(col.getSqlType(dialect, p));
            if (!col.isUnique() || !dialect.supportsUnique()) continue;
            buf.append(" unique");
        }
        if (buf.length() == 0) {
            return null;
        }
        return "alter table " + this.getQualifiedName() + " add " + buf;
    }

    public String sqlCreateString(Dialect dialect, Mapping p) throws HibernateException {
        boolean createIdentity;
        StringBuffer buf = new StringBuffer("create table ").append(this.getQualifiedName()).append(" (");
        String pkname = null;
        if (this.primaryKey != null) {
            createIdentity = dialect.supportsIdentityColumns() && this.identifierGenerator instanceof NativeGenerator;
            pkname = ((Column)this.primaryKey.getColumnIterator().next()).getName();
        } else {
            createIdentity = false;
        }
        Iterator iter = this.columnIterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            buf.append(col.getName()).append(' ').append(col.getSqlType(dialect, p));
            if (createIdentity && col.getName().equals(pkname)) {
                buf.append(' ').append(dialect.getIdentityColumnString());
            } else if (col.isNullable()) {
                buf.append(dialect.getNullColumnString());
            } else {
                buf.append(" not null");
            }
            if (col.isUnique() && dialect.supportsUnique()) {
                buf.append(" unique");
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (!(this.primaryKey == null || dialect instanceof HSQLDialect && this.identifierGenerator instanceof NativeGenerator)) {
            buf.append(',').append(this.primaryKey.sqlConstraintString(dialect));
        }
        if (dialect.supportsUnique()) {
            Iterator ukiter = this.uniqueKeyIterator();
            while (ukiter.hasNext()) {
                UniqueKey uk = (UniqueKey)ukiter.next();
                buf.append(',').append(uk.sqlConstraintString(dialect));
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public String sqlDropString(Dialect dialect) {
        return "drop table " + this.getQualifiedName() + dialect.getCascadeConstraintsString();
    }

    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    public void setIdentifierGenerator(IdentifierGenerator identifierGenerator) {
        this.identifierGenerator = identifierGenerator;
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Index getIndex(String name) {
        Index index = (Index)this.indexes.get(name);
        if (index == null) {
            index = new Index();
            index.setName(name);
            index.setTable(this);
            this.indexes.put(name, index);
        }
        return index;
    }

    public UniqueKey getUniqueKey(String name) {
        UniqueKey uk = (UniqueKey)this.uniqueKeys.get(name);
        if (uk == null) {
            uk = new UniqueKey();
            uk.setName(name);
            uk.setTable(this);
            this.uniqueKeys.put(name, uk);
        }
        return uk;
    }

    public ForeignKey createForeignKey(List columns) {
        String name = "FK" + this.uniqueColumnString(columns.iterator());
        ForeignKey fk = (ForeignKey)this.foreignKeys.get(name);
        if (fk == null) {
            fk = new ForeignKey();
            fk.setName(name);
            fk.setTable(this);
            this.foreignKeys.put(name, fk);
        }
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            fk.addColumn((Column)iter.next());
        }
        return fk;
    }

    public String uniqueColumnString(Iterator iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            result += iterator.next().hashCode();
        }
        return (Integer.toHexString(this.name.hashCode()) + Integer.toHexString(result)).toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public int getUniqueInteger() {
        return this.uniqueInteger;
    }
}

