/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.MappingException;
import cirrus.hibernate.helpers.ReflectHelper;
import cirrus.hibernate.map.Component;
import cirrus.hibernate.map.IndexedCollection;
import cirrus.hibernate.map.ManyToOne;
import cirrus.hibernate.map.PersistentClass;
import cirrus.hibernate.map.Root;
import cirrus.hibernate.map.Value;
import cirrus.hibernate.type.PersistentCollectionType;
import cirrus.hibernate.type.TypeFactory;
import java.util.Comparator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Map
extends IndexedCollection {
    private final boolean sorted;
    private Comparator comparator;
    private boolean doneSecondPass;
    static /* synthetic */ Class class$cirrus$hibernate$collections$SortedMap;
    static /* synthetic */ Class class$cirrus$hibernate$collections$Map;

    public Map(Node node, String prefix, PersistentClass owner, Root root) throws MappingException {
        super(node, prefix, owner, root);
        Node sortedAtt = node.getAttributes().getNamedItem("sort");
        if (sortedAtt == null || sortedAtt.getNodeValue().equals("unsorted")) {
            this.sorted = false;
        } else {
            this.sorted = true;
            String className = sortedAtt.getNodeValue();
            if (!className.equals("natural")) {
                try {
                    this.comparator = (Comparator)ReflectHelper.classForName(className).newInstance();
                }
                catch (Exception e) {
                    throw new MappingException("Could not instantiate comparator class: " + className);
                }
            }
        }
    }

    public void secondPassCompile(java.util.Map classes) throws MappingException {
        super.secondPassCompile(classes);
        if (this.doneSecondPass) {
            return;
        }
        NodeList list = this.node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node subnode = list.item(i);
            String name = subnode.getNodeName();
            if ("index".equals(name)) {
                this.setIndex(new Value(subnode, null, "idx", this.isOneToMany(), this.getTable(), this.root));
                if (this.getIndex().getType() == null) {
                    throw new MappingException("map index element must specify a type");
                }
            } else if ("index-many-to-many".equals(name)) {
                this.setIndex(new ManyToOne(subnode, null, "idx", this.isOneToMany(), this.getTable(), this.root));
            } else if ("composite-index".equals(name)) {
                this.setIndex(new Component(subnode, null, "", null, this.isOneToMany(), this.getTable(), this.root));
            }
            ++i;
        }
        if (!this.isReadOnly()) {
            this.getIndex().createForeignKeys(this.root, this.getTable());
        }
        if (!this.isOneToMany()) {
            this.createPrimaryKey();
        }
        this.doneSecondPass = true;
    }

    public PersistentCollectionType getType() {
        return this.sorted ? TypeFactory.sortedMap(this.getRole(), !this.isToplevel(), this.comparator) : TypeFactory.map(this.getRole(), !this.isToplevel());
    }

    public Class wrapperClass() {
        Class clazz = this.sorted ? (class$cirrus$hibernate$collections$SortedMap == null ? (class$cirrus$hibernate$collections$SortedMap = Map.class$("cirrus.hibernate.collections.SortedMap")) : class$cirrus$hibernate$collections$SortedMap) : (class$cirrus$hibernate$collections$Map == null ? (class$cirrus$hibernate$collections$Map = Map.class$("cirrus.hibernate.collections.Map")) : class$cirrus$hibernate$collections$Map);
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

