/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.map;

import cirrus.hibernate.MappingException;
import cirrus.hibernate.map.Column;
import cirrus.hibernate.map.Constraint;
import cirrus.hibernate.map.Table;
import cirrus.hibernate.sql.Dialect;
import java.util.Iterator;

public class ForeignKey
extends Constraint {
    private Table referencedTable;
    private Class referencedClass;

    public String sqlConstraintString(Dialect d, String constraintName) {
        String[] cols = new String[this.getColumnSpan()];
        String[] refcols = new String[this.getColumnSpan()];
        int i = 0;
        Iterator refiter = this.referencedTable.getPrimaryKey().getColumnIterator();
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            cols[i] = ((Column)iter.next()).getName();
            refcols[i] = ((Column)refiter.next()).getName();
            ++i;
        }
        return d.getAddForeignKeyConstraintString(constraintName, cols, this.referencedTable.getName(), refcols);
    }

    public Table getReferencedTable() {
        return this.referencedTable;
    }

    public void setReferencedTable(Table referencedTable) throws MappingException {
        if (referencedTable.getPrimaryKey().getColumnSpan() != this.getColumnSpan()) {
            throw new MappingException("Foreign key must have same number of columns as referenced primary key");
        }
        Iterator fkCols = this.getColumnIterator();
        Iterator pkCols = referencedTable.getPrimaryKey().getColumnIterator();
        while (pkCols.hasNext()) {
            ((Column)fkCols.next()).setLength(((Column)pkCols.next()).getLength());
        }
        this.referencedTable = referencedTable;
    }

    public Class getReferencedClass() {
        return this.referencedClass;
    }

    public void setReferencedClass(Class referencedClass) {
        this.referencedClass = referencedClass;
    }
}

