/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.loader;

import cirrus.hibernate.Environment;
import cirrus.hibernate.HibernateException;
import cirrus.hibernate.LockMode;
import cirrus.hibernate.WrongClassException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.Key;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.helpers.JDBCExceptionReporter;
import cirrus.hibernate.helpers.StringHelper;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.impl.QueryImpl;
import cirrus.hibernate.persister.Loadable;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Loader {
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$loader$Loader == null ? (class$cirrus$hibernate$loader$Loader = Loader.class$("cirrus.hibernate.loader.Loader")) : class$cirrus$hibernate$loader$Loader));
    static /* synthetic */ Class class$cirrus$hibernate$loader$Loader;

    protected abstract String getSQLString();

    public abstract Loadable[] getPersisters();

    protected abstract String[] getSuffixes();

    protected abstract CollectionPersister getCollectionPersister();

    protected LockMode getLockMode() {
        return LockMode.READ;
    }

    protected boolean allowTwoPhaseLoad() {
        return true;
    }

    protected Type[] getReturnTypes() {
        return null;
    }

    public String[][] getScalarColumnNames() {
        return null;
    }

    protected boolean hasScalarValues() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final List doFind(SessionImplementor session, Object[] values, Type[] types, Object optionalObject, Serializable optionalID, PersistentCollection optionalCollection, boolean returnProxies, QueryImpl.RowSelection selection, Map namedParams) throws SQLException, HibernateException {
        block24: {
            returnProxies = returnProxies != false && Environment.jvmSupportsProxies() != false;
            maxRows = selection == null || selection.maxRows == null ? 0x7FFFFFFF : selection.maxRows;
            persisters = this.getPersisters();
            cols = persisters.length;
            collection = this.getCollectionPersister() != null;
            twoPhaseLoad = this.allowTwoPhaseLoad() != false && cols > 0;
            suffixes = this.getSuffixes();
            hydratedObjects = twoPhaseLoad != false ? new ArrayList<Object>() : null;
            optionalObjectKey = optionalObject != null ? new Key(optionalID, session.getPersister(optionalObject)) : null;
            names = null;
            returnTypes = null;
            scalars = this.hasScalarValues();
            if (scalars) {
                returnTypes = this.getReturnTypes();
                names = this.getScalarColumnNames();
            }
            results = new ArrayList<Object>();
            st = this.prepareQueryStatement(this.getSQLString(), values, types, selection, false, session);
            rs = this.getResultSet(st, namedParams, selection, session);
            keys = new Key[cols];
            hydrate = new boolean[cols];
            count = 0;
            if (true) ** GOTO lbl66
            do {
                i = 0;
                while (i < cols) {
                    keys[i] = this.getKeyFromResultSet(persisters[i], suffixes[i], i == cols - 1 ? optionalID : null, rs, session);
                    ++i;
                }
                row = this.getRow(rs, persisters, suffixes, keys, hydrate, optionalObject, optionalObjectKey, session);
                i = 0;
                while (i < cols) {
                    if (hydrate[i]) {
                        this.loadFromResultSet(rs, row[i], keys[i].getIdentifier(), suffixes[i], session);
                        if (twoPhaseLoad) {
                            hydratedObjects.add(row[i]);
                        } else {
                            session.initializeEntity(row[i]);
                        }
                    }
                    if (returnProxies) {
                        row[i] = session.proxyFor(persisters[i], keys[i], row[i]);
                    }
                    ++i;
                }
                if (!scalars) {
                    results.add(cols == 1 ? row[0] : row);
                } else {
                    queryCols = returnTypes.length;
                    if (queryCols == 1) {
                        results.add(returnTypes[0].nullSafeGet(rs, names[0], session, null));
                    } else {
                        queryRow = new Object[queryCols];
                        i = 0;
                        while (i < queryCols) {
                            queryRow[i] = returnTypes[i].nullSafeGet(rs, names[i], session, null);
                            ++i;
                        }
                        results.add(queryRow);
                    }
                }
                if (collection) {
                    optionalCollection.readFrom(rs, this.getCollectionPersister());
                }
                ++count;
lbl66:
                // 2 sources

                if (count >= maxRows) break;
            } while (rs.next());
            var34_34 = null;
            try {
                rs.close();
                v0 = null;
                break block24;
            }
            catch (Throwable var35_36) {
                v0 = null;
            }
            {
                break block24;
                catch (SQLException sqle) {
                    JDBCExceptionReporter.logExceptions(sqle);
                    throw sqle;
                }
            }
            catch (Throwable var33_40) {
                var34_35 = null;
                try {
                    rs.close();
                    v1 = null;
                }
                catch (Throwable var35_37) {
                    v1 = null;
                }
                var36_39 = v1;
                session.getBatcher().closeQueryStatement(st);
                throw var33_40;
            }
        }
        var36_38 = v0;
        session.getBatcher().closeQueryStatement(st);
        if (twoPhaseLoad) {
            iter = hydratedObjects.iterator();
            while (iter.hasNext()) {
                session.initializeEntity(iter.next());
            }
        }
        return results;
    }

    private Key getKeyFromResultSet(Loadable persister, String suffix, Serializable id, ResultSet rs, SessionImplementor session) throws HibernateException, SQLException {
        if (id == null) {
            String[] keyColNames = StringHelper.suffix(persister.getIdentifierColumnNames(), suffix);
            StringHelper.unQuoteInPlace(keyColNames);
            id = (Serializable)persister.getIdentifierType().nullSafeGet(rs, keyColNames, session, null);
        }
        return id == null ? null : new Key(id, persister);
    }

    private Object[] getRow(ResultSet rs, Loadable[] persisters, String[] suffixes, Key[] keys, boolean[] hydrate, Object optionalObject, Key optionalObjectKey, SessionImplementor session) throws HibernateException, SQLException {
        int cols = persisters.length;
        Object[] rowResults = new Object[cols];
        int i = 0;
        while (i < cols) {
            Object object = null;
            Key key = keys[i];
            if (keys[i] == null) {
                hydrate[i] = false;
            } else {
                object = session.getEntity(key);
                if (object != null) {
                    hydrate[i] = false;
                    if (!persisters[i].getMappedClass().isAssignableFrom(object.getClass())) {
                        throw new WrongClassException("loaded object was of wrong class", key.getIdentifier(), persisters[i].getMappedClass());
                    }
                } else {
                    Class instanceClass = this.getInstanceClass(rs, persisters[i], suffixes[i], key.getIdentifier(), session);
                    object = optionalObjectKey != null && key.equals(optionalObjectKey) ? optionalObject : session.getFactory().getPersister(instanceClass).instantiate(key.getIdentifier());
                    hydrate[i] = true;
                    session.addUninitializedEntity(key, object, this.getLockMode());
                }
            }
            rowResults[i] = object;
            ++i;
        }
        return rowResults;
    }

    private void loadFromResultSet(ResultSet rs, Object object, Serializable id, String suffix, SessionImplementor session) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Initializing object from ResultSet: " + id));
        }
        Loadable persister = (Loadable)session.getPersister(object);
        Object[] values = this.hydrate(rs, id, object, persister, session, suffix);
        session.postHydrate(persister, id, values, object, this.getLockMode());
    }

    private Class getInstanceClass(ResultSet rs, Loadable persister, String suffix, Serializable id, SessionImplementor session) throws HibernateException, SQLException {
        Class topClass = persister.getMappedClass();
        if (persister.hasSubclasses()) {
            String col = StringHelper.unQuote(StringHelper.suffix(persister.getDiscriminatorColumnName(), suffix));
            Object discriminatorValue = persister.getDiscriminatorType().nullSafeGet(rs, col, session, null);
            Class result = persister.getSubclassForDiscriminatorValue(discriminatorValue);
            if (result == null) {
                throw new WrongClassException("Discriminator: " + discriminatorValue, id, topClass);
            }
            return result;
        }
        return topClass;
    }

    private Object[] hydrate(ResultSet rs, Serializable id, Object object, Loadable persister, SessionImplementor session, String suffix) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Hydrating entity: " + persister.getClassName() + '#' + id));
        }
        Type[] types = persister.getPropertyTypes();
        Object[] values = new Object[types.length];
        int i = 0;
        while (i < types.length) {
            String[] cols = StringHelper.suffix(persister.getPropertyColumnNames(i), suffix);
            StringHelper.unQuoteInPlace(cols);
            values[i] = types[i].hydrate(rs, cols, session, object);
            ++i;
        }
        return values;
    }

    protected final void advance(ResultSet rs, QueryImpl.RowSelection selection, SessionImplementor session) throws SQLException {
        if (selection == null) {
            return;
        }
        Integer first = selection.firstRow;
        if (first != null && first != 0) {
            if (session.getFactory().useScrollableResultSets()) {
                rs.absolute(first);
            } else {
                int m = 0;
                while (m < first) {
                    rs.next();
                    ++m;
                }
            }
        }
    }

    protected final PreparedStatement prepareQueryStatement(String sql, Object[] values, Type[] types, QueryImpl.RowSelection selection, boolean scroll, SessionImplementor session) throws SQLException, HibernateException {
        boolean scrollable = selection != null && (selection.firstRow != null && selection.firstRow != 0 || scroll) && session.getFactory().useScrollableResultSets();
        PreparedStatement st = session.getBatcher().prepareQueryStatement(sql, scrollable);
        try {
            if (selection != null && selection.timeout != null) {
                st.setQueryTimeout(selection.timeout);
            }
            int col = 1;
            int i = 0;
            while (i < values.length) {
                types[i].nullSafeSet(st, values[i], col, session);
                col += types[i].getColumnSpan(session.getFactory());
                ++i;
            }
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            session.getBatcher().closeQueryStatement(st);
            throw sqle;
        }
        catch (HibernateException he) {
            session.getBatcher().closeQueryStatement(st);
            throw he;
        }
        return st;
    }

    protected final void setMaxRows(PreparedStatement st, QueryImpl.RowSelection selection) throws SQLException {
        if (selection != null && selection.maxRows != null) {
            st.setMaxRows(selection.maxRows + (selection.firstRow == null ? 0 : selection.firstRow));
        }
    }

    private final ResultSet getResultSet(PreparedStatement st, Map namedParams, QueryImpl.RowSelection selection, SessionImplementor session) throws SQLException, HibernateException {
        try {
            this.bindNamedParameters(st, namedParams, session);
            this.setMaxRows(st, selection);
            ResultSet rs = st.executeQuery();
            this.advance(rs, selection, session);
            return rs;
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
        catch (HibernateException he) {
            session.getBatcher().closeQueryStatement(st);
            throw he;
        }
    }

    protected void bindNamedParameters(PreparedStatement st, Map namedParams, SessionImplementor session) throws SQLException, HibernateException {
    }

    protected final List loadEntity(SessionImplementor session, Object[] values, Type[] types, Object optionalObject, Serializable optionalID, boolean returnProxies) throws SQLException, HibernateException {
        return this.doFind(session, values, types, optionalObject, optionalID, null, returnProxies, null, null);
    }

    protected final List loadCollection(SessionImplementor session, Object[] values, Type[] types, PersistentCollection collection, boolean returnProxies) throws SQLException, HibernateException {
        return this.doFind(session, values, types, null, null, collection, returnProxies, null, null);
    }

    public final List find(SessionImplementor session, Object[] values, Type[] types, boolean returnProxies, QueryImpl.RowSelection selection, Map namedParams) throws SQLException, HibernateException {
        return this.doFind(session, values, types, null, null, null, returnProxies, selection, namedParams);
    }

    protected static final String sqlSelect(String selectClause, String fromClause, String outerJoinsAfterFrom, String whereClause, String outerJoinsAfterWhere) {
        return Loader.sqlSelect(selectClause, fromClause, outerJoinsAfterFrom, whereClause, outerJoinsAfterWhere, null);
    }

    protected static final String sqlSelect(String selectClause, String fromClause, String outerJoinsAfterFrom, String whereClause, String outerJoinsAfterWhere, String orderByClause) {
        StringBuffer buf = new StringBuffer(selectClause.length() + fromClause.length() + outerJoinsAfterFrom.length() + whereClause.length() + outerJoinsAfterWhere.length() + 20);
        buf.append("SELECT ").append(selectClause).append(" FROM ").append(fromClause).append(outerJoinsAfterFrom).append(" WHERE ").append(whereClause).append(outerJoinsAfterWhere);
        if (orderByClause != null) {
            buf.append(" ORDER BY ").append(orderByClause);
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

