/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.id;

import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.id.UUIDGenerator;
import java.io.Serializable;

public class UUIDHexGenerator
extends UUIDGenerator {
    private final String sep;

    public UUIDHexGenerator() {
        this.sep = "";
    }

    public UUIDHexGenerator(String sep) {
        this.sep = sep;
    }

    protected String format(int intval) {
        String formatted = Integer.toHexString(intval);
        StringBuffer buf = new StringBuffer("00000000");
        buf.replace(8 - formatted.length(), 8, formatted);
        return buf.toString();
    }

    protected String format(short shortval) {
        String formatted = Integer.toHexString(shortval);
        StringBuffer buf = new StringBuffer("0000");
        buf.replace(4 - formatted.length(), 4, formatted);
        return buf.toString();
    }

    public Serializable generate(SessionImplementor cache, Object obj) {
        return new StringBuffer(36).append(this.format(this.getIP())).append(this.sep).append(this.format(this.getJVM())).append(this.sep).append(this.format(this.getHiTime())).append(this.sep).append(this.format(this.getLoTime())).append(this.sep).append(this.format(this.getCount())).toString();
    }

    public static void main(String[] args) throws Exception {
        UUIDHexGenerator gen = new UUIDHexGenerator("/");
        UUIDHexGenerator gen2 = new UUIDHexGenerator("/");
        int i = 0;
        while (i < 10) {
            String id = (String)((Object)gen.generate(null, null));
            System.out.println(id + ": " + id.length());
            String id2 = (String)((Object)gen2.generate(null, null));
            System.out.println(id2 + ": " + id2.length());
            ++i;
        }
    }
}

