/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.collections;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.collections.Set;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class SortedSet
extends Set
implements java.util.SortedSet {
    private Comparator comparator;

    public Serializable snapshot(CollectionPersister persister) throws HibernateException {
        TreeSet<Object> clonedSet = new TreeSet<Object>(this.comparator);
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            clonedSet.add(persister.getElementType().deepCopy(iter.next()));
        }
        return clonedSet;
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        TreeSet<Serializable> result = new TreeSet<Serializable>(this.comparator);
        Iterator iter = this.set.iterator();
        while (iter.hasNext()) {
            result.add(persister.getElementType().disassemble(iter.next(), this.session));
        }
        return result;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.set = new TreeSet(this.comparator);
    }

    public SortedSet(SessionImplementor session) {
        super(session);
    }

    public SortedSet(SessionImplementor session, java.util.SortedSet set) {
        super(session, set);
    }

    public Comparator comparator() {
        return ((java.util.SortedSet)this.set).comparator();
    }

    public java.util.SortedSet subSet(Object fromElement, Object toElement) {
        this.read();
        java.util.SortedSet<Object> s = ((java.util.SortedSet)this.set).subSet(fromElement, toElement);
        return new SubSetProxy(s);
    }

    public java.util.SortedSet headSet(Object toElement) {
        this.read();
        java.util.SortedSet<Object> s = ((java.util.SortedSet)this.set).headSet(toElement);
        return new SubSetProxy(s);
    }

    public java.util.SortedSet tailSet(Object fromElement) {
        this.read();
        java.util.SortedSet<Object> s = ((java.util.SortedSet)this.set).tailSet(fromElement);
        return new SubSetProxy(s);
    }

    public Object first() {
        this.read();
        return ((java.util.SortedSet)this.set).first();
    }

    public Object last() {
        this.read();
        return ((java.util.SortedSet)this.set).last();
    }

    public SortedSet() {
    }

    class SubSetProxy
    extends PersistentCollection.SetProxy
    implements java.util.SortedSet {
        SubSetProxy(java.util.SortedSet s) {
            super(s);
        }

        public Comparator comparator() {
            return ((java.util.SortedSet)this.set).comparator();
        }

        public Object first() {
            return ((java.util.SortedSet)this.set).first();
        }

        public java.util.SortedSet headSet(Object arg0) {
            return new SubSetProxy(((java.util.SortedSet)this.set).headSet(arg0));
        }

        public Object last() {
            return ((java.util.SortedSet)this.set).last();
        }

        public java.util.SortedSet subSet(Object arg0, Object arg1) {
            return new SubSetProxy(((java.util.SortedSet)this.set).subSet(arg0, arg1));
        }

        public java.util.SortedSet tailSet(Object arg0) {
            return new SubSetProxy(((java.util.SortedSet)this.set).tailSet(arg0));
        }
    }
}

