/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.collections;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.collections.ODMGCollection;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.odmg.DArray;
import org.odmg.DList;

public class List
extends ODMGCollection
implements java.util.List,
DList,
DArray {
    private java.util.List list;

    public Serializable snapshot(CollectionPersister persister) throws HibernateException {
        ArrayList<Object> clonedList = new ArrayList<Object>(this.list.size());
        Iterator iter = this.list.iterator();
        while (iter.hasNext()) {
            clonedList.add(persister.getElementType().deepCopy(iter.next()));
        }
        return clonedList;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        java.util.List sn = (java.util.List)((Object)this.getSnapshot());
        if (sn.size() != this.list.size()) {
            return false;
        }
        Iterator iter = this.list.iterator();
        Iterator sniter = sn.iterator();
        while (iter.hasNext()) {
            if (elementType.equals(iter.next(), sniter.next())) continue;
            return false;
        }
        return true;
    }

    public List(SessionImplementor session) {
        super(session);
    }

    public List(SessionImplementor session, java.util.List list) {
        super(session);
        this.list = list;
        this.initialized = true;
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.list = new ArrayList();
    }

    public int size() {
        this.read();
        return this.list.size();
    }

    public boolean isEmpty() {
        this.read();
        return this.list.isEmpty();
    }

    public boolean contains(Object object) {
        this.read();
        return this.list.contains(object);
    }

    public Iterator iterator() {
        this.read();
        return new PersistentCollection.IteratorProxy(this, this.list.iterator());
    }

    public Object[] toArray() {
        this.read();
        return this.list.toArray();
    }

    public Object[] toArray(Object[] array) {
        this.read();
        return this.list.toArray(array);
    }

    public boolean add(Object object) {
        if (!this.queueAdd(object)) {
            this.write();
            return this.list.add(object);
        }
        return true;
    }

    public boolean remove(Object arg0) {
        this.write();
        return this.list.remove(arg0);
    }

    public boolean containsAll(Collection arg0) {
        this.read();
        return this.list.containsAll(arg0);
    }

    public boolean addAll(Collection c) {
        if (!this.queueAddAll(c)) {
            this.write();
            return this.list.addAll(c);
        }
        return c.size() > 0;
    }

    public boolean addAll(int arg0, Collection arg1) {
        this.write();
        return this.list.addAll(arg0, arg1);
    }

    public boolean removeAll(Collection arg0) {
        this.write();
        return this.list.removeAll(arg0);
    }

    public boolean retainAll(Collection arg0) {
        this.write();
        return this.list.retainAll(arg0);
    }

    public void clear() {
        this.write();
        this.list.clear();
    }

    public Object get(int arg0) {
        this.read();
        return this.list.get(arg0);
    }

    public Object set(int arg0, Object arg1) {
        this.write();
        return this.list.set(arg0, arg1);
    }

    public void add(int arg0, Object arg1) {
        this.write();
        this.list.add(arg0, arg1);
    }

    public Object remove(int arg0) {
        this.write();
        return this.list.remove(arg0);
    }

    public int indexOf(Object arg0) {
        this.read();
        return this.list.indexOf(arg0);
    }

    public int lastIndexOf(Object arg0) {
        this.read();
        return this.list.lastIndexOf(arg0);
    }

    public ListIterator listIterator() {
        this.read();
        return new PersistentCollection.ListIteratorProxy(this, this.list.listIterator());
    }

    public ListIterator listIterator(int arg0) {
        this.read();
        return new PersistentCollection.ListIteratorProxy(this, this.list.listIterator(arg0));
    }

    public java.util.List subList(int arg0, int arg1) {
        this.read();
        return new PersistentCollection.ListProxy(this, this.list.subList(arg0, arg1));
    }

    public void replaceElements(Map replacements) {
        int i = 0;
        while (i < this.size()) {
            Object r;
            Object val = this.list.get(i);
            if (val != null && (r = replacements.get(val)) != null) {
                this.list.set(i, r);
            }
            ++i;
        }
    }

    public Iterator elements() {
        return this.list.iterator();
    }

    public boolean empty() {
        return this.list.isEmpty();
    }

    public String toString() {
        this.read();
        return this.list.toString();
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.session);
        persister.writeIndex(st, new Integer(i), writeOrder, this.session);
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, this.session);
        int index = (Integer)persister.readIndex(rs, this.session);
        int i = this.list.size();
        while (i <= index) {
            this.list.add(i, null);
            ++i;
        }
        this.list.set(index, element);
        return element;
    }

    public Iterator entries() {
        return this.list.iterator();
    }

    public void readEntries(Iterator entries) {
        while (entries.hasNext()) {
            this.list.add(entries.next());
        }
    }

    public void assemble(CollectionPersister persister) throws HibernateException, SQLException {
        int length = this.list.size();
        java.util.List old = this.list;
        this.beforeInitialize(persister);
        int i = 0;
        while (i < length) {
            this.list.add(persister.getElementType().assemble((Serializable)old.get(i), this.session, null));
            ++i;
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = this.list.size();
        ArrayList<Serializable> result = new ArrayList<Serializable>(length);
        int i = 0;
        while (i < length) {
            result.add(persister.getElementType().disassemble(this.list.get(i), this.session));
            ++i;
        }
        return result;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        HashSet<Integer> deletes = new HashSet<Integer>();
        int i = this.list.size();
        while (i < ((java.util.List)((Object)this.getSnapshot())).size()) {
            deletes.add(new Integer(i));
            ++i;
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        java.util.List sn = (java.util.List)((Object)this.getSnapshot());
        return i >= sn.size();
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        java.util.List sn = (java.util.List)((Object)this.getSnapshot());
        return i < sn.size() && !elemType.equals(this.list.get(i), sn.get(i));
    }

    public Object getIndex(Object entry, int i) {
        return new Integer(i);
    }

    public List() {
    }

    public DList concat(DList arglist) {
        this.read();
        ArrayList list = new ArrayList(arglist.size() + this.list.size());
        list.addAll(this.list);
        list.addAll(arglist);
        return new List(this.session, list);
    }

    public void resize(int length) {
        this.write();
        ArrayList newlist = new ArrayList(length);
        Iterator iter = this.list.iterator();
        int i = 0;
        while (iter.hasNext()) {
            if (++i > length) break;
            newlist.add(iter.next());
        }
        this.list = newlist;
    }
}

