/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.utils.ResourceURL;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.wsf.common.DOMUtils;
import org.jboss.wsf.common.IOUtils;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLFilePublisher {
    private static final Logger log = Logger.getLogger(WSDLFilePublisher.class);
    private ArchiveDeployment dep;
    private String expLocation;
    private ServerConfig serverConfig;

    public WSDLFilePublisher(ArchiveDeployment dep) {
        this.dep = dep;
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        this.expLocation = dep.getType().toString().endsWith("JSE") ? "WEB-INF/wsdl/" : "META-INF/wsdl/";
    }

    public void publishWsdlFiles(UnifiedMetaData wsMetaData) throws IOException {
        String deploymentName = this.dep.getCanonicalName();
        for (ServiceMetaData serviceMetaData : wsMetaData.getServices()) {
            File wsdlFile = this.getPublishLocation(deploymentName, serviceMetaData);
            wsdlFile.getParentFile().mkdirs();
            try {
                Writer fWriter = IOUtils.getCharsetFileWriter((File)wsdlFile, (String)"UTF-8");
                WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
                new org.jboss.ws.tools.wsdl.WSDLWriter(wsdlDefinitions).write(fWriter, "UTF-8");
                URL wsdlPublishURL = wsdlFile.toURL();
                log.info((Object)("WSDL published to: " + wsdlPublishURL));
                serviceMetaData.setWsdlLocation(wsdlFile.toURL());
                Definition wsdl11Definition = wsdlDefinitions.getWsdlOneOneDefinition();
                if (wsdl11Definition != null) {
                    this.publishWsdlImports(wsdlFile.toURL(), wsdl11Definition);
                    Document document = wsdlDefinitions.getWsdlDocument();
                    this.publishSchemaImports(wsdlFile.toURL(), document.getDocumentElement());
                    continue;
                }
                throw new NotImplementedException("WSDL-2.0 imports");
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception e) {
                throw new WSException("Cannot publish wsdl to: " + wsdlFile, e);
            }
        }
    }

    private void publishWsdlImports(URL parentURL, Definition parentDefinition) throws Exception {
        String baseURI = parentURL.toExternalForm();
        Iterator it = parentDefinition.getImports().values().iterator();
        while (it.hasNext()) {
            for (Import wsdlImport : (List)it.next()) {
                String locationURI = wsdlImport.getLocationURI();
                Definition subdef = wsdlImport.getDefinition();
                if (locationURI.startsWith("http://")) continue;
                URL targetURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + locationURI);
                File targetFile = new File(targetURL.getPath());
                targetFile.getParentFile().mkdirs();
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                FileWriter fw = new FileWriter(targetFile);
                wsdlWriter.writeWSDL(subdef, (Writer)fw);
                fw.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("WSDL import published to: " + targetURL));
                }
                this.publishWsdlImports(targetURL, subdef);
                Element subdoc = DOMUtils.parse((InputStream)targetURL.openStream());
                this.publishSchemaImports(targetURL, subdoc);
            }
        }
    }

    private void publishSchemaImports(URL parentURL, Element element) throws Exception {
        String baseURI = parentURL.toExternalForm();
        Iterator it = DOMUtils.getChildElements((Node)element);
        while (it.hasNext()) {
            Element childElement = (Element)it.next();
            if ("import".equals(childElement.getLocalName()) || "include".equals(childElement.getLocalName())) {
                URL resourceURL;
                InputStream is;
                String schemaLocation = childElement.getAttribute("schemaLocation");
                if (schemaLocation.length() <= 0 || schemaLocation.startsWith("http://")) continue;
                URL xsdURL = new URL(baseURI.substring(0, baseURI.lastIndexOf("/") + 1) + schemaLocation);
                File targetFile = new File(xsdURL.getPath());
                targetFile.getParentFile().mkdirs();
                String deploymentName = this.dep.getCanonicalName();
                int index = baseURI.indexOf(deploymentName);
                String resourcePath = baseURI.substring(index + deploymentName.length());
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
                if (resourcePath.length() > 0) {
                    resourcePath = resourcePath + "/";
                }
                if ((is = new ResourceURL(resourceURL = this.dep.getMetaDataFileURL(resourcePath = this.expLocation + resourcePath + schemaLocation)).openStream()) == null) {
                    throw new IllegalArgumentException("Cannot find schema import in deployment: " + resourcePath);
                }
                FileOutputStream fos = new FileOutputStream(targetFile);
                IOUtils.copyStream((OutputStream)fos, (InputStream)is);
                fos.close();
                is.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("XMLSchema import published to: " + xsdURL));
                }
                Element subdoc = DOMUtils.parse((InputStream)xsdURL.openStream());
                this.publishSchemaImports(xsdURL, subdoc);
                continue;
            }
            this.publishSchemaImports(parentURL, childElement);
        }
    }

    public void unpublishWsdlFiles() throws IOException {
        String deploymentDir = this.dep.getParent() != null ? this.dep.getParent().getSimpleName() : this.dep.getSimpleName();
        File serviceDir = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + deploymentDir);
        this.deleteWsdlPublishDirectory(serviceDir);
    }

    private void deleteWsdlPublishDirectory(File dir) throws IOException {
        String[] files = dir.list();
        for (int i = 0; files != null && i < files.length; ++i) {
            String fileName = files[i];
            File file = new File(dir + "/" + fileName);
            if (file.isDirectory()) {
                this.deleteWsdlPublishDirectory(file);
                continue;
            }
            if (file.delete()) continue;
            log.warn((Object)("Cannot delete published wsdl document: " + file.toURL()));
        }
        dir.delete();
    }

    private File getPublishLocation(String archiveName, ServiceMetaData serviceMetaData) throws IOException {
        File wsdlFile;
        String publishLocation;
        String wsdlLocation = null;
        if (serviceMetaData.getWsdlLocation() != null) {
            wsdlLocation = serviceMetaData.getWsdlLocation().toExternalForm();
        } else if (serviceMetaData.getWsdlFile() != null) {
            wsdlLocation = serviceMetaData.getWsdlFile();
        }
        if (wsdlLocation == null) {
            throw new IllegalStateException("Cannot obtain wsdl location for: " + serviceMetaData.getServiceName());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Publish WSDL file: " + wsdlLocation));
        }
        boolean predefinedLocation = (publishLocation = serviceMetaData.getWsdlPublishLocation()) != null && publishLocation.startsWith("file:");
        File locationFile = null;
        if (!predefinedLocation) {
            locationFile = new File(this.serverConfig.getServerDataDir().getCanonicalPath() + "/wsdl/" + archiveName);
        } else {
            try {
                locationFile = new File(new URL(publishLocation).getPath());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid publish location: " + e.getMessage());
            }
        }
        if (wsdlLocation.indexOf(this.expLocation) >= 0) {
            wsdlLocation = wsdlLocation.substring(wsdlLocation.indexOf(this.expLocation) + this.expLocation.length());
            wsdlFile = new File(locationFile + "/" + wsdlLocation);
        } else if (wsdlLocation.startsWith("vfsfile:") || wsdlLocation.startsWith("file:") || wsdlLocation.startsWith("jar:")) {
            wsdlLocation = wsdlLocation.substring(wsdlLocation.lastIndexOf("/") + 1);
            wsdlFile = new File(locationFile + "/" + wsdlLocation);
        } else {
            throw new WSException("Invalid wsdlFile '" + wsdlLocation + "', expected in: " + this.expLocation);
        }
        return wsdlFile;
    }
}

