/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.session;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.objectweb.jtests.jms.framework.PTPTestCase;
import org.objectweb.jtests.jms.framework.TestConfig;

public class SessionTest
extends PTPTestCase {
    public void testRecoverTransactedSession() {
        try {
            SessionTest.assertEquals((boolean)false, (boolean)this.senderSession.getTransacted());
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            SessionTest.assertEquals((boolean)true, (boolean)this.senderSession.getTransacted());
            this.senderSession.recover();
            SessionTest.fail((String)"Should raise an IllegalStateException, the session is not transacted.\n");
        }
        catch (IllegalStateException e) {
        }
        catch (java.lang.IllegalStateException e) {
            SessionTest.fail((String)"Should raise a javax.jms.IllegalStateException, not a java.lang.IllegalStateException.\n");
        }
        catch (Exception e) {
            SessionTest.fail((String)("Should raise a javax.jms.IllegalStateException, not a " + e));
        }
    }

    public void testRollbackTransactedSession() {
        try {
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            this.sender = this.senderSession.createSender(this.senderQueue);
            SessionTest.assertEquals((boolean)true, (boolean)this.senderSession.getTransacted());
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testRollbackTransactedSession");
            this.sender.send((Message)message);
            this.senderSession.rollback();
            TextMessage m = (TextMessage)this.receiver.receiveNoWait();
            SessionTest.assertEquals(null, (Object)m);
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testCommitTransactedSession() {
        try {
            this.senderSession = this.senderConnection.createQueueSession(true, 0);
            this.sender = this.senderSession.createSender(this.senderQueue);
            SessionTest.assertEquals((boolean)true, (boolean)this.senderSession.getTransacted());
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testCommitTransactedSession");
            this.sender.send((Message)message);
            TextMessage m = (TextMessage)this.receiver.receiveNoWait();
            SessionTest.assertEquals(null, (Object)m);
            this.senderSession.commit();
            m = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            SessionTest.assertTrue((m != null ? 1 : 0) != 0);
            SessionTest.assertEquals((String)"testCommitTransactedSession", (String)m.getText());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testRollbackNonTransactedSession() {
        try {
            SessionTest.assertEquals((boolean)false, (boolean)this.senderSession.getTransacted());
            this.senderSession.rollback();
            SessionTest.fail((String)"Should raise an IllegalStateException, the session is not transacted.\n");
        }
        catch (IllegalStateException e) {
        }
        catch (java.lang.IllegalStateException e) {
            SessionTest.fail((String)"Should raise a javax.jms.IllegalStateException, not a java.lang.IllegalStateException.\n");
        }
        catch (Exception e) {
            SessionTest.fail((String)("Should raise a javax.jms.IllegalStateException, not a " + e));
        }
    }

    public void testCommitNonTransactedSession() {
        try {
            SessionTest.assertEquals((boolean)false, (boolean)this.senderSession.getTransacted());
            this.senderSession.commit();
            SessionTest.fail((String)"Should raise an IllegalStateException, the session is not transacted.\n");
        }
        catch (IllegalStateException e) {
        }
        catch (java.lang.IllegalStateException e) {
            SessionTest.fail((String)"Should raise a javax.jms.IllegalStateException, not a java.lang.IllegalStateException.\n");
        }
        catch (Exception e) {
            SessionTest.fail((String)("Should raise a javax.jms.IllegalStateException, not a " + e));
        }
    }

    public void testGetTransacted() {
        try {
            SessionTest.assertEquals((boolean)false, (boolean)this.senderSession.getTransacted());
            this.senderSession = this.senderConnection.createQueueSession(true, 1);
            SessionTest.assertEquals((boolean)true, (boolean)this.senderSession.getTransacted());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void testAcknowledge() {
        try {
            if (this.receiverSession != null) {
                this.receiverSession.close();
            }
            this.receiverSession = this.receiverConnection.createQueueSession(false, 2);
            this.receiver = this.receiverSession.createReceiver(this.receiverQueue);
            Message message = this.senderSession.createMessage();
            this.sender.send(message);
            Message m = this.receiver.receive(TestConfig.TIMEOUT);
            this.receiverSession.close();
            m.acknowledge();
            SessionTest.fail((String)"\ufffd4.4.1 Invoking the acknowledge method of a received message from a closed  session must throw an [javax.jms.]IllegalStateException.\n");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            SessionTest.fail((String)("Should raise a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
        catch (java.lang.IllegalStateException e) {
            SessionTest.fail((String)"\ufffd4.4.1 Invoking the acknowledge method of a received message from a closed session must throw an [javax.jms.]IllegalStateException, [not a java.lang.IllegalStateException]");
        }
    }

    public void testUseMessage() {
        try {
            TextMessage message = this.senderSession.createTextMessage();
            message.setText("testUseMessage");
            this.sender.send((Message)message);
            TextMessage m = (TextMessage)this.receiver.receive(TestConfig.TIMEOUT);
            this.receiverSession.close();
            SessionTest.assertEquals((String)"testUseMessage", (String)m.getText());
        }
        catch (Exception e) {
            SessionTest.fail((String)"\ufffd4.4.1 It is valid to continue to use message objects created or received via the [closed] session.\n");
        }
    }

    public void testUsedClosedSession() {
        try {
            this.senderSession.close();
            this.senderSession.createMessage();
            SessionTest.fail((String)"\ufffd4.4.1 An attempt to use [a closed session] must throw a [javax.jms.]IllegalStateException.\n");
        }
        catch (IllegalStateException e) {
        }
        catch (JMSException e) {
            SessionTest.fail((String)("Should raise a javax.jms.IllegalStateException, not a " + (Object)((Object)e)));
        }
        catch (java.lang.IllegalStateException e) {
            SessionTest.fail((String)"Should raise a javax.jms.IllegalStateException, not a java.lang.IllegalStateException");
        }
    }

    public void testCloseClosedSession() {
        try {
            this.senderSession.close();
            this.senderSession.close();
        }
        catch (Exception e) {
            SessionTest.fail((String)"\ufffd4.4.1 Closing a closed session must NOT throw an exception.\n");
        }
    }

    public static Test suite() {
        return new TestSuite(SessionTest.class);
    }

    public SessionTest(String name) {
        super(name);
    }
}

