/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.protocols.TunnelHeader;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.Util;

public class RouterStub {
    String router_host = null;
    int router_port = 0;
    Socket sock = null;
    private ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(512);
    DataOutputStream output = null;
    DataInputStream input = null;
    DatagramSocket my_sock = null;
    Address local_addr = null;
    static final long RECONNECT_TIMEOUT = 5000L;
    private volatile boolean connected = false;
    private volatile boolean reconnect = false;
    protected static final Log log = LogFactory.getLog((Class)RouterStub.class);
    protected ConnectionListener conn_listener;
    private String groupname = null;
    private InetAddress bind_addr = null;

    public RouterStub() {
    }

    public RouterStub(String router_host, int router_port) {
        this.router_host = router_host != null ? router_host : "localhost";
        this.router_port = router_port;
    }

    public InetAddress getBindAddress() {
        return this.bind_addr;
    }

    public void setBindAddress(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    public String getRouterHost() {
        return this.router_host;
    }

    public void setRouterHost(String router_host) {
        this.router_host = router_host;
    }

    public int getRouterPort() {
        return this.router_port;
    }

    public void setRouterPort(int router_port) {
        this.router_port = router_port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnectionListener(ConnectionListener conn_listener) {
        this.conn_listener = conn_listener;
    }

    public synchronized Address getLocalAddress() throws SocketException {
        if (this.local_addr == null) {
            this.local_addr = this.generateLocalAddress();
        }
        return this.local_addr;
    }

    private synchronized Address generateLocalAddress() throws SocketException {
        this.my_sock = new DatagramSocket(0, this.bind_addr);
        this.local_addr = new IpAddress(this.bind_addr, this.my_sock.getLocalPort());
        return this.local_addr;
    }

    public synchronized void connect(String groupname) throws Exception {
        if (groupname == null || groupname.length() == 0) {
            throw new Exception("groupname is null");
        }
        this.groupname = groupname;
        if (this.local_addr == null) {
            this.local_addr = this.generateLocalAddress();
        }
        try {
            this.sock = new Socket(this.router_host, this.router_port, this.bind_addr, 0);
            this.sock.setSoLinger(true, 500);
            this.output = new DataOutputStream(this.sock.getOutputStream());
            GossipData req = new GossipData(1, groupname, this.local_addr, null);
            req.writeTo(this.output);
            this.output.flush();
            this.input = new DataInputStream(this.sock.getInputStream());
            this.setConnected(true);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("failed connecting to " + this.router_host + ":" + this.router_port));
            }
            Util.close(this.sock);
            Util.close(this.input);
            Util.close(this.output);
            this.setConnected(false);
            throw e;
        }
    }

    public void connect(String groupname, String router_host, int router_port) throws Exception {
        this.setRouterHost(router_host);
        this.setRouterPort(router_port);
        this.connect(groupname);
    }

    public synchronized void disconnect() {
        this.disconnect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(boolean is_reconnect) {
        try {
            if (this.sock == null || this.output == null || this.input == null) {
                this.setConnected(false);
                return;
            }
            if (this.groupname == null || this.groupname.length() == 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"groupname is null");
                }
                return;
            }
            if (this.local_addr == null) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"local_addr is null");
                }
                return;
            }
            GossipData req = new GossipData(2, this.groupname, this.local_addr, null);
            req.writeTo(this.output);
            this.setConnected(false);
        }
        catch (Exception exception) {
        }
        finally {
            Util.close(this.output);
            Util.close(this.input);
            Util.close(this.sock);
            this.sock = null;
            this.setConnected(false);
            this.reconnect = false;
            if (is_reconnect) {
                Util.close(this.my_sock);
                this.local_addr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List get(String groupname) {
        List ret;
        block8: {
            List list;
            ret = null;
            Socket tmpsock = null;
            DataOutputStream tmpOutput = null;
            DataInputStream tmpInput = null;
            if (groupname == null || groupname.length() == 0) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"groupname is null");
                }
                return null;
            }
            try {
                tmpsock = new Socket(this.router_host, this.router_port);
                tmpsock.setSoLinger(true, 500);
                tmpOutput = new DataOutputStream(tmpsock.getOutputStream());
                GossipData request = new GossipData(5, groupname, null, null);
                request.writeTo(tmpOutput);
                tmpInput = new DataInputStream(tmpsock.getInputStream());
                GossipData response = new GossipData();
                response.readFrom(tmpInput);
                list = response.getMembers();
                Util.close(tmpOutput);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("exception=" + e));
                }
                break block8;
            }
            finally {
                Util.close(tmpOutput);
                Util.close(tmpInput);
                Util.close(tmpsock);
            }
            Util.close(tmpInput);
            Util.close(tmpsock);
            return list;
        }
        return ret;
    }

    public boolean send(Message msg, String groupname) {
        Address dst_addr = null;
        if (this.sock == null || this.output == null || this.input == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("no connection to router (groupname=" + groupname + ')'));
            }
            this.setConnected(false);
            return false;
        }
        if (msg == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"message is null");
            }
            return false;
        }
        try {
            dst_addr = msg.getDest();
            try {
                this.out_stream.reset();
            }
            catch (Exception ex) {
                this.out_stream = new ExposedByteArrayOutputStream(512);
            }
            DataOutputStream tmp = new DataOutputStream(this.out_stream);
            msg.writeTo(tmp);
            tmp.close();
            Buffer buf = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
            this.output.writeUTF(groupname);
            Util.writeAddress(dst_addr, this.output);
            this.output.writeInt(buf.getLength());
            this.output.write(buf.getBuf(), 0, buf.getLength());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("failed sending message to " + dst_addr), (Throwable)e);
            }
            this.setConnected(false);
            return false;
        }
        return true;
    }

    public Message receive() throws Exception {
        Message ret = null;
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            this.setConnected(false);
            return null;
        }
        try {
            Address dest = Util.readAddress(this.input);
            int len = this.input.readInt();
            if (len == 0) {
                ret = null;
            } else {
                buf = new byte[len];
                this.input.readFully(buf, 0, len);
                ret = new Message(false);
                ByteArrayInputStream tmp = new ByteArrayInputStream(buf);
                DataInputStream in = new DataInputStream(tmp);
                ret.readFrom(in);
                ret.setDest(dest);
                in.close();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("received " + ret));
            }
            return ret;
        }
        catch (Exception e) {
            this.setConnected(false);
            throw e;
        }
    }

    public void reconnect(int max_attempts) throws Exception {
        int num_atttempts = 0;
        if (this.connected) {
            return;
        }
        this.disconnect();
        this.reconnect = true;
        while (this.reconnect && (num_atttempts++ < max_attempts || max_attempts == -1)) {
            try {
                this.connect(this.groupname);
                break;
            }
            catch (Exception ex) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"failed reconnecting", (Throwable)ex);
                }
                if (max_attempts != -1) continue;
                Util.sleep(5000L);
            }
        }
        if (!this.connected) {
            throw new Exception("reconnect failed");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"client reconnected");
        }
    }

    public void reconnect() throws Exception {
        this.reconnect(-1);
    }

    private void notifyConnectionListener(boolean connected) {
        if (this.conn_listener != null) {
            this.conn_listener.connectionStatusChange(connected);
        }
    }

    private void setConnected(boolean connected) {
        boolean notify = this.connected != connected;
        this.connected = connected;
        if (notify) {
            try {
                this.notifyConnectionListener(this.connected);
            }
            catch (Throwable t) {
                log.error((Object)("failed notifying ConnectionListener " + this.conn_listener), t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("RouterStub <host> <port>");
            return;
        }
        RouterStub stub = new RouterStub(args[0], Integer.parseInt(args[1]));
        RouterStub stub2 = new RouterStub(args[0], Integer.parseInt(args[1]));
        String groupname = "BelaGroup";
        try {
            Message msg;
            int i;
            System.out.println("Registering under BelaGroup");
            stub.connect("BelaGroup");
            System.out.println("My address is " + stub.getLocalAddress());
            Address my_addr = stub2.getLocalAddress();
            stub2.connect("BelaGroup");
            System.out.println("Getting members of BelaGroup: ");
            List mbrs = stub.get("BelaGroup");
            System.out.println("Done, mbrs are " + mbrs);
            for (i = 1; i <= 10; ++i) {
                msg = new Message(null, my_addr, (Serializable)((Object)("Bela #" + i)));
                msg.putHeader("TUNNEL", new TunnelHeader("BelaGroup"));
                boolean rc = stub2.send(msg, "BelaGroup");
                System.out.println("Sent msg #" + i + ", rc=" + rc);
            }
            for (i = 0; i < 10; ++i) {
                msg = stub.receive();
                System.out.println("Received msg " + msg.getObject());
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        finally {
            stub.disconnect();
        }
    }

    public static interface ConnectionListener {
        public void connectionStatusChange(boolean var1);
    }
}

