/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingHeader;
import org.jgroups.stack.GossipClient;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.List;
import org.jgroups.util.Util;

public class PING
extends Discovery {
    String gossip_host = null;
    int gossip_port = 0;
    long gossip_refresh = 20000L;
    GossipClient client;
    int port_range = 1;
    List initial_hosts = null;
    public static final String name = "PING";

    public String getName() {
        return name;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("gossip_host");
        if (str != null) {
            this.gossip_host = str;
            props.remove("gossip_host");
        }
        if ((str = props.getProperty("gossip_port")) != null) {
            this.gossip_port = Integer.parseInt(str);
            props.remove("gossip_port");
        }
        if ((str = props.getProperty("gossip_refresh")) != null) {
            this.gossip_refresh = Long.parseLong(str);
            props.remove("gossip_refresh");
        }
        if (this.gossip_host != null && this.gossip_port != 0) {
            try {
                this.client = new GossipClient(new IpAddress(InetAddress.getByName(this.gossip_host), this.gossip_port), this.gossip_refresh);
            }
            catch (Exception e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("creation of GossipClient failed, exception=" + e));
                }
                return false;
            }
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = Integer.parseInt(str);
            if (this.port_range < 1) {
                this.port_range = 1;
            }
            props.remove("port_range");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            try {
                this.initial_hosts = this.createInitialHosts(str);
            }
            catch (UnknownHostException e) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"failed constructing initial list of hosts", (Throwable)e);
                }
                return false;
            }
        }
        return super.setProperties(props);
    }

    public void stop() {
        super.stop();
        if (this.client != null) {
            this.client.stop();
        }
    }

    public void localAddressSet(Address addr) {
        if (this.initial_hosts != null && this.local_addr != null) {
            List hlist;
            boolean inInitialHosts = false;
            Enumeration en = this.initial_hosts.elements();
            while (en.hasMoreElements() && !inInitialHosts) {
                hlist = (List)en.nextElement();
                if (!hlist.contains(this.local_addr)) continue;
                inInitialHosts = true;
            }
            if (!inInitialHosts) {
                hlist = new List();
                hlist.add(this.local_addr);
                this.initial_hosts.add(hlist);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("adding my address (" + this.local_addr + ") to initial_hosts; initial_hosts=" + this.initial_hosts));
                }
            }
        }
    }

    public void handleConnect() {
        if (this.client != null) {
            this.client.register(this.group_addr, this.local_addr);
        }
    }

    public void handleDisconnect() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    public void sendGetMembersRequest() {
        if (this.client != null) {
            java.util.List gossip_rsps = this.client.getMembers(this.group_addr);
            if (gossip_rsps == null || gossip_rsps.size() <= 0) {
                this.passUp(new Event(13, null));
                return;
            }
            Event view_event = new Event(15, this.makeView(new Vector(gossip_rsps)));
            this.passDown(view_event);
            if (gossip_rsps.size() > 0) {
                Iterator it = gossip_rsps.iterator();
                while (it.hasNext()) {
                    Address dest = (Address)it.next();
                    Message msg = new Message(dest, null, null);
                    msg.putHeader(this.getName(), new PingHeader(1, null));
                    this.passDown(new Event(1, msg));
                }
            }
            Util.sleep(500L);
        } else if (this.initial_hosts != null && this.initial_hosts.size() > 0) {
            Message msg = new Message(null);
            msg.putHeader(this.getName(), new PingHeader(1, null));
            Enumeration en = this.initial_hosts.elements();
            while (en.hasMoreElements()) {
                List hlist = (List)en.nextElement();
                boolean isMember = false;
                Enumeration hen = hlist.elements();
                while (hen.hasMoreElements() && !isMember) {
                    IpAddress h = (IpAddress)hen.nextElement();
                    msg.setDest(h);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest()));
                    }
                    this.passDown(new Event(1, msg.copy()));
                }
            }
        } else {
            PingHeader hdr = new PingHeader(1, null);
            Message msg = new Message(null);
            msg.putHeader(this.getName(), hdr);
            this.sendMcastDiscoveryRequest(msg);
        }
    }

    void sendMcastDiscoveryRequest(Message discovery_request) {
        this.passDown(new Event(1, discovery_request));
    }

    private List createInitialHosts(String l) throws UnknownHostException {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                String host = t.substring(0, t.indexOf(91));
                int port = Integer.parseInt(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                List hosts = new List();
                for (int i = port; i < port + this.port_range; ++i) {
                    hosts.add(new IpAddress(host, i));
                }
                tmp.add(hosts);
            }
            catch (NumberFormatException e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("exeption is " + e));
            }
        }
        return tmp;
    }
}

