/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.xml.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LocalEntityResolver
implements EntityResolver {
    private Map entityRegistry = LocalEntityResolver.createEntityRegistry();
    private static final Log log = LogFactory.getLog((Class)LocalEntityResolver.class);

    public InputSource resolveEntity(String publicId, String systemId) throws IOException {
        String entityResource = this.getResourceForEntity(publicId, systemId);
        if (entityResource == null) {
            return null;
        }
        URL entityURL = this.getClass().getResource(entityResource);
        if (entityURL == null) {
            throw new FileNotFoundException(entityResource);
        }
        return new InputSource(entityURL.toExternalForm());
    }

    private String getResourceForEntity(String publicId, String systemId) {
        String resource;
        if (publicId != null && (resource = (String)this.entityRegistry.get(publicId)) != null) {
            log.debug((Object)("public id '" + publicId + "' maps to resource: " + resource));
            return resource;
        }
        if (systemId != null && (resource = (String)this.entityRegistry.get(systemId)) != null) {
            log.debug((Object)("system id '" + systemId + "' maps to resource: " + resource));
            return resource;
        }
        return null;
    }

    private static Map createEntityRegistry() {
        HashMap<String, String> entityRegistry = new HashMap<String, String>();
        entityRegistry.put("-//W3C//DTD XMLSCHEMA 200102//EN", "XMLSchema.dtd");
        entityRegistry.put("datatypes", "datatypes.dtd");
        return entityRegistry;
    }
}

