/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.integration.jms;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.collection.PersistentMap;
import org.jbpm.bpel.integration.jms.RequestListener;

public class OutstandingRequest {
    private String replyQueueName;
    private String correlationID;
    private transient Queue replyQueue;
    private static final Log log = LogFactory.getLog((Class)OutstandingRequest.class);

    public OutstandingRequest(Queue replyQueue, String correlationID) throws JMSException {
        this.replyQueue = replyQueue;
        this.correlationID = correlationID;
        this.replyQueueName = replyQueue.getQueueName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendReply(Map parts, QName faultName, Session jmsSession) throws JMSException {
        MessageProducer producer = null;
        try {
            if (this.replyQueue == null) {
                this.replyQueue = jmsSession.createQueue(this.replyQueueName);
            }
            producer = jmsSession.createProducer((Destination)this.replyQueue);
            if (parts instanceof PersistentMap) {
                parts = new HashMap(parts);
            }
            ObjectMessage responseMsg = jmsSession.createObjectMessage((Serializable)parts);
            responseMsg.setJMSCorrelationID(this.correlationID);
            if (faultName != null) {
                responseMsg.setStringProperty("jbpm_bpel_faultName", faultName.getLocalPart());
            }
            producer.send((Message)responseMsg);
            log.debug((Object)("sent response: " + RequestListener.messageToString((Message)responseMsg)));
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    log.warn((Object)"could not close jms producer", (Throwable)e);
                }
            }
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("replyQueue", (Object)this.replyQueueName).append("correlationID", (Object)this.correlationID).toString();
    }

    public static class Key {
        private final long partnerLinkId;
        private final String operationName;
        private final String messageExchange;

        Key(long partnerLinkId, String operation, String messageExchange) {
            this.partnerLinkId = partnerLinkId;
            this.operationName = operation;
            this.messageExchange = messageExchange;
        }

        public long getPartnerLinkId() {
            return this.partnerLinkId;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String getMessageExchange() {
            return this.messageExchange;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return this.partnerLinkId == that.partnerLinkId && this.operationName.equals(that.operationName) && (this.messageExchange != null ? this.messageExchange.equals(that.messageExchange) : that.messageExchange == null);
        }

        public int hashCode() {
            return new HashCodeBuilder(239, 23).append(this.partnerLinkId).append((Object)this.operationName).append((Object)this.messageExchange).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("partnerLinkId", this.partnerLinkId).append("operationName", (Object)this.operationName).append("messageExchange", (Object)this.messageExchange).toString();
        }
    }
}

