/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.graph.scope;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jbpm.bpel.graph.def.Activity;
import org.jbpm.bpel.graph.def.CompositeActivity;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;

public class Handler
extends CompositeActivity
implements Serializable {
    private Activity activity;
    private static final long serialVersionUID = 1L;

    public Activity getActivity() {
        return this.activity;
    }

    public void setActivity(Activity activity) {
        if (this.activity != null) {
            this.unsetActivity();
        }
        if (activity != null) {
            activity.detachFromParent();
            this.adoptActivity(activity);
            this.activity = activity;
        }
    }

    private void unsetActivity() {
        this.disadoptActivity(this.activity);
        this.activity = null;
    }

    public void execute(ExecutionContext context) {
        this.activity.enter(context);
    }

    public Node addNode(Node node) {
        if (!(node instanceof Activity)) {
            throw new IllegalArgumentException("not an activity: " + node);
        }
        this.setActivity((Activity)node);
        return node;
    }

    public Node removeNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (!node.equals((Object)this.activity)) {
            return null;
        }
        this.unsetActivity();
        return node;
    }

    public void reorderNode(int oldIndex, int newIndex) {
        if (this.activity == null || oldIndex != 0 || newIndex != 0) {
            throw new IndexOutOfBoundsException("could not reorder element: oldIndex=" + oldIndex + ", newIndex=" + newIndex);
        }
    }

    public List getNodes() {
        return this.activity != null ? Collections.singletonList(this.activity) : null;
    }

    public Node getNode(String name) {
        return this.hasNode(name) ? this.activity : null;
    }

    public Map getNodesMap() {
        return this.activity != null ? Collections.singletonMap(this.activity.getName(), this.activity) : null;
    }

    public boolean hasNode(String name) {
        return this.activity != null && this.activity.getName().equals(name);
    }
}

