/*
 * Decompiled with CFR 0.152.
 */
package ccl.jcf;

import ccl.jcf.TypeDescriptor;
import ccl.swing.SwingUtil;
import ccl.util.ClassPathUtil;
import ccl.util.FileUtil;
import ccl.util.Util;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import lti.java.jcf.CptClass;
import lti.java.jcf.CptMemberOrInterface;
import lti.java.jcf.CptNameType;
import lti.java.jcf.JcfAttribute;
import lti.java.jcf.JcfAttributeCollection;
import lti.java.jcf.JcfClassFile;
import lti.java.jcf.JcfClassInputStream;
import lti.java.jcf.JcfCodeAttribute;
import lti.java.jcf.JcfConstantPool;
import lti.java.jcf.JcfMember;
import lti.java.jcf.JcfMemberCollection;

public class JCFUtil {
    private static final int[] aOpcodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 1, 3, 2, 3, 1, 1, 3, 3, 1, 1, 4, 4, 3, 3, 5, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final String[] asOpcode = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "xxxunusedxxx", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w", "breakpoint", "", "", "", "", "", "", "", "210", "", "", "", "", "", "", "", "", "", "220", "", "", "", "", "", "", "", "", "", "230", "", "", "", "", "", "", "", "", "", "240", "", "", "", "", "", "", "", "", "", "250", "", "", "", "impdep1", "impdep2"};

    public static String getAbsoluteClassFileName(String sFullClassName_, String sClasspath_) {
        return ClassPathUtil.getAbsoluteClassFileName(sFullClassName_, sClasspath_);
    }

    public static String getJarFileName(String sFullClassName_) throws IOException, ZipException {
        return ClassPathUtil.getJarFileName(sFullClassName_);
    }

    public static String getJarFileName(String sFullClassName_, String sClasspath_) throws IOException, ZipException {
        return ClassPathUtil.getJarFileName(sFullClassName_, sClasspath_);
    }

    public static JcfClassFile readClassFromJar(String sFullClassName_, String sClasspath_) throws IOException, ZipException {
        String sClassFileName = sFullClassName_.replace('.', '/') + ".class";
        Vector vClasspathElements = Util.stringToLines(sClasspath_, File.pathSeparatorChar);
        Enumeration eElements = vClasspathElements.elements();
        while (eElements.hasMoreElements()) {
            String sNextArchiv = (String)eElements.nextElement();
            if (!Util.endsWith(sNextArchiv, ".zip") && !Util.endsWith(sNextArchiv, ".jar") || !FileUtil.existsFile(sNextArchiv)) continue;
            ZipFile pZipFile = new ZipFile(sNextArchiv);
            ZipEntry pZipEntry = pZipFile.getEntry(sClassFileName);
            if (pZipEntry != null) {
                JcfClassFile pJcfClassFile = JCFUtil.readClassFile(pZipFile, pZipEntry);
                pZipFile.close();
                return pJcfClassFile;
            }
            pZipFile.close();
        }
        return null;
    }

    public static JcfClassFile readClassFile(byte[] abClass_) throws IOException {
        ByteArrayInputStream pInputStream = new ByteArrayInputStream(abClass_);
        JcfClassInputStream pJcfClassInputStream = null;
        pJcfClassInputStream = new JcfClassInputStream(new BufferedInputStream(pInputStream, Math.min(pInputStream.available(), Short.MAX_VALUE)));
        JcfClassFile pJcfClassFile = null;
        pJcfClassFile = new JcfClassFile(pJcfClassInputStream);
        pInputStream.close();
        return pJcfClassFile;
    }

    public static JcfClassFile readClassFile(ZipFile zipOpen_, ZipEntry pZipEntry_) throws IOException, ZipException {
        int compressedSize = (int)pZipEntry_.getCompressedSize();
        int uncompressedSize = (int)pZipEntry_.getSize();
        if (uncompressedSize == -1) {
            throw new ZipException();
        }
        byte[] abtClass = new byte[uncompressedSize];
        InputStream pInputStream = zipOpen_.getInputStream(pZipEntry_);
        int bytesRead = 0;
        while (bytesRead < uncompressedSize) {
            bytesRead += pInputStream.read(abtClass, bytesRead, uncompressedSize - bytesRead);
        }
        JcfClassFile pJcfClassFile = JCFUtil.readClassFile(abtClass);
        return pJcfClassFile;
    }

    public static String getClassOrJarFileName(String sFullClassName_) throws IOException, ClassNotFoundException, ZipException {
        return ClassPathUtil.getClassOrJarFileName(sFullClassName_);
    }

    public static String getClassOrJarFileName(String sFullClassName_, String sClasspath_) throws IOException, ClassNotFoundException, ZipException {
        return ClassPathUtil.getClassOrJarFileName(sFullClassName_, sClasspath_);
    }

    public static JcfClassFile readClassFile(String sFullClassName_, String sClasspath_) throws IOException, ClassNotFoundException, ZipException {
        String sAbsoluteClassFileName = JCFUtil.getAbsoluteClassFileName(sFullClassName_, sClasspath_);
        if (sAbsoluteClassFileName != null) {
            return JCFUtil.readClassFile(sAbsoluteClassFileName);
        }
        JcfClassFile pJcfClassFile = JCFUtil.readClassFromJar(sFullClassName_, sClasspath_);
        if (pJcfClassFile == null) {
            throw new ClassNotFoundException();
        }
        return pJcfClassFile;
    }

    public static JcfClassFile readClassFile(String sClassFullFileName_) throws IOException {
        FileInputStream pFileInputStream = null;
        JcfClassInputStream pJcfClassInputStream = null;
        pFileInputStream = new FileInputStream(sClassFullFileName_);
        pJcfClassInputStream = new JcfClassInputStream(new BufferedInputStream(pFileInputStream, Math.min(pFileInputStream.available(), Short.MAX_VALUE)));
        JcfClassFile pJcfClassFile = null;
        pJcfClassFile = new JcfClassFile(pJcfClassInputStream);
        pFileInputStream.close();
        return pJcfClassFile;
    }

    private static int _getIncrementedCodePointer(int codePointer_, byte[] abCode_) {
        Util.debug("JCFUtil._getIncrementedCodePointer(..).codePointer_: " + codePointer_);
        Util.debug("JCFUtil._getIncrementedCodePointer(..).abCode_.length: " + abCode_.length);
        int opcode = Util.byteToInt(abCode_[codePointer_]);
        Util.debug("JCFUtil._getIncrementedCodePointer(..).opcode: " + opcode);
        if (opcode == 196) {
            if (abCode_[codePointer_ + 1] == 132) {
                codePointer_ += 6;
            }
        } else if (opcode == 170) {
            codePointer_ += 4 - codePointer_ % 4 + 4;
            byte[] abSignedInt = new byte[]{abCode_[codePointer_++], abCode_[codePointer_++], abCode_[codePointer_++], abCode_[codePointer_++]};
            int low = Util.bytesToInt(abSignedInt);
            abSignedInt[0] = abCode_[codePointer_++];
            abSignedInt[1] = abCode_[codePointer_++];
            abSignedInt[2] = abCode_[codePointer_++];
            abSignedInt[3] = abCode_[codePointer_++];
            int n = Util.bytesToInt(abSignedInt) - low + 1;
            codePointer_ += n * 4;
        } else if (opcode == 171) {
            codePointer_ += 4 - codePointer_ % 4 + 4;
            byte[] abSignedInt = new byte[]{abCode_[codePointer_++], abCode_[codePointer_++], abCode_[codePointer_++], abCode_[codePointer_++]};
            int n = Util.bytesToInt(abSignedInt);
            codePointer_ += n * 8;
        } else {
            codePointer_ += aOpcodeLength[opcode];
        }
        Util.debug("JCFUtil._getIncrementedCodePointer(..).codePointer_: " + codePointer_);
        return codePointer_;
    }

    public static String getParameters(String sSignature_) {
        String sDescriptors = sSignature_.substring(1, sSignature_.lastIndexOf(41));
        ByteArrayInputStream isParameters = new ByteArrayInputStream(sDescriptors.getBytes());
        TypeDescriptor pTypeDescriptor = new TypeDescriptor(isParameters);
        String sParameters = pTypeDescriptor.parse();
        return sParameters;
    }

    public static Hashtable getMethodCallees(Frame frmParent_, String sClassFullFileName_, String sMethod_) {
        Hashtable<String, Object> htMethodCallees = new Hashtable<String, Object>();
        Object oShare = new Object();
        JcfClassFile pJcfClassFile = null;
        try {
            pJcfClassFile = JCFUtil.readClassFile(sClassFullFileName_);
        }
        catch (Exception pException) {
            SwingUtil.showMessage(frmParent_, "Error: Exception while reading class file '" + sClassFullFileName_ + "':\n" + pException);
            return htMethodCallees;
        }
        JcfConstantPool pJcfConstantPool = pJcfClassFile.getConstantPool();
        JcfMemberCollection pJcfMemberCollection = pJcfClassFile.getMethods();
        Enumeration eMembers = pJcfMemberCollection.elements();
        String sMethodPrefix = sMethod_.substring(0, sMethod_.indexOf(40));
        while (eMembers.hasMoreElements()) {
            JcfMember pJcfMember = (JcfMember)eMembers.nextElement();
            String sMethodName = pJcfConstantPool.utfAt(pJcfMember.mbrNameIndex);
            if (!sMethodPrefix.equals(sMethodName)) continue;
            String sMethodSignature = pJcfConstantPool.utfAt(pJcfMember.mbrSignatureIndex);
            String sParameters = JCFUtil.getParameters(sMethodSignature);
            if (!sMethod_.equals(sMethodName + "(" + sParameters + ")")) continue;
            Util.debug("JCFUtil.getMethodCallees(..).METHOD_FOUND");
            JcfAttributeCollection pJcfAttributeCollection = pJcfMember.getAttributes();
            Enumeration eAttributes = pJcfAttributeCollection.elements();
            while (eAttributes.hasMoreElements()) {
                JcfAttribute pJcfAttribute = (JcfAttribute)eAttributes.nextElement();
                String sAttrname = pJcfConstantPool.utfAt(pJcfAttribute.getNameIndex());
                if (!sAttrname.equals("Code")) continue;
                JcfCodeAttribute pJcfCodeAttribute = (JcfCodeAttribute)pJcfAttribute;
                byte[] abCode = pJcfCodeAttribute.catCode;
                int codePointer = 0;
                while (codePointer < abCode.length) {
                    int opcode = Util.byteToInt(abCode[codePointer]);
                    Util.debug("JCFUtil.getMethodCallees(..).codePointer: " + codePointer);
                    Util.debug("JCFUtil.getMethodCallees(..).asOpcode[]: " + asOpcode[opcode]);
                    if (182 <= opcode && opcode <= 185) {
                        int methodIndex = 256 * Util.byteToInt(abCode[codePointer + 1]) + Util.byteToInt(abCode[codePointer + 2]);
                        CptMemberOrInterface pCptMemberOrInterface = (CptMemberOrInterface)pJcfConstantPool.elementAt(methodIndex);
                        short classIndex = pCptMemberOrInterface.classIndex;
                        CptClass pCptClass = (CptClass)pJcfConstantPool.elementAt(classIndex);
                        String sCalleeClassFullName = pJcfConstantPool.utfAt(pCptClass.nameIndex).replace('/', '.');
                        Util.debug("JCFUtil.getMethodCallees(..).sCalleeClassFullName: " + sCalleeClassFullName);
                        short nameTypeIndex = pCptMemberOrInterface.nameTypeIndex;
                        CptNameType pCptNameType = (CptNameType)pJcfConstantPool.elementAt(nameTypeIndex);
                        String sCalleeMethodName = pJcfConstantPool.utfAt(pCptNameType.nameIndex);
                        Util.debug("JCFUtil.getMethodCallees(..).sCalleeMethodName: " + sCalleeMethodName);
                        if (opcode == 183 && sCalleeMethodName.equals("<init>")) {
                            sCalleeMethodName = sCalleeClassFullName.substring(sCalleeClassFullName.lastIndexOf(46) + 1);
                        }
                        Util.debug("JCFUtil.getMethodCallees(..).sCalleeMethodName: " + sCalleeMethodName);
                        String sCalleeMethodSignature = pJcfConstantPool.utfAt(pCptNameType.signatureIndex);
                        Util.debug("JCFUtil.getMethodCallees(..).sCalleeMethodSignature: " + sCalleeMethodSignature);
                        String sMethodParameters = JCFUtil.getParameters(sCalleeMethodSignature);
                        String sCalleeMethod = sCalleeClassFullName + "." + sCalleeMethodName + "(" + sMethodParameters + ")";
                        Util.debug("JCFUtil.getMethodCallees(..).sCalleeMethod: " + sCalleeMethod);
                        htMethodCallees.put(sCalleeMethod, oShare);
                    }
                    codePointer = JCFUtil._getIncrementedCodePointer(codePointer, abCode);
                }
                Util.debug("Jacob.parseMethodCallees(..).codePointer: " + codePointer);
            }
            break block2;
        }
        return htMethodCallees;
    }

    public static String jwhich(String sClassName_, String sClasspath_) {
        return ClassPathUtil.jwhich(sClassName_, sClasspath_);
    }

    public static String getApplicationHome(Object oClass) {
        return ClassPathUtil.getApplicationHome(oClass);
    }
}

