/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.stores;

import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ResourceStoreClassLoader
extends ClassLoader {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$stores$ResourceStoreClassLoader == null ? (class$org$apache$commons$jci$stores$ResourceStoreClassLoader = ResourceStoreClassLoader.class$("org.apache.commons.jci.stores.ResourceStoreClassLoader")) : class$org$apache$commons$jci$stores$ResourceStoreClassLoader));
    private final ResourceStore[] stores;
    static /* synthetic */ Class class$org$apache$commons$jci$stores$ResourceStoreClassLoader;

    public ResourceStoreClassLoader(ClassLoader pParent, ResourceStore[] pStores) {
        super(pParent);
        this.stores = pStores;
    }

    private Class fastFindClass(String name) {
        if (this.stores != null) {
            for (int i = 0; i < this.stores.length; ++i) {
                ResourceStore store = this.stores[i];
                byte[] clazzBytes = store.read(name);
                if (clazzBytes == null) continue;
                log.debug((Object)("found class " + name + " (" + clazzBytes.length + " bytes)"));
                return this.defineClass(name, clazzBytes, 0, clazzBytes.length);
            }
        }
        log.debug((Object)("did not find class " + name));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        log.debug((Object)("looking for " + name));
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.fastFindClass(name);
            if (clazz == null) {
                ClassLoader parent = this.getParent();
                if (parent == null) throw new ClassNotFoundException(name);
                clazz = parent.loadClass(name);
                log.debug((Object)("loaded from parent: " + name));
            } else {
                log.debug((Object)("loaded from store: " + name));
            }
        }
        if (!resolve) return clazz;
        this.resolveClass(clazz);
        return clazz;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class clazz = this.fastFindClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

