/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.stores;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jci.stores.ResourceStore;

public final class FileResourceStore
implements ResourceStore {
    private final File root;

    public FileResourceStore(File pFile) {
        this.root = pFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(String pResourceName) {
        FileInputStream is = null;
        try {
            byte[] data;
            is = new FileInputStream(this.getFile(pResourceName));
            byte[] byArray = data = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String pResourceName, byte[] pData) {
        OutputStream os = null;
        try {
            File file = this.getFile(pResourceName);
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("could not create" + parent);
            }
            os = new FileOutputStream(file);
            os.write(pData);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void remove(String pResourceName) {
        this.getFile(pResourceName).delete();
    }

    private File getFile(String pResourceName) {
        String fileName = pResourceName.replace('/', File.separatorChar);
        return new File(this.root, fileName);
    }

    public String[] list() {
        ArrayList files = new ArrayList();
        this.list(this.root, files);
        return files.toArray(new String[files.size()]);
    }

    private void list(File pFile, List pFiles) {
        if (pFile.isDirectory()) {
            File[] directoryFiles = pFile.listFiles();
            for (int i = 0; i < directoryFiles.length; ++i) {
                this.list(directoryFiles[i], pFiles);
            }
        } else {
            pFiles.add(pFile.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1));
        }
    }

    public String toString() {
        return this.getClass().getName() + this.root.toString();
    }
}

